/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ArraysParser.java 56 2009-05-21 04:13:39Z yuta-takahashi $
 * $Revision: 56 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * p[XʂList&lt;Object[]&gt;ŕԋpp[T
 * 
 * @since 1.0
 */
public class ArraysParser extends TagParser<List<Object[]>> {

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * f[^Jn̒p[^
     */
    protected static final String PARAM_DATA_CLOMUN_FROM = "DataColumnFrom";

    /**
     * f[^Jn̒p[^
     */
    protected static final String PARAM_DATA_CLOMUN_TO = "DataColumnTo";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;

    /**
     * ftHgf[^Isl
     */
    protected static final int DEFAULT_VALUE_COLUMN_FROM_ADJUST = 0;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ArraysParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data BookControllerparseBook(), parseSheet()\bhA 
     *              SheetParserparseSheet\bhňnꍇ
     *              TagParser܂ňp鏈f[^
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<Object[]> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        List<Object[]> resultList = new ArrayList<Object[]>();

        // ^Os
        int tagRowIdx = tagCell.getRowIndex();
        // ^O
        int tagColIdx = tagCell.getColumnIndex();
        // f[^Jns
        int valueRowFromIdx;
        // f[^Is
        int valueRowToIdx = sheet.getLastRowNum();
        // f[^Jn
        int valueColumnFromIdx;
        // f[^I
        int valueColumnToIdx = 0;

        // f[^IwtO
        boolean valueColumnToFlag = false;

        try {

            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_VALUE_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

            // f[^Jn̒
            valueColumnFromIdx = TagUtil.adjustValue( tagColIdx, paramDef, PARAM_DATA_CLOMUN_FROM, DEFAULT_VALUE_COLUMN_FROM_ADJUST);
            if ( valueColumnFromIdx < 0 || valueColumnFromIdx > PoiUtil.getLastColNum( sheet)) {
                throw new ParseException( tagCell);
            }

            // f[^IwtO
            valueColumnToFlag = paramDef.containsKey( PARAM_DATA_CLOMUN_TO);
            if ( valueColumnToFlag) {
                // f[^I̒
                valueColumnToIdx = tagColIdx + Integer.valueOf( paramDef.get( PARAM_DATA_CLOMUN_TO));
                if ( valueColumnToIdx < valueColumnFromIdx || valueColumnToIdx < 0 || valueColumnToIdx > PoiUtil.getLastColNum( sheet)) {
                    throw new ParseException( tagCell);
                }
            }

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        // f[^s̉
        for ( int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; rowCnt++) {

            List<Object> objList = new ArrayList<Object>();

            Row row = sheet.getRow( rowCnt);
            if ( row == null) {
                // snull̏ꍇ
                continue;
            }
            if ( !valueColumnToFlag) {
                // f[^I̎w肪Ȃꍇ
                // es̏If[^IƂ
                valueColumnToIdx = row.getLastCellNum() - 1;
            }
            for ( int cellCnt = valueColumnFromIdx; cellCnt <= valueColumnToIdx; cellCnt++) {

                Cell cell = row.getCell( cellCnt);
                Object cellValue = PoiUtil.getCellValue( cell);
                objList.add( cellValue);
            }

            resultList.add( objList.toArray());
        }
        return resultList;
    }
}
