/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ListParser.java 56 2009-05-21 04:13:39Z yuta-takahashi $
 * $Revision: 56 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * ʂListŕԋpp[T
 * 
 * @since 1.0
 */
public class ListParser extends TagParser<List<?>> {

    /**
     * f[^s̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^s̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * l̒p[^
     */
    protected static final String PARAM_VALUE_COLUMN = "ValueColumn";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;

    /**
     * ftHgValue񒲐l
     */
    protected static final int DEFAULT_VALUE_COLUMN_ADJUST = 0;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ListParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data BookControllerparseBook(), parseSheet()\bhA 
     *              SheetParserparseSheet\bhňnꍇ
     *              TagParser܂ňp鏈f[^
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<?> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        // p[Xʊi[Xg
        List<Object> results = new ArrayList<Object>();

        try {
            // f[^͈
            int tagRowIdx = tagCell.getRowIndex();
            int valueRowFromIdx;
            int valueRowToIdx = sheet.getLastRowNum();
            int valueColIdx = tagCell.getColumnIndex();

            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_VALUE_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

            // Valueԍ̒
            valueColIdx = TagUtil.adjustValue( valueColIdx, paramDef, PARAM_VALUE_COLUMN, DEFAULT_VALUE_COLUMN_ADJUST);
            if ( valueColIdx > PoiUtil.getLastColNum( sheet) || valueColIdx < 0) {
                throw new ParseException( tagCell);
            }

            // p[X
            for ( int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; rowCnt++) {
                Row row = sheet.getRow( rowCnt);
                if ( row != null) {
                    Object value = PoiUtil.getCellValue( row.getCell( valueColIdx));
                    results.add( value);
                }
            }
        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        return results;
    }
}
