/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: MapsParser.java 56 2009-05-21 04:13:39Z yuta-takahashi $
 * $Revision: 56 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * p[XʂList&lt;Map&gt;ŕԋpp[T
 * 
 * @since 1.0
 */
public class MapsParser extends TagParser<List<Map<?, ?>>> {

    /**
     * L[s̒p[^
     */
    protected static final String PARAM_KEY_ROW = "KeyRow";

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * ftHgL[sl
     */
    protected static final int DEFAULT_KEY_ROW_ADJUST = 1;

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 2;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public MapsParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data BookControllerparseBook(), parseSheet()\bhA 
     *              SheetParserparseSheet\bhňnꍇ
     *              TagParser܂ňp鏈f[^
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<Map<?, ?>> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        List<Map<?, ?>> resultList = new ArrayList<Map<?, ?>>();

        // ^Os
        int tagRowIdx = tagCell.getRowIndex();
        // L[s
        int keyRowIdx;
        // f[^Jns
        int valueRowFromIdx;
        // f[^Is
        int valueRowToIdx = sheet.getLastRowNum();

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // L[s̒
            keyRowIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_KEY_ROW, DEFAULT_KEY_ROW_ADJUST);
            if ( keyRowIdx < 0 || keyRowIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_VALUE_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        // L[s̉
        List<Integer> targetColNums = new ArrayList<Integer>();
        Row keyRow = sheet.getRow( keyRowIdx);
        if ( keyRow == null) {
            // L[snull̏ꍇ
            return resultList;
        }
        int firstCellNum = keyRow.getFirstCellNum();
        int lastCellNum = keyRow.getLastCellNum();
        for ( int cellCnt = firstCellNum; cellCnt < lastCellNum; cellCnt++) {
            Cell cell = keyRow.getCell( cellCnt);
            Object cellValue = PoiUtil.getCellValue( cell);
            if ( cellValue instanceof String) {
                String keyName = ( String) cellValue;
                if ( keyName.startsWith( BookController.COMMENT_PREFIX)) {
                    continue;
                }
            }
            if ( cellValue != null) {
                targetColNums.add( cellCnt);
            }
        }

        if ( targetColNums.size() > 0) {
            // Ώۗ񂪂ꍇ

            // f[^̉
            for ( int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; rowCnt++) {
                Row dataRow = sheet.getRow( rowCnt);
                if ( dataRow == null) {
                    continue;
                }
                Map<Object, Object> map = new LinkedHashMap<Object, Object>();
                for ( Integer colCnt : targetColNums) {
                    Cell keyCell = keyRow.getCell( colCnt);
                    Cell valueCell = dataRow.getCell( colCnt);

                    Object key = PoiUtil.getCellValue( keyCell);
                    Object value = PoiUtil.getCellValue( valueCell);

                    map.put( key, value);
                }
                resultList.add( map);
            }
        }

        return resultList;
    }
}
