/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: BookDataTest.java 2 2009-05-08 07:39:20Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core;

import java.util.Collection;

import org.junit.Assert;
import org.junit.Test;

/**
 * BookDataeXgNX
 * 
 * @since 1.0
 */
public class BookDataTest {
    
    @Test
    public void testBookData() {
        
        BookData bookData = new BookData();
        SheetData sheetData = new SheetData("Sheet1");
        bookData.putSheetData( "Sheet1", sheetData);
        
        // ===============================================
        // containsSheet(String sheetName)
        // ===============================================
        //݂V[g
        Assert.assertTrue( bookData.containsSheet( "Sheet1"));
        //݂ȂV[g
        Assert.assertFalse( bookData.containsSheet( "hogehoge"));

        
        // ===============================================
        // getSheetDatas()
        // ===============================================
        Collection<SheetData> collection = bookData.getSheetDatas();
        Assert.assertEquals( sheetData, collection.iterator().next());
        
        
        // ===============================================
        // putSheetData(String sheetName, SheetData sheetData)
        // ===============================================
        //݂SheetData
        Assert.assertSame( sheetData, bookData.putSheetData( "Sheet1", sheetData));
        //݂ȂSheetData
        Assert.assertNotSame( sheetData, bookData.putSheetData( "Sheet4", sheetData));

    }
    
}
