/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ListParserTest.java 2 2009-05-08 07:39:20Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.WorkbookTest;
import org.bbreak.excella.core.exception.ParseException;
import org.junit.Test;

/**
 * ListParsereXgNX
 * 
 * @since 1.0
 */
public class ListParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public ListParserTest( String version) {
        super( version);
    }

    @Test
    public final void testListParser() throws ParseException {
        Workbook wk = getWorkbook();
        Sheet sheet = wk.getSheetAt( 0);
        ListParser listParser = new ListParser( "@List");
        Cell tagCell = null;
        Object data = null;
        List<?> list = null;

        // No.1 @List
        tagCell = sheet.getRow( 2).getCell( 0);
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf1", list.get( 0));
        assertEquals( "vf2", list.get( 1));
        assertEquals( "@List{DataRowFrom=2,DataRowTo=5}", list.get( 2));
        assertEquals( "Xg", list.get( 3));
        assertEquals( "vf3", list.get( 4));
        assertEquals( "vf4", list.get( 5));
        assertEquals( "vf5", list.get( 6));
        assertEquals( "@List{DataRowFrom=2,DataRowTo=3,ValueColumn=1}", list.get( 7));
        assertEquals( null, list.get( 8));
        assertEquals( null, list.get( 9));
        assertEquals( null, list.get( 10));
        assertEquals( "@List{ValueColumn=-1}", list.get( 11));
        assertEquals( "vf8", list.get( 12));
        assertEquals( 13, list.size());

        // No.2 @List{DataRowFrom=2,DataRowTo=5}
        tagCell = sheet.getRow( 6).getCell( 0);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf3", list.get( 0));
        assertEquals( "vf4", list.get( 1));
        assertEquals( "vf5", list.get( 2));
        assertEquals( 3, list.size());

        // No.3 @List{DataRowFrom=2,DataRowTo=3,ValueColumn=1}
        tagCell = sheet.getRow( 14).getCell( 0);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf6", list.get( 0));
        assertEquals( "vf7", list.get( 1));
        assertEquals( 2, list.size());

        // No.4 @List{ValueColumn=-1}(1ڂɏĂꍇ)
        tagCell = sheet.getRow( 24).getCell( 0);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 24, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.5 @List{DataRowFrom=-1}(1sڂɏĂꍇ)
        tagCell = sheet.getRow( 0).getCell( 4);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.6 @List{DataRowFrom=1}(wV[g̍ŏIsɏĂꍇ)
        tagCell = sheet.getRow( 25).getCell( 4);
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 25, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.7 @List{DataRowTo=-1}(1sڂɏĂꍇ)
        tagCell = sheet.getRow( 0).getCell( 7);
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
        }

        // No.8 @List{DataRowTo=1}(wV[g̍ŏIsɏĂꍇ)
        tagCell = sheet.getRow( 25).getCell( 7);
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 25, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
        }

        // No.9 @List{ValueColumn=1}(ŏIɏĂꍇ)
        tagCell = sheet.getRow( 2).getCell( 10);
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 10, cell.getColumnIndex());
        }

        // V[gύX
        sheet = wk.getSheetAt( 1);

        // No.10 @List{DataRowFrom=3,DataRowTo=1}(DataRowFrom > DataRowTo ̏ꍇ)
        tagCell = sheet.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.11 @List{DataRowFrom=-1,DataRowTo=-3}(p[^}CiXl)
        tagCell = sheet.getRow( 13).getCell( 0);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf2-4", list.get( 0));
        assertEquals( "vf2-5", list.get( 1));
        assertEquals( "vf2-6", list.get( 2));
        assertEquals( 3, list.size());

        // No.12 @List{ValueColumn=-1}(p[^}CiXl)
        tagCell = sheet.getRow( 29).getCell( 1);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf2-7", list.get( 0));
        assertEquals( "vf2-8", list.get( 1));
        assertEquals( "vf2-9", list.get( 2));
        assertEquals( 3, list.size());

        // No.13 @List{DataRowFrom=1}(DataRowFrom݂̂ݒ)
        tagCell = sheet.getRow( 27).getCell( 4);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf2-10", list.get( 0));
        assertEquals( "vf2-11", list.get( 1));
        assertEquals( "vf2-12", list.get( 2));
        assertEquals( null, list.get( 3));
        assertEquals( "vf2-13", list.get( 4));
        assertEquals( 5, list.size());

        // No.14 @List{DataRowTo=2}(DataRowTô݂ݒ)
        tagCell = sheet.getRow( 27).getCell( 8);
        list.clear();
        list = listParser.parse( sheet, tagCell, data);
        assertEquals( "vf2-14", list.get( 0));
        assertEquals( "vf2-15", list.get( 1));
        assertEquals( 2, list.size());

        // No.15 @List{DataRowFrom=}(DataRowFroml)
        tagCell = sheet.getRow( 0).getCell( 4);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.16 @List{DataRowTo=}(DataRowTol)
        tagCell = sheet.getRow( 9).getCell( 4);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 9, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.17 @List{ValueColumn=}(ValueColumnl)
        tagCell = sheet.getRow( 18).getCell( 4);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.18 @List{DataRowFrom=a}(DataRowFroml)
        tagCell = sheet.getRow( 0).getCell( 7);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
        }

        // No.19 @List{DataRowTo=a}(DataRowTol)
        tagCell = sheet.getRow( 9).getCell( 7);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 9, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
        }

        // No.20 @List{ValueColumn=a}(ValueColumnl)
        tagCell = sheet.getRow( 18).getCell( 7);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
        }
        

        // V[gύX
        sheet = wk.getSheetAt( 1);

        // No.21 @List(vfȂ)
        tagCell = sheet.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = listParser.parse( sheet, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }
        
    }

}
