/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ObjectsParserTest.java 92 2009-05-29 04:43:52Z yuta-takahashi $
 * $Revision: 92 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.WorkbookTest;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.excel2java.entity.TargetEntity;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * ObjectsParsereXgNX
 * 
 * @since 1.0
 */
public class ObjectsParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public ObjectsParserTest( String version) {
        super( version);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testObjectsParser() throws ParseException, java.text.ParseException {
        Workbook wk = getWorkbook();
        Sheet sheet1 = wk.getSheetAt( 0);
        Sheet sheet2 = wk.getSheetAt( 1);
        Sheet sheet3 = wk.getSheetAt( 2);
        Sheet sheet4 = wk.getSheetAt( 3);
        Sheet sheet5 = wk.getSheetAt( 4);
        ObjectsParser objectsParser = new ObjectsParser( "@Objects");
        Cell tagCell = null;
        Object data = null;
        List<Object> list = null;

        // No.1 p[^
        tagCell = sheet1.getRow( 5).getCell( 0);
        try {
            list = objectsParser.parse( sheet1, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 5, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.2 NXw
        tagCell = sheet1.getRow( 13).getCell( 0);
        list = objectsParser.parse( sheet1, tagCell, data);
        TargetEntity targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Integer( "1"), targetEntity.getNumberInteger());
        assertEquals( 2, targetEntity.getNumberInt());
        assertEquals( new Long( "3"), targetEntity.getNumberLong());
        assertEquals( 4, targetEntity.getNumberlong());
        assertEquals( new Float( "5.5"), targetEntity.getNumberFloat());
        assertEquals( "6.6", String.valueOf( targetEntity.getNumberfloat()));
        assertEquals( new Double( "8.8"), targetEntity.getNumberDouble());
        assertEquals( "9.9", String.valueOf( targetEntity.getNumberdouble()));
        assertEquals( new BigDecimal( 10.1), targetEntity.getNumberDecimal());
        assertEquals( new Byte( "11"), targetEntity.getNumberByte());
        assertEquals( 12, targetEntity.getNumberbyte());
        assertEquals( Boolean.TRUE, targetEntity.getValueBoolean());
        assertEquals( Boolean.FALSE, targetEntity.isValueboolean());
        assertEquals( DateFormat.getDateInstance().parse( "2009/4/13"), targetEntity.getDate());
        assertEquals( "", targetEntity.getString());
        assertEquals( 1, list.size());

        // No.3 L[AJnAIw
        tagCell = sheet2.getRow( 4).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Integer( "1"), targetEntity.getNumberInteger());
        assertEquals( 3, targetEntity.getNumberInt());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( new Integer( "2"), targetEntity.getNumberInteger());
        assertEquals( 4, targetEntity.getNumberInt());
        assertEquals( 2, list.size());

        // No.4 RgL
        tagCell = sheet2.getRow( 13).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Integer( "5"), targetEntity.getNumberInteger());
        assertEquals( 9, targetEntity.getNumberInt());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( new Integer( "6"), targetEntity.getNumberInteger());
        assertEquals( 10, targetEntity.getNumberInt());
        assertEquals( 2, list.size());

        // No.5 L[snull
        tagCell = sheet2.getRow( 20).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        assertEquals( 0, list.size());

        // No.6 L[Znull
        tagCell = sheet2.getRow( 28).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( 20000000, targetEntity.getNumberlong());
        assertEquals( new Long( "26000000"), targetEntity.getNumberLong());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( 21000000, targetEntity.getNumberlong());
        assertEquals( new Long( "27000000"), targetEntity.getNumberLong());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( 22000000, targetEntity.getNumberlong());
        assertEquals( new Long( "28000000"), targetEntity.getNumberLong());
        assertEquals( 3, list.size());

        // No.7 L[Zlnull
        tagCell = sheet2.getRow( 36).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( 29000000, targetEntity.getNumberlong());
        assertEquals( new Long( "35000000"), targetEntity.getNumberLong());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( 30000000, targetEntity.getNumberlong());
        assertEquals( new Long( "36000000"), targetEntity.getNumberLong());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( 31000000, targetEntity.getNumberlong());
        assertEquals( new Long( "37000000"), targetEntity.getNumberLong());
        assertEquals( 3, list.size());

        // No.8 lsnull
        tagCell = sheet2.getRow( 44).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Float( "38000000"), targetEntity.getNumberFloat());
        assertEquals( 40000000, targetEntity.getNumberfloat(), 0.01);
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( new Float( "39000000"), targetEntity.getNumberFloat());
        assertEquals( 41000000, targetEntity.getNumberfloat(), 0.01);
        assertEquals( 2, list.size());

        // No.9 lZnull
        tagCell = sheet2.getRow( 52).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Float( "42000000"), targetEntity.getNumberFloat());
        assertEquals( new Double( "44000000"), targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( null, targetEntity.getNumberFloat());
        assertEquals( null, targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( new Float( "43000000"), targetEntity.getNumberFloat());
        assertEquals( new Double( "45000000"), targetEntity.getNumberDouble());
        assertEquals( 3, list.size());

        // No.10 lZlnull
        tagCell = sheet2.getRow( 60).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Float( "46000000"), targetEntity.getNumberFloat());
        assertEquals( new Double( "48000000"), targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( null, targetEntity.getNumberFloat());
        assertEquals( null, targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( new Float( "47000000"), targetEntity.getNumberFloat());
        assertEquals( new Double( "49000000"), targetEntity.getNumberDouble());
        assertEquals( 3, list.size());

        // No.11 dL[L
        tagCell = sheet2.getRow( 68).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet2, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Double( "8.8888888"), targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( null, targetEntity.getNumberDouble());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( new Double( "9.9999999"), targetEntity.getNumberDouble());
        assertEquals( 3, list.size());

        // No.12 }CiX͈͎w
        tagCell = sheet3.getRow( 7).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet3, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( Boolean.TRUE, targetEntity.getValueBoolean());
        assertEquals( "l1", targetEntity.getString());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( Boolean.TRUE, targetEntity.getValueBoolean());
        assertEquals( "l2", targetEntity.getString());
        targetEntity = ( TargetEntity) list.get( 2);
        assertEquals( Boolean.FALSE, targetEntity.getValueBoolean());
        assertEquals( "l3", targetEntity.getString());
        targetEntity = ( TargetEntity) list.get( 3);
        assertEquals( Boolean.FALSE, targetEntity.getValueBoolean());
        assertEquals( "l4", targetEntity.getString());
        assertEquals( 4, list.size());

        // No.13 vpeBƃf[^𓯂Ɏw
        tagCell = sheet3.getRow( 12).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet3, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( "string", targetEntity.getString());
        assertEquals( 1, list.size());

        // No.14 DataRowFrom > DataRowTo
        tagCell = sheet3.getRow( 21).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 21, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.15 PropertyRowsilj
        tagCell = sheet3.getRow( 27).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 27, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.16 DataRowFromsilj
        tagCell = sheet3.getRow( 30).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 30, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.17 DataRowTosilj
        tagCell = sheet3.getRow( 33).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 33, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.18 PropertyRowsilj
        tagCell = sheet3.getRow( 36).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 36, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.19 DataRowFromsilj
        tagCell = sheet3.getRow( 39).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 39, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.20 DataRowTosilj
        tagCell = sheet3.getRow( 42).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 42, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.21 Classsi݂ȂNXwj
        tagCell = sheet3.getRow( 46).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 46, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.22 ݂ȂvpeBw
        tagCell = sheet3.getRow( 50).getCell( 0);
        list.clear();
        list = objectsParser.parse( sheet3, tagCell, data);
        assertEquals( 0, list.size());

        // No.23 f[^^s
        tagCell = sheet3.getRow( 55).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 57, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.24 NXɒۃNXw
        tagCell = sheet3.getRow( 61).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 62, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.25 NX̃RXgN^private
        tagCell = sheet3.getRow( 67).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 68, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.26 qGeBeB̃vpeBw
        tagCell = sheet3.getRow( 73).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 74, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.27 JX^p[TeXg
        tagCell = sheet4.getRow( 1).getCell( 0);
        ChildNameParser childNameParser = new ChildNameParser( "");
        childNameParser.setTag( "@childName");
        assertEquals( "@childName", childNameParser.getTag());
        assertEquals( Boolean.FALSE, childNameParser.isParse( sheet4, null));

        objectsParser.addPropertyParser( childNameParser);
        list.clear();
        list = objectsParser.parse( sheet4, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( "childName1", targetEntity.getChildEntity().getChildName());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( "childName2", targetEntity.getChildEntity().getChildName());
        assertEquals( 2, list.size());

        // No.28 JX^p[T폜
        tagCell = sheet4.getRow( 8).getCell( 0);
        list.clear();
        objectsParser.removePropertyParser( childNameParser);
        list = objectsParser.parse( sheet4, tagCell, data);
        assertEquals( 0, list.size());

        // No.29 ̃JX^p[Tw
        tagCell = sheet4.getRow( 15).getCell( 0);
        list.clear();
        ChildNoParser childNoParser = new ChildNoParser( "@childNo");
        objectsParser.addPropertyParser( childNameParser);
        objectsParser.addPropertyParser( childNoParser);
        list = objectsParser.parse( sheet4, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Integer( "55"), targetEntity.getNumberInteger());
        assertEquals( "childName5", targetEntity.getChildEntity().getChildName());
        assertEquals( 5, targetEntity.getChildEntity().getChildNo());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( new Integer( "66"), targetEntity.getNumberInteger());
        assertEquals( "childName6", targetEntity.getChildEntity().getChildName());
        assertEquals( 6, targetEntity.getChildEntity().getChildNo());
        assertEquals( 2, list.size());

        // No.30 JX^p[TS폜
        tagCell = sheet4.getRow( 22).getCell( 0);
        list.clear();
        objectsParser.clearPropertyParsers();
        list = objectsParser.parse( sheet4, tagCell, data);
        targetEntity = ( TargetEntity) list.get( 0);
        assertEquals( new Integer( "77"), targetEntity.getNumberInteger());
        assertEquals( null, targetEntity.getChildEntity());
        targetEntity = ( TargetEntity) list.get( 1);
        assertEquals( new Integer( "88"), targetEntity.getNumberInteger());
        assertEquals( null, targetEntity.getChildEntity());
        assertEquals( 2, list.size());

        // No.31 PropertyRowseXgi1sڂŃvpeBsɃ}CiXwj
        tagCell = sheet5.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.32 DataRowFromseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet5.getRow( 0).getCell( 8);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 8, cell.getColumnIndex());
        }

        // No.33 DataRowToseXgi1sڂŃf[^IsɃ}CiXwj
        tagCell = sheet5.getRow( 0).getCell( 16);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
        }

        // No.34 PropertyRowseXgiŏIsŃvpeBsɃvXwj
        tagCell = sheet5.getRow( 18).getCell( 0);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.35 DataRowFromseXgiŏIsŃf[^JnsɃvXwj
        tagCell = sheet5.getRow( 18).getCell( 8);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 8, cell.getColumnIndex());
        }

        // No.36 DataRowToseXgiŏIsŃf[^IsɃvXwj
        tagCell = sheet5.getRow( 18).getCell( 16);
        list.clear();
        try {
            list = objectsParser.parse( sheet5, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
        }
    }

}
