/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;

public class SVNCompositeConfigFile {
    private SVNConfigFile myUserFile;
    private SVNConfigFile mySystemFile;

    public SVNCompositeConfigFile(SVNConfigFile systemFile, SVNConfigFile userFile) {
        this.mySystemFile = systemFile;
        this.myUserFile = userFile;
    }

    public Map getProperties(String groupName) {
        Map system = this.mySystemFile.getProperties(groupName);
        Map user = this.myUserFile.getProperties(groupName);
        system.putAll(user);
        return system;
    }

    public String getPropertyValue(String groupName, String propertyName) {
        String value = this.myUserFile.getPropertyValue(groupName, propertyName);
        if (value == null) {
            value = this.mySystemFile.getPropertyValue(groupName, propertyName);
        }
        return value;
    }

    public void setPropertyValue(String groupName, String propertyName, String propertyValue, boolean save) {
        this.myUserFile.setPropertyValue(groupName, propertyName, propertyValue, save);
    }

    public boolean isModfied() {
        return this.myUserFile.isModified();
    }

    public void save() {
        this.myUserFile.save();
    }
}

