/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ConsoleExporter.java 62 2009-05-21 07:35:40Z akira-yokoi $
 * $Revision: 62 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.exporter.book;

import java.util.List;

import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;

/**
 * ͌ʂ̃f[^R\[(Wo)ɏo͂NX
 * 
 * @since 1.0
 */
public class ConsoleExporter implements BookExporter {

    /**
     * 
     */
    public void setup() {
    }

    /**
     * s
     */
    public void export( Workbook book, BookData bookdata) throws ExportException {
        List<String> sheetNames = bookdata.getSheetNames();
        // V[gPʂŏo͂s
        for ( String sheetName : sheetNames) {
            SheetData sheetData = bookdata.getSheetData( sheetName);
            System.out.println( sheetData.toString());
        }
    }

    /**
     * I
     */
    public void tearDown() {
    }
}
