/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: MapParser.java 128 2009-07-02 06:32:17Z yuta-takahashi $
 * $Revision: 128 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * p[Xʂ}bvŕԋpp[T
 * 
 * @since 1.0
 */
public class MapParser extends TagParser<Map<?, ?>> {

    /**
     * Zʒu`؂蕶
     */
    protected static final String PARAM_CELL_DELIM = ":";

    /**
     * ؂蕶OpCfbNX
     */
    protected static final int SPLIT_FIRST_INDEX = 0;

    /**
     * ؂蕶㔼pCfbNX
     */
    protected static final int SPLIT_LAST_INDEX = 1;

    /**
     * f[^s̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^s̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * L[̒p[^
     */
    protected static final String PARAM_KEY_COLUMN = "KeyColumn";

    /**
     * l̒p[^
     */
    protected static final String PARAM_VALUE_COLUMN = "ValueColumn";

    /**
     * L[Z̒p[^
     */
    protected static final String PARAM_KEY_CELL = "KeyCell";

    /**
     * ŒL[̒lp[^
     */
    protected static final String PARAM_KEY = "Key";

    /**
     * Œl̒lp[^
     */
    protected static final String PARAM_VALUE = "Value";

    /**
     * lZ̒p[^
     */
    protected static final String PARAM_VALUE_CELL = "ValueCell";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;

    /**
     * ftHgL[񒲐l
     */
    protected static final int DEFAULT_KEY_COLUMN_ADJUST = 0;

    /**
     * ftHgl񒲐l
     */
    protected static final int DEFAULT_VALUE_COLUMN_ADJUST = 1;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public MapParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data BookControllerparseBook(), parseSheet()\bhA<BR>
     *              SheetParserparseSheet\bhňnꍇ<BR>
     *              TagParser܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public Map<?, ?> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        // ^Os
        int tagRowIdx = tagCell.getRowIndex();
        // ^O
        int tagColIdx = tagCell.getColumnIndex();
        // f[^Jns
        int valueRowFromIdx;
        // f[^Is
        int valueRowToIdx = sheet.getLastRowNum();

        // L[
        int keyColIdx = 0;
        // l
        int valueColIdx = 0;

        // L[^OLtO
        boolean keyTagFlag;
        // l^OLtO
        boolean valueTagFlag;

        // L[
        String defKey = null;
        // l
        String defValue = null;

        // L[Z^OLtO
        boolean keyCellTagFlag;
        // lZ^OLtO
        boolean valueCellTagFlag;

        // L[s
        int keyRowIdx = 0;
        // ls
        int valueRowIdx = 0;

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // p[^`FbN
            checkParam( paramDef, tagCell);

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_VALUE_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_FROM);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_TO);
            }

            // f[^JnsƏIs̊֌W`FbN
            if ( valueRowFromIdx > valueRowToIdx) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_FROM + "," + PARAM_DATA_ROW_TO);
            }

            keyTagFlag = paramDef.containsKey( PARAM_KEY);
            keyCellTagFlag = paramDef.containsKey( PARAM_KEY_CELL);

            if ( keyTagFlag) {
                // L[^Oꍇ
                defKey = paramDef.get( PARAM_KEY);

            } else if ( keyCellTagFlag) {
                // L[Z^Oꍇ
                String value = paramDef.get( PARAM_KEY_CELL);

                // L[sԍ̒
                keyRowIdx = tagRowIdx + Integer.valueOf( value.split( PARAM_CELL_DELIM)[SPLIT_FIRST_INDEX]);
                if ( keyRowIdx < 0 || keyRowIdx > sheet.getLastRowNum()) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_KEY_CELL);
                }
                // L[ԍ̒
                keyColIdx = tagColIdx + Integer.valueOf( value.split( PARAM_CELL_DELIM)[SPLIT_LAST_INDEX]);
                if ( keyColIdx > PoiUtil.getLastColNum( sheet) || keyColIdx < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_KEY_CELL);
                }

            } else {
                // ȊȌꍇ
                // L[ԍ̒
                keyColIdx = TagUtil.adjustValue( tagColIdx, paramDef, PARAM_KEY_COLUMN, DEFAULT_KEY_COLUMN_ADJUST);
                if ( keyColIdx > PoiUtil.getLastColNum( sheet) || keyColIdx < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_KEY_COLUMN);
                }
            }

            valueTagFlag = paramDef.containsKey( PARAM_VALUE);
            valueCellTagFlag = paramDef.containsKey( PARAM_VALUE_CELL);

            if ( valueTagFlag) {
                // l^Oꍇ
                defValue = paramDef.get( PARAM_VALUE);

            } else if ( valueCellTagFlag) {
                // lZ^Oꍇ
                String value = paramDef.get( PARAM_VALUE_CELL);

                // lsԍ̒
                valueRowIdx = tagRowIdx + Integer.valueOf( value.split( PARAM_CELL_DELIM)[SPLIT_FIRST_INDEX]);
                if ( valueRowIdx < 0 || valueRowIdx > sheet.getLastRowNum()) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_VALUE_CELL);
                }

                // lԍ̒
                valueColIdx = tagColIdx + Integer.valueOf( value.split( PARAM_CELL_DELIM)[SPLIT_LAST_INDEX]);
                if ( valueColIdx > PoiUtil.getLastColNum( sheet) || valueColIdx < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_VALUE_CELL);
                }

            } else {
                // ȊȌꍇ
                // lԍ̒
                valueColIdx = TagUtil.adjustValue( tagColIdx, paramDef, PARAM_VALUE_COLUMN, DEFAULT_VALUE_COLUMN_ADJUST);
                if ( valueColIdx > PoiUtil.getLastColNum( sheet) || valueColIdx < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_VALUE_COLUMN);
                }
            }

        } catch ( Exception e) {
            if ( e instanceof ParseException) {
                throw ( ParseException) e;
            } else {
                throw new ParseException( tagCell, e);
            }
        }

        // p[X
        Map<Object, Object> results = new LinkedHashMap<Object, Object>();
        Row keyRow = null;
        Row valueRow = null;
        for ( int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; rowCnt++) {

            Object key;
            Object value;

            if ( keyTagFlag) {
                // L[^Oꍇ
                key = defKey;

            } else {
                // L[^OȂꍇ

                // L[s̎擾
                if ( keyCellTagFlag) {
                    // L[Z^Oꍇ
                    keyRow = sheet.getRow( keyRowIdx);
                } else {
                    // L[Z^OȂꍇ
                    keyRow = sheet.getRow( rowCnt);
                }

                if ( keyRow == null) {
                    continue;
                }
                key = PoiUtil.getCellValue( keyRow.getCell( keyColIdx));
            }

            if ( valueTagFlag) {
                // l^Oꍇ
                value = defValue;

            } else {
                // l^OȂꍇ

                // ls̎擾
                if ( valueCellTagFlag) {
                    // lZ^Oꍇ
                    valueRow = sheet.getRow( valueRowIdx);
                } else {
                    // lZ^OȂꍇ
                    valueRow = sheet.getRow( rowCnt);
                }
                if ( valueRow != null) {
                    value = PoiUtil.getCellValue( valueRow.getCell( valueColIdx));
                } else {
                    value = null;
                }
            }
            results.put( key, value);
        }
        return results;
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef p[^}bv
     * @param tagCell ^ÔZ
     * @throws ParseException p[XO
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
        // L[
        if ( paramDef.containsKey( PARAM_KEY) && paramDef.containsKey( PARAM_KEY_COLUMN)) {
            throw new ParseException( tagCell, "d`F" + PARAM_KEY + "," + PARAM_KEY_COLUMN);
        } else if ( paramDef.containsKey( PARAM_KEY) && paramDef.containsKey( PARAM_KEY_CELL)) {
            throw new ParseException( tagCell, "d`F" + PARAM_KEY + "," + PARAM_KEY_CELL);
        } else if ( paramDef.containsKey( PARAM_KEY_COLUMN) && paramDef.containsKey( PARAM_KEY_CELL)) {
            throw new ParseException( tagCell, "d`F" + PARAM_KEY_COLUMN + "," + PARAM_KEY_CELL);
        }

        // l
        if ( paramDef.containsKey( PARAM_VALUE) && paramDef.containsKey( PARAM_VALUE_COLUMN)) {
            throw new ParseException( tagCell, "d`F" + PARAM_VALUE + "," + PARAM_VALUE_COLUMN);
        } else if ( paramDef.containsKey( PARAM_VALUE) && paramDef.containsKey( PARAM_VALUE_CELL)) {
            throw new ParseException( tagCell, "d`F" + PARAM_VALUE + "," + PARAM_VALUE_CELL);
        } else if ( paramDef.containsKey( PARAM_VALUE_COLUMN) && paramDef.containsKey( PARAM_VALUE_CELL)) {
            throw new ParseException( tagCell, "d`F" + PARAM_VALUE_COLUMN + "," + PARAM_VALUE_CELL);
        }
    }
}
