/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;

public final class XSSFName
implements Name {
    public static final String BUILTIN_PRINT_AREA = "_xlnm.Print_Area";
    public static final String BUILTIN_PRINT_TITLE = "_xlnm.Print_Titles";
    public static final String BUILTIN_CRITERIA = "_xlnm.Criteria:";
    public static final String BUILTIN_EXTRACT = "_xlnm.Extract:";
    public static final String BUILTIN_FILTER_DB = "_xlnm._FilterDatabase:";
    public static final String BUILTIN_CONSOLIDATE_AREA = "_xlnm.Consolidate_Area";
    public static final String BUILTIN_DATABASE = "_xlnm.Database";
    public static final String BUILTIN_SHEET_TITLE = "_xlnm.Sheet_Title";
    private XSSFWorkbook workbook;
    private CTDefinedName ctName;

    protected XSSFName(CTDefinedName name, XSSFWorkbook workbook) {
        this.workbook = workbook;
        this.ctName = name;
    }

    protected CTDefinedName getCTName() {
        return this.ctName;
    }

    public String getNameName() {
        return this.ctName.getName();
    }

    public void setNameName(String name) {
        XSSFName.validateName(name);
        int sheetIndex = this.getSheetIndex();
        for (int i = 0; i < this.workbook.getNumberOfNames(); ++i) {
            XSSFName nm = this.workbook.getNameAt(i);
            if (nm == this || !name.equalsIgnoreCase(nm.getNameName()) || sheetIndex != nm.getSheetIndex()) continue;
            String msg = "The " + (sheetIndex == -1 ? "workbook" : "sheet") + " already contains this name: " + name;
            throw new IllegalArgumentException(msg);
        }
        this.ctName.setName(name);
    }

    public String getRefersToFormula() {
        String result = this.ctName.getStringValue();
        if (result == null || result.length() < 1) {
            return null;
        }
        return result;
    }

    public void setRefersToFormula(String formulaText) {
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(this.workbook);
        FormulaParser.parse((String)formulaText, (FormulaParsingWorkbook)fpb, (int)4, (int)this.getSheetIndex());
        this.ctName.setStringValue(formulaText);
    }

    public boolean isDeleted() {
        String formulaText = this.getRefersToFormula();
        if (formulaText == null) {
            return false;
        }
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(this.workbook);
        Ptg[] ptgs = FormulaParser.parse((String)formulaText, (FormulaParsingWorkbook)fpb, (int)4, (int)this.getSheetIndex());
        return Ptg.doesFormulaReferToDeletedCell((Ptg[])ptgs);
    }

    public void setSheetIndex(int index) {
        int lastSheetIx = this.workbook.getNumberOfSheets() - 1;
        if (index < -1 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range" + (lastSheetIx == -1 ? "" : " (0.." + lastSheetIx + ")"));
        }
        if (index == -1) {
            if (this.ctName.isSetLocalSheetId()) {
                this.ctName.unsetLocalSheetId();
            }
        } else {
            this.ctName.setLocalSheetId((long)index);
        }
    }

    public int getSheetIndex() {
        return this.ctName.isSetLocalSheetId() ? (int)this.ctName.getLocalSheetId() : -1;
    }

    public void setFunction(boolean value) {
        this.ctName.setFunction(value);
    }

    public boolean getFunction() {
        return this.ctName.getFunction();
    }

    public void setFunctionGroupId(int functionGroupId) {
        this.ctName.setFunctionGroupId((long)functionGroupId);
    }

    public int getFunctionGroupId() {
        return (int)this.ctName.getFunctionGroupId();
    }

    public String getSheetName() {
        if (this.ctName.isSetLocalSheetId()) {
            int sheetId = (int)this.ctName.getLocalSheetId();
            return this.workbook.getSheetName(sheetId);
        }
        String ref = this.getRefersToFormula();
        AreaReference areaRef = new AreaReference(ref);
        return areaRef.getFirstCell().getSheetName();
    }

    public boolean isFunctionName() {
        return this.getFunction();
    }

    public String getComment() {
        return this.ctName.getComment();
    }

    public void setComment(String comment) {
        this.ctName.setComment(comment);
    }

    public int hashCode() {
        return this.ctName.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSSFName)) {
            return false;
        }
        XSSFName cf = (XSSFName)o;
        return this.ctName.toString().equals(cf.getCTName().toString());
    }

    private static void validateName(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        char c = name.charAt(0);
        if (c != '_' && !Character.isLetter(c) || name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'; Names must begin with a letter or underscore and not contain spaces");
        }
    }
}

