/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.processor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.core.exporter.sheet.SheetExporter;
import org.bbreak.excella.core.handler.ParseErrorHandler;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.trans.listener.TransProcessListener;
import org.bbreak.excella.trans.processor.TransCreateHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransProcessor {
    public static final String COMMENT_PREFIX = "-";
    private BookController controller = null;
    private Workbook workbook = null;
    private List<TransProcessListener> processListeners = new ArrayList<TransProcessListener>();

    public TransProcessor(String filePath) throws IOException {
        this.init(filePath);
    }

    private void init(String filePath) throws IOException {
        this.workbook = this.getWorkbook(filePath);
        this.controller = new BookController(this.workbook);
        for (TagParser<?> tagParser : TransCreateHelper.getDefaultTagParsers()) {
            this.addTagParser(tagParser);
        }
        for (SheetParseListener listener : TransCreateHelper.getDefaultSheetParseListeners()) {
            this.addSheetParseListener(listener);
        }
    }

    private Workbook getWorkbook(String filePath) throws IOException {
        XSSFWorkbook workbook = null;
        if (filePath.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(filePath);
        } else {
            FileInputStream stream = new FileInputStream(filePath);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)stream);
            workbook = new HSSFWorkbook(fs);
            stream.close();
        }
        return workbook;
    }

    public BookData processBook() throws ParseException, ExportException {
        return this.processBook(null);
    }

    public BookData processBook(Object data) throws ParseException, ExportException {
        for (TransProcessListener listener : this.processListeners) {
            listener.preBookParse(this.workbook);
        }
        this.controller.parseBook(data);
        for (TransProcessListener listener : this.processListeners) {
            listener.postBookParse(this.workbook, this.controller.getBookData());
        }
        return this.controller.getBookData();
    }

    public SheetData processSheet(String sheetName) throws ParseException, ExportException {
        return this.processSheet(sheetName, null);
    }

    public SheetData processSheet(String sheetName, Object data) throws ParseException, ExportException {
        SheetData sheetData = null;
        sheetData = this.controller.parseSheet(sheetName, data);
        return sheetData;
    }

    public Boolean isDefaultSqlTag(String tag) {
        boolean result = false;
        List<String> defaultSqlTags = TransCreateHelper.getDefaultSqlTags();
        if (defaultSqlTags.contains(tag)) {
            result = true;
        }
        return result;
    }

    public List<String> getSheetNames() {
        return this.controller.getSheetNames();
    }

    public void addTagParser(TagParser<?> tagParser) {
        this.controller.addTagParser(tagParser);
    }

    public void addTagParser(String sheetName, TagParser<?> tagParser) {
        this.controller.addTagParser(sheetName, tagParser);
    }

    public void removeTagParser(String tag) {
        this.controller.removeTagParser(tag);
    }

    public void clearTagParsers() {
        this.controller.clearTagParsers();
    }

    public void addBookExporter(BookExporter bookExporter) {
        this.controller.addBookExporter(bookExporter);
    }

    public void clearBookExporters() {
        this.controller.clearBookExporters();
    }

    public void addSheetExporter(SheetExporter sheetExporter) {
        this.controller.addSheetExporter(sheetExporter);
    }

    public void addSheetExporter(String sheetName, SheetExporter sheetExporter) {
        this.controller.addSheetExporter(sheetName, sheetExporter);
    }

    public void clearSheetExporters() {
        this.controller.clearSheetExporters();
    }

    public ParseErrorHandler getErrorHandler() {
        return this.controller.getErrorHandler();
    }

    public void setErrorHandler(ParseErrorHandler errorHandler) {
        this.controller.setErrorHandler(errorHandler);
    }

    public void addSheetParseListener(SheetParseListener sheetParseListener) {
        this.controller.addSheetParseListener(sheetParseListener);
    }

    public void addSheetParseListener(String sheetName, SheetParseListener sheetParseListener) {
        this.controller.addSheetParseListener(sheetName, sheetParseListener);
    }

    public void clearSheetParseListeners() {
        this.controller.clearSheetParseListeners();
    }

    public void addTransProcessListener(TransProcessListener processListener) {
        this.processListeners.add(processListener);
    }

    public void clearTransProcessListeners() {
        this.processListeners.clear();
    }
}

