/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaParser;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaPropertyParser;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaSettingParser;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToJavaExecuter
implements SheetParseListener {
    protected static final String LNAME_TAG_PARAM_PREFIX = "(";
    protected static final String LNAME_TAG_PARAM_SUFFIX = ")";
    protected static final String TAG_PREFIX = "@";
    protected static final String TAG_LOGICAL_NAME_PREFIX = "@LNAME(";
    private List<SheetToJavaPropertyParser> customPropertyParsers = new ArrayList<SheetToJavaPropertyParser>();

    public void preParse(Sheet sheet, SheetParser sheetParser) {
    }

    public void postParse(Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        List tagParsers = sheetParser.getTagParsers();
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> targetTags = new ArrayList<String>();
        for (TagParser tagParser : tagParsers) {
            if (tagParser instanceof SheetToJavaParser) {
                targetTags.add(tagParser.getTag());
            }
            if (!(tagParser instanceof SheetToJavaSettingParser)) continue;
            removeTags.add(tagParser.getTag());
        }
        Workbook workbook = sheet.getWorkbook();
        for (String tag : targetTags) {
            List sheetInfoList = (List)sheetData.get(tag);
            if (sheetInfoList == null) continue;
            for (SheetToJavaParseInfo sheetInfo : sheetInfoList) {
                List allColumnInfoList = (List)sheetData.get(sheetInfo.getSettingTagName());
                ArrayList<SheetToJavaSettingInfo> targetColumnInfoList = new ArrayList<SheetToJavaSettingInfo>();
                for (SheetToJavaSettingInfo columnInfo : allColumnInfoList) {
                    if (!columnInfo.getSheetName().equals(sheetInfo.getSheetName())) continue;
                    targetColumnInfoList.add(columnInfo);
                }
                Sheet targetSheet = workbook.getSheet(sheetInfo.getSheetName());
                if (targetSheet == null) {
                    throw new ParseException("Sheet[" + sheetInfo.getSheetName() + "] is not exist.");
                }
                results.addAll(this.parseTargetSheet(targetSheet, sheetInfo, targetColumnInfoList));
            }
            sheetData.put(tag, results);
        }
        for (String removeTag : removeTags) {
            sheetData.remove((Object)removeTag);
        }
    }

    protected List<Object> parseTargetSheet(Sheet targetSheet, SheetToJavaParseInfo sheetInfo, List<SheetToJavaSettingInfo> targetColumnInfoList) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        int logicalRowNum = sheetInfo.getLogicalNameRowNum() - 1;
        int valueStartRowNum = sheetInfo.getValueRowNum() - 1;
        int valueEndRowNum = targetSheet.getLastRowNum();
        HashMap<String, Integer> colLogicalNameMap = new HashMap<String, Integer>();
        Row row = targetSheet.getRow(logicalRowNum);
        if (row != null) {
            int firstColIdx = row.getFirstCellNum();
            short lastColIdx = row.getLastCellNum();
            for (int colIdx = firstColIdx; colIdx <= lastColIdx; ++colIdx) {
                Cell cell = row.getCell(colIdx);
                if (cell == null) continue;
                try {
                    String string = cell.getStringCellValue();
                    if (string.startsWith("-")) continue;
                    colLogicalNameMap.put(string, colIdx);
                    continue;
                }
                catch (Exception exception) {
                    throw new ParseException(cell);
                }
            }
        }
        ArrayList classList = new ArrayList();
        HashMap settingInfoListMap = new HashMap();
        HashMap uniquePropertyListMap = new HashMap();
        for (SheetToJavaSettingInfo sheetToJavaSettingInfo : targetColumnInfoList) {
            ArrayList<String> uniquePropertyList;
            Class<?> clazz = sheetToJavaSettingInfo.getClazz();
            ArrayList<SheetToJavaSettingInfo> settingInfoList = (ArrayList<SheetToJavaSettingInfo>)settingInfoListMap.get(clazz);
            if (settingInfoList == null) {
                settingInfoList = new ArrayList<SheetToJavaSettingInfo>();
            }
            if ((uniquePropertyList = (ArrayList<String>)uniquePropertyListMap.get(clazz)) == null) {
                uniquePropertyList = new ArrayList<String>();
            }
            settingInfoList.add(sheetToJavaSettingInfo);
            if (sheetToJavaSettingInfo.isUnique()) {
                uniquePropertyList.add(sheetToJavaSettingInfo.getPropertyName());
            }
            if (!classList.contains(clazz)) {
                classList.add(clazz);
            }
            settingInfoListMap.put(clazz, settingInfoList);
            uniquePropertyListMap.put(clazz, uniquePropertyList);
        }
        for (Class clazz : classList) {
            ArrayList<Object> objList = new ArrayList<Object>();
            Object obj = null;
            try {
                for (int valueRowIdx = valueStartRowNum; valueRowIdx <= valueEndRowNum; ++valueRowIdx) {
                    obj = Class.forName(clazz.getName()).newInstance();
                    Row valueRow = targetSheet.getRow(valueRowIdx);
                    if (valueRow == null) continue;
                    List settingInfoList = (List)settingInfoListMap.get(clazz);
                    for (SheetToJavaSettingInfo settingInfo : settingInfoList) {
                        String settingValueStr;
                        Object value;
                        String propertyName = settingInfo.getPropertyName();
                        Object settingValue = value = settingInfo.getValue();
                        if (value instanceof String && (settingValueStr = (String)value).startsWith(TAG_PREFIX)) {
                            if (settingValueStr.startsWith(TAG_LOGICAL_NAME_PREFIX)) {
                                String logicalKey = TagUtil.getParam((String)settingValueStr, (String)LNAME_TAG_PARAM_PREFIX, (String)LNAME_TAG_PARAM_SUFFIX);
                                Integer logicalKeyCol = (Integer)colLogicalNameMap.get(logicalKey);
                                if (logicalKeyCol == null) {
                                    throw new ParseException("\u8ad6\u7406\u540d\u30bf\u30b0\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63");
                                }
                                Cell cell = valueRow.getCell(logicalKeyCol.intValue());
                                if (cell != null) {
                                    Class propertyClass = PropertyUtils.getPropertyType(obj, (String)settingInfo.getPropertyName());
                                    settingValue = PoiUtil.getCellValue((Cell)cell, (Class)propertyClass);
                                } else {
                                    settingValue = null;
                                }
                            } else {
                                this.parseCustomProperty(colLogicalNameMap, obj, valueRow, settingValueStr);
                                continue;
                            }
                        }
                        PropertyUtils.setProperty(obj, (String)propertyName, (Object)settingValue);
                    }
                    List uniquePropertyList = (List)uniquePropertyListMap.get(clazz);
                    if (this.isDuplicateObj(obj, objList, uniquePropertyList)) continue;
                    objList.add(obj);
                }
                results.addAll(objList);
            }
            catch (Exception e) {
                throw new ParseException(e.toString());
            }
        }
        return results;
    }

    private void parseCustomProperty(Map<String, Integer> colLogicalNameMap, Object obj, Row valueRow, String tag) throws ParseException {
        for (SheetToJavaPropertyParser propertyParser : this.customPropertyParsers) {
            if (!propertyParser.isParse(tag)) continue;
            Map paramMap = TagUtil.getParams((String)tag);
            Set paramKeys = paramMap.keySet();
            HashMap<String, Object> paramValueMap = new HashMap<String, Object>();
            for (String paramKey : paramKeys) {
                String paramValue = (String)paramMap.get(paramKey);
                if (paramValue.startsWith(TAG_LOGICAL_NAME_PREFIX)) {
                    String logicalMapKey = TagUtil.getParam((String)paramValue, (String)LNAME_TAG_PARAM_PREFIX, (String)LNAME_TAG_PARAM_SUFFIX);
                    Integer logicalKeyCol = colLogicalNameMap.get(logicalMapKey);
                    Cell cell = valueRow.getCell(logicalKeyCol.intValue());
                    Object cellValue = PoiUtil.getCellValue((Cell)cell);
                    paramValueMap.put(paramKey, cellValue);
                    continue;
                }
                paramValueMap.put(paramKey, paramValue);
            }
            propertyParser.parse(obj, paramValueMap);
        }
    }

    private boolean isDuplicateObj(Object targetObj, List<Object> objList, List<String> uniquePropertyList) throws Exception {
        boolean result = false;
        if (objList.size() == 0) {
            return false;
        }
        if (uniquePropertyList.size() == 0) {
            return false;
        }
        for (Object obj : objList) {
            boolean isDuplicate = true;
            for (String propertyName : uniquePropertyList) {
                Object checkProperty = PropertyUtils.getProperty((Object)targetObj, (String)propertyName);
                Object property = PropertyUtils.getProperty((Object)obj, (String)propertyName);
                if (property == null) {
                    if (checkProperty == null) continue;
                    isDuplicate = false;
                    continue;
                }
                if (property.equals(checkProperty)) continue;
                isDuplicate = false;
            }
            if (!isDuplicate) continue;
            result = true;
            break;
        }
        return result;
    }

    public void addPropertyParser(SheetToJavaPropertyParser parser) {
        this.customPropertyParsers.add(parser);
    }

    public void clearPropertyParsers() {
        this.customPropertyParsers.clear();
    }
}

