/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.excel2java.ArraysParser;
import org.bbreak.excella.trans.tag.sheet2sql.SqlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecreateSequenceParser
extends SqlParser {
    public static final String DEFAULT_TAG = "@RecreateSequence";
    protected static final String SQL_DROP_PREFIX = "drop sequence ";
    protected static final String SQL_CREATE_PREFIX = "create sequence ";
    protected static final String SQL_START = " start ";
    protected static final String SQL_SUFFIX = ";";

    public RecreateSequenceParser() {
        super(DEFAULT_TAG);
    }

    public RecreateSequenceParser(String tag) {
        super(tag);
    }

    @Override
    public List<String> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        ArrayList<String> resultList = new ArrayList<String>();
        ArraysParser arraysParser = new ArraysParser(super.getTag());
        List objList = arraysParser.parse(sheet, tagCell, data);
        for (Object[] obj : objList) {
            try {
                Object nameObj = obj[0];
                Object valueObj = obj[1];
                if (nameObj == null || valueObj == null) {
                    throw new ParseException(tagCell);
                }
                String name = nameObj.toString();
                Double valueDouble = Double.parseDouble(valueObj.toString());
                Integer value = valueDouble.intValue();
                resultList.add(this.createSql(name, value));
            }
            catch (Exception e) {
                throw new ParseException(tagCell, (Throwable)e);
            }
        }
        return resultList;
    }

    private String createSql(String name, Integer value) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(SQL_DROP_PREFIX);
        strBuild.append(name);
        strBuild.append(SQL_SUFFIX);
        strBuild.append("\n");
        strBuild.append(SQL_CREATE_PREFIX);
        strBuild.append(name);
        strBuild.append(SQL_START);
        strBuild.append(value);
        strBuild.append(SQL_SUFFIX);
        return strBuild.toString();
    }
}

