/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2sql.SheetToSqlParser;
import org.bbreak.excella.trans.tag.sheet2sql.SheetToSqlSettingParser;
import org.bbreak.excella.trans.tag.sheet2sql.converter.SheetToSqlDataConverter;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlInfo;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlParseInfo;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlSettingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToSqlExecuter
implements SheetParseListener {
    protected static final String LNAME_TAG_PARAM_PREFIX = "(";
    protected static final String LNAME_TAG_PARAM_SUFFIX = ")";
    protected static final String TAG_LOGICAL_NAME_PREFIX = "@LNAME(";
    private SheetToSqlDataConverter dataConverter = null;

    public void preParse(Sheet sheet, SheetParser sheetParser) {
    }

    public void postParse(Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        List tagParsers = sheetParser.getTagParsers();
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> targetTags = new ArrayList<String>();
        for (TagParser tagParser : tagParsers) {
            if (tagParser instanceof SheetToSqlParser) {
                targetTags.add(tagParser.getTag());
            }
            if (!(tagParser instanceof SheetToSqlSettingParser)) continue;
            removeTags.add(tagParser.getTag());
        }
        Workbook workbook = sheet.getWorkbook();
        for (String tag : targetTags) {
            List sheetInfoList = (List)sheetData.get(tag);
            if (sheetInfoList == null) continue;
            for (SheetToSqlParseInfo sheetInfo : sheetInfoList) {
                List allColumnInfoList = (List)sheetData.get(sheetInfo.getSettingTagName());
                ArrayList<SheetToSqlSettingInfo> targetColumnInfoList = new ArrayList<SheetToSqlSettingInfo>();
                for (SheetToSqlSettingInfo columnInfo : allColumnInfoList) {
                    if (!columnInfo.getSheetName().equals(sheetInfo.getSheetName())) continue;
                    targetColumnInfoList.add(columnInfo);
                }
                Sheet targetSheet = workbook.getSheet(sheetInfo.getSheetName());
                if (targetSheet == null) {
                    throw new ParseException("Sheet[" + sheetInfo.getSheetName() + "] is not exist.");
                }
                results.addAll(this.parseTargetSheet(targetSheet, sheetInfo, targetColumnInfoList));
            }
            sheetData.put(tag, results);
        }
        for (String removeTag : removeTags) {
            sheetData.remove((Object)removeTag);
        }
    }

    protected List<Object> parseTargetSheet(Sheet targetSheet, SheetToSqlParseInfo sheetInfo, List<SheetToSqlSettingInfo> targetColumnInfoList) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        int logicalRowNum = sheetInfo.getLogicalNameRowNum() - 1;
        int valueStartRowNum = sheetInfo.getValueRowNum() - 1;
        int valueEndRowNum = targetSheet.getLastRowNum();
        HashMap<String, Integer> colLogicalNameMap = new HashMap<String, Integer>();
        Row row = targetSheet.getRow(logicalRowNum);
        if (row != null) {
            int firstColIdx = row.getFirstCellNum();
            short lastColIdx = row.getLastCellNum();
            for (int colIdx = firstColIdx; colIdx <= lastColIdx; ++colIdx) {
                Cell cell = row.getCell(colIdx);
                if (cell == null) continue;
                try {
                    String logicalCellValue = cell.getStringCellValue();
                    if (logicalCellValue.startsWith("-")) continue;
                    colLogicalNameMap.put(logicalCellValue, colIdx);
                    continue;
                }
                catch (Exception e) {
                    throw new ParseException(cell);
                }
            }
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        HashMap settingInfoListMap = new HashMap();
        HashMap uniqueColumnListMap = new HashMap();
        for (SheetToSqlSettingInfo settingInfo : targetColumnInfoList) {
            ArrayList<String> uniqueColumnList;
            String tableName = settingInfo.getTableName();
            ArrayList<SheetToSqlSettingInfo> settingInfoList = (ArrayList<SheetToSqlSettingInfo>)settingInfoListMap.get(tableName);
            if (settingInfoList == null) {
                settingInfoList = new ArrayList<SheetToSqlSettingInfo>();
            }
            if ((uniqueColumnList = (ArrayList<String>)uniqueColumnListMap.get(tableName)) == null) {
                uniqueColumnList = new ArrayList<String>();
            }
            settingInfoList.add(settingInfo);
            if (settingInfo.isUnique()) {
                uniqueColumnList.add(settingInfo.getColumnName());
            }
            if (!tableNameList.contains(tableName)) {
                tableNameList.add(tableName);
            }
            settingInfoListMap.put(tableName, settingInfoList);
            uniqueColumnListMap.put(tableName, uniqueColumnList);
        }
        for (String tableName : tableNameList) {
            ArrayList<SheetToSqlInfo> infoList = new ArrayList<SheetToSqlInfo>();
            SheetToSqlInfo info = null;
            for (int valueRowIdx = valueStartRowNum; valueRowIdx <= valueEndRowNum; ++valueRowIdx) {
                HashMap<String, String> columnValueMap = new HashMap<String, String>();
                ArrayList<String> columnNameList = new ArrayList<String>();
                info = new SheetToSqlInfo();
                info.setTableName(tableName);
                info.setColumnValueMap(columnValueMap);
                info.setColumnNameList(columnNameList);
                Row valueRow = targetSheet.getRow(valueRowIdx);
                if (valueRow == null) continue;
                List settingInfoList = (List)settingInfoListMap.get(tableName);
                for (SheetToSqlSettingInfo settingInfo : settingInfoList) {
                    String settingValueStr;
                    String columnName = settingInfo.getColumnName();
                    Object value = settingInfo.getValue();
                    String dataType = settingInfo.getDataType();
                    Object target = value;
                    if (value instanceof String && (settingValueStr = (String)value).startsWith(TAG_LOGICAL_NAME_PREFIX)) {
                        String logicalKey = TagUtil.getParam((String)settingValueStr, (String)LNAME_TAG_PARAM_PREFIX, (String)LNAME_TAG_PARAM_SUFFIX);
                        Integer logicalKeyCol = (Integer)colLogicalNameMap.get(logicalKey);
                        if (logicalKeyCol == null) {
                            throw new ParseException("\u8ad6\u7406\u540d\u30bf\u30b0\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63");
                        }
                        Cell cell = valueRow.getCell(logicalKeyCol.intValue());
                        target = PoiUtil.getCellValue((Cell)cell);
                    }
                    String valueStr = this.dataConverter.convert(target, dataType);
                    columnValueMap.put(columnName, valueStr);
                    columnNameList.add(columnName);
                }
                List uniqueColumnList = (List)uniqueColumnListMap.get(tableName);
                if (this.isDuplicateObj(info, infoList, uniqueColumnList)) continue;
                infoList.add(info);
            }
            List<String> sqlList = this.createInsertSqlList(infoList);
            results.addAll(sqlList);
        }
        return results;
    }

    private List<String> createInsertSqlList(List<SheetToSqlInfo> infoList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (SheetToSqlInfo info : infoList) {
            String columnName;
            int index;
            StringBuilder strBuild = new StringBuilder();
            strBuild.append("insert into ");
            strBuild.append(info.getTableName());
            strBuild.append(" (");
            Map<String, String> columnValueMap = info.getColumnValueMap();
            List<String> columnNameList = info.getColumnNameList();
            for (index = 0; index < columnNameList.size(); ++index) {
                columnName = columnNameList.get(index);
                strBuild.append(columnName);
                if (index >= columnNameList.size() - 1) continue;
                strBuild.append(",");
            }
            strBuild.append(") ");
            strBuild.append("values");
            strBuild.append(" (");
            for (index = 0; index < columnNameList.size(); ++index) {
                columnName = columnNameList.get(index);
                String value = columnValueMap.get(columnName);
                if (value == null) {
                    strBuild.append("null");
                } else {
                    strBuild.append(value);
                }
                if (index >= columnNameList.size() - 1) continue;
                strBuild.append(",");
            }
            strBuild.append(");");
            sqlList.add(strBuild.toString());
        }
        return sqlList;
    }

    private boolean isDuplicateObj(SheetToSqlInfo targetInfo, List<SheetToSqlInfo> infoList, List<String> uniqueColumnList) {
        boolean result = false;
        if (infoList.size() == 0) {
            return false;
        }
        if (uniqueColumnList.size() == 0) {
            return false;
        }
        for (SheetToSqlInfo info : infoList) {
            boolean isDuplicate = true;
            Map<String, String> targetValueMap = targetInfo.getColumnValueMap();
            Map<String, String> columnValueMap = info.getColumnValueMap();
            for (String columnName : uniqueColumnList) {
                String targetValue = targetValueMap.get(columnName);
                String infoValue = columnValueMap.get(columnName);
                if (targetValue == null) {
                    if (infoValue == null) continue;
                    isDuplicate = false;
                    continue;
                }
                if (targetValue.equals(infoValue)) continue;
                isDuplicate = false;
            }
            if (!isDuplicate) continue;
            result = true;
            break;
        }
        return result;
    }

    public SheetToSqlDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(SheetToSqlDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }
}

