/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlSettingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToSqlSettingParser
extends TagParser<List<SheetToSqlSettingInfo>> {
    public static final String DEFAULT_TAG = "@SheetToSqlSetting";
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;
    protected static final String UNIQUE_PROPERTY_MARK = "\u25cb";

    public SheetToSqlSettingParser() {
        super(DEFAULT_TAG);
    }

    public SheetToSqlSettingParser(String tag) {
        super(tag);
    }

    public List<SheetToSqlSettingInfo> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        try {
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_FROM, (int)2);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            if ((valueRowToIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_TO, (int)(valueRowToIdx - tagRowIdx))) < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell);
            }
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
        ArrayList<SheetToSqlSettingInfo> sheetSettingInfoList = new ArrayList<SheetToSqlSettingInfo>();
        int sheetNameColIdx = tagColIdx++;
        int valueColIdx = tagColIdx++;
        int tableColIdx = tagColIdx++;
        int columnNameColIdx = tagColIdx++;
        int uniqueColIdx = tagColIdx++;
        int dataTypeColIdx = tagColIdx++;
        for (int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            Cell sheetNameCell = row.getCell(sheetNameColIdx);
            Cell valueCell = row.getCell(valueColIdx);
            Cell tableNameCell = row.getCell(tableColIdx);
            Cell columnNameCell = row.getCell(columnNameColIdx);
            Cell uniqueCell = row.getCell(uniqueColIdx);
            Cell dataTypeCell = row.getCell(dataTypeColIdx);
            if (sheetNameCell == null && valueCell == null && tableNameCell == null && columnNameCell == null && uniqueCell == null && dataTypeCell == null) continue;
            Cell requiredErrorCell = null;
            if (sheetNameCell == null) {
                requiredErrorCell = row.createCell(sheetNameColIdx);
            } else if (tableNameCell == null) {
                requiredErrorCell = row.createCell(tableColIdx);
            } else if (columnNameCell == null) {
                requiredErrorCell = row.createCell(columnNameColIdx);
            }
            if (requiredErrorCell != null) {
                throw new ParseException(requiredErrorCell);
            }
            SheetToSqlSettingInfo settingInfo = new SheetToSqlSettingInfo();
            settingInfo.setSheetName(sheetNameCell.getStringCellValue());
            settingInfo.setTableName(tableNameCell.getStringCellValue());
            settingInfo.setColumnName(columnNameCell.getStringCellValue());
            if (valueCell != null) {
                Object value = PoiUtil.getCellValue((Cell)valueCell);
                settingInfo.setValue(value);
            }
            if (uniqueCell != null && uniqueCell.getStringCellValue() != null && uniqueCell.getStringCellValue().equals(UNIQUE_PROPERTY_MARK)) {
                settingInfo.setUnique(true);
            }
            if (dataTypeCell != null) {
                settingInfo.setDataType(dataTypeCell.getStringCellValue());
            }
            sheetSettingInfoList.add(settingInfo);
        }
        return sheetSettingInfoList;
    }
}

