/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.CountUtils;
import org.apache.poi.hssf.record.formula.functions.Countif;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Sumif
implements Function {
    public Eval evaluate(Eval[] args, int srcRowIndex, short srcColumnIndex) {
        AreaEval aeSum;
        AreaEval aeRange;
        if (args.length < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            aeRange = Sumif.convertRangeArg(args[0]);
            switch (args.length) {
                case 2: {
                    aeSum = aeRange;
                    break;
                }
                case 3: {
                    aeSum = Sumif.createSumRange(args[2], aeRange);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        CountUtils.I_MatchPredicate mp = Countif.createCriteriaPredicate(args[1], srcRowIndex, srcRowIndex);
        double result = Sumif.sumMatchingCells(aeRange, mp, aeSum);
        return new NumberEval(result);
    }

    private static double sumMatchingCells(AreaEval aeRange, CountUtils.I_MatchPredicate mp, AreaEval aeSum) {
        int height = aeRange.getHeight();
        int width = aeRange.getWidth();
        double result = 0.0;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                result += Sumif.accumulate(aeRange, mp, aeSum, r, c);
            }
        }
        return result;
    }

    private static double accumulate(AreaEval aeRange, CountUtils.I_MatchPredicate mp, AreaEval aeSum, int relRowIndex, int relColIndex) {
        if (!mp.matches(aeRange.getRelativeValue(relRowIndex, relColIndex))) {
            return 0.0;
        }
        ValueEval addend = aeSum.getRelativeValue(relRowIndex, relColIndex);
        if (addend instanceof NumberEval) {
            return ((NumberEval)addend).getNumberValue();
        }
        return 0.0;
    }

    private static AreaEval createSumRange(Eval eval, AreaEval aeRange) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return ((AreaEval)eval).offset(0, aeRange.getHeight() - 1, 0, aeRange.getWidth() - 1);
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, aeRange.getHeight() - 1, 0, aeRange.getWidth() - 1);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    private static AreaEval convertRangeArg(Eval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

