/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListParser
extends TagParser<List<?>> {
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final String PARAM_VALUE_COLUMN = "ValueColumn";
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;
    protected static final int DEFAULT_VALUE_COLUMN_ADJUST = 0;

    public ListParser(String tag) {
        super(tag);
    }

    @Override
    public List<?> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            int tagRowIdx = tagCell.getRowIndex();
            int valueRowToIdx = sheet.getLastRowNum();
            int valueColIdx = tagCell.getColumnIndex();
            Map<String, String> paramDef = TagUtil.getParams(tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, 1);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            if ((valueRowToIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx)) < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell);
            }
            if ((valueColIdx = TagUtil.adjustValue(valueColIdx, paramDef, PARAM_VALUE_COLUMN, 0)) > PoiUtil.getLastColNum(sheet) || valueColIdx < 0) {
                throw new ParseException(tagCell);
            }
            for (int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; ++rowCnt) {
                Row row = sheet.getRow(rowCnt);
                if (row == null) continue;
                Object value = PoiUtil.getCellValue(row.getCell(valueColIdx));
                results.add(value);
            }
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
        return results;
    }
}

