/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaExecuter.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;

/**
 * V[g͂AJavaIuWFNg<BR>
 * List&lt;Object&gt;Ŏ擾<BR>
 * 
 * @since 1.0
 */
public class SheetToJavaExecuter implements SheetParseListener {

    /**
     * _p[^`̊Jn
     */
    protected static final String LNAME_TAG_PARAM_PREFIX = "(";

    /**
     * _p[^`̏I
     */
    protected static final String LNAME_TAG_PARAM_SUFFIX = ")";

    /**
     * ^O`̊Jn
     */
    protected static final String TAG_PREFIX = "@";

    /**
     * _^O
     */
    protected static final String TAG_LOGICAL_NAME_PREFIX = "@LNAME(";

    /**
     * JX^vpeB̃Xg
     */
    private List<SheetToJavaPropertyParser> customPropertyParsers = new ArrayList<SheetToJavaPropertyParser>();

    /**
     * ͑O
     * 
     * @param sheet ΏۃV[g
     * @param sheetParser ΏۃV[gp[T
     */
    public void preParse( Sheet sheet, SheetParser sheetParser) {
        // do nothing
    }

    /**
     * ͌㏈<BR>
     * ݒɊÂAf[^IuWFNgɕϊA<BR>
     * ʂXgɓāASheetDataɃZbg<BR>
     * 
     * @param sheet ΏۃV[g
     * @param sheetParser ΏۃV[gp[T
     * @param sheetData ͌ʃV[gf[^
     */
    @SuppressWarnings( "unchecked")
    public void postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {

        // ʃIuWFNg̃Xg
        List<Object> results = new ArrayList<Object>();

        // ΏۃV[gSheetToJavaParser݂邩
        List<TagParser<?>> tagParsers = sheetParser.getTagParsers();

        // svɂȂSheetToJavaSettingParser
        // f[^𔻕ʂ^ÕXg
        List<String> removeTags = new ArrayList<String>();

        // ^Öꗗ𐶐
        List<String> targetTags = new ArrayList<String>();
        for ( TagParser<?> tagParser : tagParsers) {
            // SheetToJavaParser̃^O
            if ( tagParser instanceof SheetToJavaParser) {
                targetTags.add( tagParser.getTag());
            }
            // SheetToJavaSettingParser̃^O
            if ( tagParser instanceof SheetToJavaSettingParser) {
                removeTags.add( tagParser.getTag());
            }
        }

        // [NubN擾
        Workbook workbook = sheet.getWorkbook();

        // Ώۂ̃^OŃ[v
        for ( String tag : targetTags) {

            List<SheetToJavaParseInfo> sheetInfoList = ( List<SheetToJavaParseInfo>) sheetData.get( tag);

            if ( sheetInfoList == null) {
                continue;
            }

            // ݒ(V[g)PʂŃ[v
            for ( SheetToJavaParseInfo sheetInfo : sheetInfoList) {

                List<SheetToJavaSettingInfo> allColumnInfoList = ( List<SheetToJavaSettingInfo>) sheetData.get( sheetInfo.getSettingTagName());

                // 񏈗ΏۃV[g̐ݒ擾
                List<SheetToJavaSettingInfo> targetColumnInfoList = new ArrayList<SheetToJavaSettingInfo>();
                for ( SheetToJavaSettingInfo columnInfo : allColumnInfoList) {
                    if ( columnInfo.getSheetName().equals( sheetInfo.getSheetName())) {
                        targetColumnInfoList.add( columnInfo);
                    }
                }

                // ΏۃV[gf[^̓ǂݍ
                Sheet targetSheet = workbook.getSheet( sheetInfo.getSheetName());
                if ( targetSheet == null) {
                    throw new ParseException( "Sheet[" + sheetInfo.getSheetName() + "] is not exist.");
                }
                results.addAll( parseTargetSheet( targetSheet, sheetInfo, targetColumnInfoList));
            }

            // sheetDataɌʂi[
            sheetData.put( tag, results);
        }

        // ɕsvɂȂf[^̍폜
        for ( String removeTag : removeTags) {
            sheetData.remove( removeTag);
        }
    }

    /**
     * ݒɊÂAΏۃV[gIuWFNg<BR>
     * ϊAXgɓĕԋp<BR>
     * 
     * @param targetSheet ͑ΏۃV[g
     * @param targetColumnInfoList ݒ
     * @return IuWFNgXg
     * @throws ParseException p[XO
     */
    protected List<Object> parseTargetSheet( Sheet targetSheet, SheetToJavaParseInfo sheetInfo, List<SheetToJavaSettingInfo> targetColumnInfoList) throws ParseException {

        // ʃIuWFNg̃Xg
        List<Object> results = new ArrayList<Object>();

        int logicalRowNum = sheetInfo.getLogicalNameRowNum() - 1;
        int valueStartRowNum = sheetInfo.getValueRowNum() - 1;
        int valueEndRowNum = targetSheet.getLastRowNum();

        // _AΉJindex̃}bv
        Map<String, Integer> colLogicalNameMap = new HashMap<String, Integer>();

        // colLogicalNameMap쐬
        Row row = targetSheet.getRow( logicalRowNum);
        if ( row != null) {

            // _s̊JnƏI
            int firstColIdx = row.getFirstCellNum();
            int lastColIdx = row.getLastCellNum();

            for ( int colIdx = firstColIdx; colIdx <= lastColIdx; colIdx++) {
                Cell cell = row.getCell( colIdx);
                if ( cell != null) {
                    try {
                        // _
                        String logicalCellValue = cell.getStringCellValue();
                        if ( !logicalCellValue.startsWith( BookController.COMMENT_PREFIX)) {
                            colLogicalNameMap.put( logicalCellValue, colIdx);
                        }
                    } catch ( Exception e) {
                        throw new ParseException( cell);
                    }
                }
            }
        }

        // `ɏKv邽߁Af[^̏Ԃێ郊Xg
        List<Class<?>> classList = new ArrayList<Class<?>>();

        // NXASettingInfoXg̃}bv
        Map<Class<?>, List<SheetToJavaSettingInfo>> settingInfoListMap = new HashMap<Class<?>, List<SheetToJavaSettingInfo>>();
        // NXAdsvpeBXg̃}bv
        Map<Class<?>, List<String>> uniquePropertyListMap = new HashMap<Class<?>, List<String>>();
        for ( SheetToJavaSettingInfo settingInfo : targetColumnInfoList) {

            // }bv烊Xg擾
            Class<?> clazz = settingInfo.getClazz();
            List<SheetToJavaSettingInfo> settingInfoList = settingInfoListMap.get( clazz);
            if ( settingInfoList == null) {
                // 擾łȂꍇ
                settingInfoList = new ArrayList<SheetToJavaSettingInfo>();
            }
            List<String> uniquePropertyList = uniquePropertyListMap.get( clazz);
            if ( uniquePropertyList == null) {
                // 擾łȂꍇ
                uniquePropertyList = new ArrayList<String>();
            }

            // Xgɒǉ
            settingInfoList.add( settingInfo);
            if ( settingInfo.isUnique()) {
                uniquePropertyList.add( settingInfo.getPropertyName());
            }

            // f[^̏Ԃێ
            if ( !classList.contains( clazz)) {
                classList.add( clazz);
            }

            // }bvɋl߂
            settingInfoListMap.put( clazz, settingInfoList);
            uniquePropertyListMap.put( clazz, uniquePropertyList);
        }

        // NXƂ̃[v
        for ( Class<?> clazz : classList) {

            // ʃIuWFNg̃Xg
            List<Object> objList = new ArrayList<Object>();

            Object obj = null;
            try {

                // f[^sƂ̃[v
                for ( int valueRowIdx = valueStartRowNum; valueRowIdx <= valueEndRowNum; valueRowIdx++) {

                    obj = Class.forName( clazz.getName()).newInstance();

                    Row valueRow = targetSheet.getRow( valueRowIdx);
                    if ( valueRow == null) {
                        continue;
                    }

                    // vpeBƂ̃[v
                    List<SheetToJavaSettingInfo> settingInfoList = settingInfoListMap.get( clazz);
                    for ( SheetToJavaSettingInfo settingInfo : settingInfoList) {

                        // vpeB
                        String propertyName = settingInfo.getPropertyName();
                        // l
                        Object value = settingInfo.getValue();
                        // Zbg
                        Object settingValue = value;

                        if ( value instanceof String) {
                            // ̏ꍇ

                            String settingValueStr = ( String) value;
                            if ( settingValueStr.startsWith( TAG_PREFIX)) {
                                // ^O`̏ꍇ

                                if ( settingValueStr.startsWith( TAG_LOGICAL_NAME_PREFIX)) {
                                    // _̏ꍇ
                                    String logicalKey = TagUtil.getParam( settingValueStr, LNAME_TAG_PARAM_PREFIX, LNAME_TAG_PARAM_SUFFIX);
                                    Integer logicalKeyCol = colLogicalNameMap.get( logicalKey);
                                    if ( logicalKeyCol == null) {
                                        throw new ParseException( "_^Op[^s");
                                    }

                                    Cell cell = valueRow.getCell( logicalKeyCol);
                                    if ( cell != null) {
                                        Class<?> propertyClass = PropertyUtils.getPropertyType( obj, settingInfo.getPropertyName());
                                        settingValue = PoiUtil.getCellValue( cell, propertyClass);
                                    } else {
                                        // Znull̏ꍇ
                                        settingValue = null;
                                    }

                                } else {
                                    // ȊÕ^Ȍꍇ
                                    // JX^p[T̏s
                                    parseCustomProperty( colLogicalNameMap, obj, valueRow, settingValueStr);
                                    // ̃[v
                                    continue;
                                }
                            }
                        }

                        // lZbg
                        PropertyUtils.setProperty( obj, propertyName, settingValue);
                    }

                    List<String> uniquePropertyList = uniquePropertyListMap.get( clazz);
                    if ( !isDuplicateObj( obj, objList, uniquePropertyList)) {
                        // dĂȂꍇ
                        objList.add( obj);
                    }
                }

                // ʃXgɊi[
                results.addAll( objList);

            } catch ( Exception e) {
                throw new ParseException( e.toString());
            }
        }

        return results;
    }

    /**
     * JX^p[T̏s
     * 
     * @param colLogicalNameMap _AJindex̃}bv
     * @param obj ΏۃIuWFNg
     * @param valueRow l
     * @param tag ^O
     * @throws ParseException p[XO
     */
    private void parseCustomProperty( Map<String, Integer> colLogicalNameMap, Object obj, Row valueRow, String tag) throws ParseException {

        for ( SheetToJavaPropertyParser propertyParser : customPropertyParsers) {

            // JX^vpeB̔
            if ( propertyParser.isParse( tag)) {

                // p[^Œ`ĂvpeBAl̃}bv
                Map<String, String> paramMap = TagUtil.getParams( tag);
                Set<String> paramKeys = paramMap.keySet();

                Map<String, Object> paramValueMap = new HashMap<String, Object>();
                for ( String paramKey : paramKeys) {

                    String paramValue = paramMap.get( paramKey);
                    if ( paramValue.startsWith( TAG_LOGICAL_NAME_PREFIX)) {
                        // _̏ꍇ
                        String logicalMapKey = TagUtil.getParam( paramValue, LNAME_TAG_PARAM_PREFIX, LNAME_TAG_PARAM_SUFFIX);
                        Integer logicalKeyCol = colLogicalNameMap.get( logicalMapKey);
                        Cell cell = valueRow.getCell( logicalKeyCol);
                        Object cellValue = PoiUtil.getCellValue( cell);
                        paramValueMap.put( paramKey, cellValue);

                    } else {
                        // Œl̏ꍇ
                        paramValueMap.put( paramKey, paramValue);
                    }
                }
                // JX^p[T̏s
                propertyParser.parse( obj, paramValueMap);
            }
        }
    }

    /**
     * dIuWFNg݂邩𔻒肷B<BR>
     * Xg̒ɑΏۃIuWFNgƃj[NvpeB̒l<BR>
     * SĈvIuWFNg݂ꍇtrueԂB<BR>
     * 
     * @param targetObj ΏۃIuWFNg
     * @param objList IuWFNg̃Xg
     * @param uniquePropertyList j[NvpeB̃Xg
     * @return result dIuWFNg݂ꍇtrueA݂Ȃꍇfalse
     * @throws Exception (NoSuchMethodException, IllegaiArgumentException, InvocationTargetException)
     */
    private boolean isDuplicateObj( Object targetObj, List<Object> objList, List<String> uniquePropertyList) throws Exception {

        boolean result = false;

        if ( objList.size() == 0) {
            // IuWFNg̃Xg̏ꍇ
            return false;
        }

        if ( uniquePropertyList.size() == 0) {
            // j[NvpeB̃Xg̏ꍇ
            return false;
        }

        for ( Object obj : objList) {
            // j[NvpeBldĂ邩ǂ
            boolean isDuplicate = true;
            for ( String propertyName : uniquePropertyList) {

                Object checkProperty = PropertyUtils.getProperty( targetObj, propertyName);
                Object property = PropertyUtils.getProperty( obj, propertyName);

                if ( property == null) {
                    if ( checkProperty != null) {
                        isDuplicate = false;
                    }
                } else if ( !property.equals( checkProperty)) {
                    isDuplicate = false;
                }
            }
            if ( isDuplicate) {
                // dĂꍇ
                result = true;
                break;
            }
        }
        return result;
    }

    /**
     * JX^vpeB̓NXǉ
     * 
     * @param parser ǉJX^vpeB̓NX
     */
    public void addPropertyParser( SheetToJavaPropertyParser parser) {
        customPropertyParsers.add( parser);
    }

    /**
     * ׂẴJX^vpeB̓NX폜
     */
    public void clearPropertyParsers() {
        customPropertyParsers.clear();
    }
}
