/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaParser.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;

/**
 * V[g͂̎s͂p[T
 * 
 * @since 1.0
 */
public class SheetToJavaParser extends TagParser<List<SheetToJavaParseInfo>> {

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "@SheetToJava";

    /**
     * Ήݒ̃^O
     */
    protected static final String PARAM_SETTING_TAG_NAME = "SettingTagName";

    /**
     * ftHg̐ݒ薼̗pڔ
     */
    protected static final String DEFAULT_SETTING_SUFFIX = "Setting";

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * ʃL[p[^
     */
    protected static final String PARAM_RESULT_KEY = "ResultKey";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;

    /**
     * RXgN^
     */
    public SheetToJavaParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SheetToJavaParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR> 
     *              nꍇTagParser.parse\bh܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<SheetToJavaParseInfo> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {
        // ^ÕCfbNX
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();

        int valueRowFromIdx;
        int valueRowToIdx = sheet.getLastRowNum();

        String settingTagName = getTag() + DEFAULT_SETTING_SUFFIX;

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_DATA_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

            // ݒ^O̎擾
            if ( paramDef.containsKey( PARAM_SETTING_TAG_NAME)) {
                settingTagName = paramDef.get( PARAM_SETTING_TAG_NAME);
            }

            // ʃL[
            if ( paramDef.containsKey( PARAM_RESULT_KEY)) {
                // ʃL[w肳Ăꍇ̓G[
                throw new ParseException( tagCell);
            }

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        List<SheetToJavaParseInfo> sheetInfoList = new ArrayList<SheetToJavaParseInfo>();

        int sheetNameColIdx = tagColIdx++;
        int logicalRowColIdx = tagColIdx++;
        int dataRowColIdx = tagColIdx;

        // V[g̓ǂݍ
        for ( int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; rowNum++) {
            Row row = sheet.getRow( rowNum);
            if ( row != null) {
                // Z̎擾
                Cell sheetNameCell = row.getCell( sheetNameColIdx);
                Cell logicalRowNumCell = row.getCell( logicalRowColIdx);
                Cell valueRowNumCell = row.getCell( dataRowColIdx);

                // K{`FbN
                if ( (sheetNameCell == null) && (logicalRowNumCell == null) && (valueRowNumCell == null)) {
                    // ΏۃZׂnull̏ꍇ
                    continue;

                } else {
                    Cell requiredErrorCell = null;
                    if ( sheetNameCell == null) {
                        requiredErrorCell = row.createCell( sheetNameColIdx);
                    } else if ( logicalRowNumCell == null) {
                        requiredErrorCell = row.createCell( logicalRowColIdx);
                    } else if ( valueRowNumCell == null) {
                        requiredErrorCell = row.createCell( dataRowColIdx);
                    }

                    // K{ZȂꍇ͗O𓊂
                    if ( requiredErrorCell != null) {
                        throw new ParseException( requiredErrorCell);
                    }
                }

                // ݒl`FbN
                int logicalRowNum;
                int valueRowNum;
                try {
                    logicalRowNum = ( Integer) PoiUtil.getCellValue( logicalRowNumCell, Integer.class);
                } catch ( Exception e) {
                    throw new ParseException( logicalRowNumCell);
                }

                try {
                    valueRowNum = ( Integer) PoiUtil.getCellValue( valueRowNumCell, Integer.class);
                } catch ( Exception e) {
                    throw new ParseException( valueRowNumCell);
                }

                SheetToJavaParseInfo sheetInfo = new SheetToJavaParseInfo();
                sheetInfo.setSettingTagName( settingTagName);
                sheetInfo.setSheetName( sheetNameCell.getStringCellValue());
                sheetInfo.setLogicalNameRowNum( logicalRowNum);
                sheetInfo.setValueRowNum( valueRowNum);

                sheetInfoList.add( sheetInfo);
            }
        }

        return sheetInfoList;
    }
}
