/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToSqlSettingParser.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlSettingInfo;

/**
 * V[g̖׏͂p[T
 * 
 * @since 1.0
 */
public class SheetToSqlSettingParser extends TagParser<List<SheetToSqlSettingInfo>> {

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "@SheetToSqlSetting";

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;

    /**
     * j[NvpeB̃}[N
     */
    protected static final String UNIQUE_PROPERTY_MARK = "";

    /**
     * RXgN^
     */
    public SheetToSqlSettingParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SheetToSqlSettingParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR>
     *              nꍇTagParser.parse\bh܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<SheetToSqlSettingInfo> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        // ^ÕCfbNX
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();

        // f[^sCfbNX
        int valueRowFromIdx;
        int valueRowToIdx = sheet.getLastRowNum();

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_DATA_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        List<SheetToSqlSettingInfo> sheetSettingInfoList = new ArrayList<SheetToSqlSettingInfo>();

        // V[gCfbNX
        int sheetNameColIdx = tagColIdx++;
        // lCfbNX
        int valueColIdx = tagColIdx++;
        // Ώۃe[uCfbNX
        int tableColIdx = tagColIdx++;
        // ΏۃJCfbNX
        int columnNameColIdx = tagColIdx++;
        // dsCfbNX
        int uniqueColIdx = tagColIdx++;
        // f[^^CfbNX
        int dataTypeColIdx = tagColIdx++;

        // V[g̓ǂݍ
        for ( int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; rowNum++) {
            Row row = sheet.getRow( rowNum);
            if ( row != null) {
                // Z̎擾
                Cell sheetNameCell = row.getCell( sheetNameColIdx);
                Cell valueCell = row.getCell( valueColIdx);
                Cell tableNameCell = row.getCell( tableColIdx);
                Cell columnNameCell = row.getCell( columnNameColIdx);
                Cell uniqueCell = row.getCell( uniqueColIdx);
                Cell dataTypeCell = row.getCell( dataTypeColIdx);

                // K{`FbN
                if ( (sheetNameCell == null) && (valueCell == null) && (tableNameCell == null) 
                        && (columnNameCell == null) && (uniqueCell == null) && (dataTypeCell == null)) {
                    // ΏۃZׂnull̏ꍇ
                    continue;

                } else {
                    Cell requiredErrorCell = null;
                    if ( sheetNameCell == null) {
                        // V[gZnull̏ꍇ
                        requiredErrorCell = row.createCell( sheetNameColIdx);
                    } else if ( tableNameCell == null) {
                        // Ώۃe[uZnull̏ꍇ
                        requiredErrorCell = row.createCell( tableColIdx);
                    } else if ( columnNameCell == null) {
                        // ΏۃJZnull̏ꍇ
                        requiredErrorCell = row.createCell( columnNameColIdx);
                    }

                    if ( requiredErrorCell != null) {
                        // K{G[͗O𓊂
                        throw new ParseException( requiredErrorCell);
                    }
                }

                // l̐ݒ
                SheetToSqlSettingInfo settingInfo = new SheetToSqlSettingInfo();

                // V[g
                settingInfo.setSheetName( sheetNameCell.getStringCellValue());

                // e[u
                settingInfo.setTableName( tableNameCell.getStringCellValue());

                // J
                settingInfo.setColumnName( columnNameCell.getStringCellValue());

                // l
                if ( valueCell != null) {
                    Object value = PoiUtil.getCellValue( valueCell);
                    settingInfo.setValue( value);
                }

                // ds
                if ( uniqueCell != null) {
                    if ( uniqueCell.getStringCellValue() != null && uniqueCell.getStringCellValue().equals( UNIQUE_PROPERTY_MARK)) {
                        settingInfo.setUnique( true);
                    }
                }
                
                // f[^^
                if (dataTypeCell != null) {
                    settingInfo.setDataType( dataTypeCell.getStringCellValue());
                }
                
                // ʃXgɊi[
                sheetSettingInfoList.add( settingInfo);
            }
        }
        return sheetSettingInfoList;
    }
}
