/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaParserTest.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.trans.WorkbookTest;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;
import org.junit.Test;

/**
 * SheetToJavaParsereXgNX
 * 
 * @since 1.0
 */
public class SheetToJavaParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public SheetToJavaParserTest( String version) {
        super( version);
    }

    @Test
    public final void testSheetToJavaParser() throws ParseException {
        Workbook workbook = getWorkbook();
        Sheet sheet1 = workbook.getSheetAt( 0);
        Sheet sheet2 = workbook.getSheetAt( 1);
        Sheet sheet3 = workbook.getSheetAt( 2);
        Sheet sheet4 = workbook.getSheetAt( 3);
        String tag = "@SheetToJava";
        SheetToJavaParser parser = new SheetToJavaParser( tag);
        Cell tagCell = null;
        Object data = null;
        List<SheetToJavaParseInfo> list = null;

        // ===============================================
        // parse( Sheet sheet, Cell tagCell, Object data)
        // ===============================================
        // No.1 p[^
        tagCell = sheet1.getRow( 0).getCell( 0);
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( tag + "Setting", list.get( 0).getSettingTagName());
        assertEquals( tag + "Setting", list.get( 1).getSettingTagName());
        assertEquals( "sheetName2", list.get( 0).getSheetName());
        assertEquals( "sheetName3", list.get( 1).getSheetName());
        assertEquals( new Integer( 2), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 3), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 5), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 6), list.get( 1).getValueRowNum());

        // No.2 p[^L
        tagCell = sheet1.getRow( 0).getCell( 4);
        list.clear();
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "@SettingTagName", list.get( 0).getSettingTagName());
        assertEquals( "sheetName4", list.get( 0).getSheetName());
        assertEquals( "sheetName5", list.get( 1).getSheetName());
        assertEquals( new Integer( 7), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 8), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 10), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 11), list.get( 1).getValueRowNum());

        // No.3 V[gZnull
        tagCell = sheet2.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.4 _sNoZnull
        tagCell = sheet2.getRow( 8).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 11, cell.getRow().getRowNum());
            assertEquals( 1, cell.getColumnIndex());
        }

        // No.5 f[^JnsNoZnull
        tagCell = sheet2.getRow( 16).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 20, cell.getRow().getRowNum());
            assertEquals( 2, cell.getColumnIndex());
        }

        // No.6 snull
        tagCell = sheet2.getRow( 24).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName9", list.get( 0).getSheetName());
        assertEquals( "sheetName10", list.get( 1).getSheetName());
        assertEquals( new Integer( 17), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 18), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 19), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 20), list.get( 1).getValueRowNum());

        // No.7 ΏۃZׂnull̍s
        tagCell = sheet2.getRow( 32).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName11", list.get( 0).getSheetName());
        assertEquals( "sheetName12", list.get( 1).getSheetName());
        assertEquals( new Integer( 21), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 22), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 23), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 24), list.get( 1).getValueRowNum());

        // No.8 _sNolȊO
        tagCell = sheet2.getRow( 40).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 42, cell.getRow().getRowNum());
            assertEquals( 1, cell.getColumnIndex());
        }

        // No.9 f[^JnsNolȊO
        tagCell = sheet2.getRow( 46).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 48, cell.getRow().getRowNum());
            assertEquals( 2, cell.getColumnIndex());
        }

        // No.10 }CiX͈͎w
        tagCell = sheet3.getRow( 5).getCell( 0);
        list.clear();
        list = parser.parse( sheet3, tagCell, data);
        assertEquals( 3, list.size());
        assertEquals( "sheetName1", list.get( 0).getSheetName());
        assertEquals( "sheetName2", list.get( 1).getSheetName());
        assertEquals( "sheetName3", list.get( 2).getSheetName());
        assertEquals( new Integer( 1), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 2), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 3), list.get( 2).getLogicalNameRowNum());
        assertEquals( new Integer( 4), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 5), list.get( 1).getValueRowNum());
        assertEquals( new Integer( 6), list.get( 2).getValueRowNum());

        // No.11 DataRowFrom > DataRowTo
        tagCell = sheet3.getRow( 9).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 9, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.12 DataRowFromsilj
        tagCell = sheet3.getRow( 17).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 17, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }
        // No.13 DataRowTosilj
        tagCell = sheet3.getRow( 21).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 21, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.14 SettingTagNamesilj
        tagCell = sheet3.getRow( 25).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 25, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.15 ResultKeyw
        tagCell = sheet3.getRow( 29).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 29, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.16 DataRowFromseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.17 DataRowToseXgi1sڂŃf[^IsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 4);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.18 DataRowFromseXgiŏIsŃf[^JnsɃvXwj
        tagCell = sheet4.getRow( 15).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 15, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.19 DataRowToseXgiŏIsŃf[^IsɃvXwj
        tagCell = sheet4.getRow( 15).getCell( 4);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 15, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.20 ftHgRXgN^
        parser = new SheetToJavaParser();
        tagCell = sheet1.getRow( 0).getCell( 0);
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( tag + "Setting", list.get( 0).getSettingTagName());
        assertEquals( tag + "Setting", list.get( 1).getSettingTagName());
        assertEquals( "sheetName2", list.get( 0).getSheetName());
        assertEquals( "sheetName3", list.get( 1).getSheetName());
        assertEquals( new Integer( 2), list.get( 0).getLogicalNameRowNum());
        assertEquals( new Integer( 3), list.get( 1).getLogicalNameRowNum());
        assertEquals( new Integer( 5), list.get( 0).getValueRowNum());
        assertEquals( new Integer( 6), list.get( 1).getValueRowNum());
    }
}
