/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaSettingParserTest.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.trans.WorkbookTest;
import org.bbreak.excella.trans.tag.sheet2java.entity.TestEntity1;
import org.bbreak.excella.trans.tag.sheet2java.entity.TestEntity2;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;
import org.junit.Test;

/**
 * SheetToJavaSettingParsereXgNX
 * 
 * @since 1.0
 */
public class SheetToJavaSettingParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public SheetToJavaSettingParserTest( String version) {
        super( version);
    }

    @Test
    public final void testSheetToJavaSettingParser() throws ParseException {
        Workbook workbook = getWorkbook();
        Sheet sheet1 = workbook.getSheetAt( 0);
        Sheet sheet2 = workbook.getSheetAt( 1);
        Sheet sheet3 = workbook.getSheetAt( 2);
        Sheet sheet4 = workbook.getSheetAt( 3);
        String tag = "@SheetToJavaSetting";
        SheetToJavaSettingParser parser = new SheetToJavaSettingParser( tag);
        Cell tagCell = null;
        Object data = null;
        List<SheetToJavaSettingInfo> list = null;

        // ===============================================
        // parse( Sheet sheet, Cell tagCell, Object data)
        // ===============================================
        // No.1 p[^
        tagCell = sheet1.getRow( 0).getCell( 0);
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName2", list.get( 0).getSheetName());
        assertEquals( "sheetName3", list.get( 1).getSheetName());
        assertEquals( 2, list.get( 0).getValue());
        assertEquals( "value3", list.get( 1).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity2.class, list.get( 1).getClazz());
        assertEquals( "propertyInt1", list.get( 0).getPropertyName());
        assertEquals( "propertyStr2", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertTrue( list.get( 1).isUnique());

        // No.2 p[^L
        tagCell = sheet1.getRow( 0).getCell( 6);
        list.clear();
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName4", list.get( 0).getSheetName());
        assertEquals( "sheetName5", list.get( 1).getSheetName());
        assertEquals( "value4", list.get( 0).getValue());
        assertEquals( 5, list.get( 1).getValue());
        assertEquals( TestEntity2.class, list.get( 0).getClazz());
        assertEquals( TestEntity2.class, list.get( 1).getClazz());
        assertEquals( "propertyStr2", list.get( 0).getPropertyName());
        assertEquals( "propertyInt2", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertFalse( list.get( 1).isUnique());

        // No.3 V[gZnull
        tagCell = sheet2.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.4 lZnull
        tagCell = sheet2.getRow( 8).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 3, list.size());
        assertEquals( "sheetName3", list.get( 0).getSheetName());
        assertEquals( "sheetName4", list.get( 1).getSheetName());
        assertEquals( "sheetName5", list.get( 2).getSheetName());
        assertEquals( "value4", list.get( 0).getValue());
        assertNull( list.get( 1).getValue());
        assertEquals( "value5", list.get( 2).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity1.class, list.get( 1).getClazz());
        assertEquals( TestEntity2.class, list.get( 2).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyInt1", list.get( 1).getPropertyName());
        assertEquals( "propertyStr2", list.get( 2).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertTrue( list.get( 1).isUnique());
        assertTrue( list.get( 2).isUnique());

        // No.5 ΏۃGeBeBZnull
        tagCell = sheet2.getRow( 16).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 20, cell.getRow().getRowNum());
            assertEquals( 2, cell.getColumnIndex());
        }

        // No.6 ΏۃvpeBZnull
        tagCell = sheet2.getRow( 24).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 26, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
        }

        // No.7 dsZnull
        tagCell = sheet2.getRow( 32).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 3, list.size());
        assertEquals( "sheetName12", list.get( 0).getSheetName());
        assertEquals( "sheetName13", list.get( 1).getSheetName());
        assertEquals( "sheetName14", list.get( 2).getSheetName());
        assertEquals( "value12", list.get( 0).getValue());
        assertEquals( 13, list.get( 1).getValue());
        assertEquals( "value14", list.get( 2).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity1.class, list.get( 1).getClazz());
        assertEquals( TestEntity2.class, list.get( 2).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyInt1", list.get( 1).getPropertyName());
        assertEquals( "propertyStr2", list.get( 2).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertFalse( list.get( 1).isUnique());
        assertTrue( list.get( 2).isUnique());

        // No.8 snull
        tagCell = sheet2.getRow( 40).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName15", list.get( 0).getSheetName());
        assertEquals( "sheetName16", list.get( 1).getSheetName());
        assertEquals( "value15", list.get( 0).getValue());
        assertEquals( "value16", list.get( 1).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity2.class, list.get( 1).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyStr2", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertFalse( list.get( 1).isUnique());

        // No.9 ΏۃZׂnull̍s
        tagCell = sheet2.getRow( 48).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName17", list.get( 0).getSheetName());
        assertEquals( "sheetName18", list.get( 1).getSheetName());
        assertEquals( "value17", list.get( 0).getValue());
        assertEquals( "value18", list.get( 1).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity2.class, list.get( 1).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyStr2", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertFalse( list.get( 1).isUnique());

        // No.10 l_^O
        tagCell = sheet2.getRow( 56).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 1, list.size());
        assertEquals( "sheetName19", list.get( 0).getSheetName());
        assertEquals( "@LNAME(vpeB1)", list.get( 0).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertFalse( list.get( 0).isUnique());

        // No.11 l_^OAΏۃvpeBZnull
        tagCell = sheet2.getRow( 62).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 64, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
        }

        // No.12 lJX^vpeB^O
        tagCell = sheet2.getRow( 68).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 1, list.size());
        assertEquals( "sheetName21", list.get( 0).getSheetName());
        assertEquals( "@TestChildEntity{childPropertyStr1=@LNAME(qvpeB1),childPropertyInt1=@LNAME(qvpeB1)}", list.get( 0).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertNull( list.get( 0).getPropertyName());
        assertFalse( list.get( 0).isUnique());

        // No.13 lJX^vpeB^OAΏۃvpeBZnull
        tagCell = sheet2.getRow( 74).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 1, list.size());
        assertEquals( "sheetName22", list.get( 0).getSheetName());
        assertEquals( "@TestChildEntity{childPropertyStr1=@LNAME(qvpeB1),childPropertyInt1=@LNAME(qvpeB1)}", list.get( 0).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertNull( list.get( 0).getPropertyName());
        assertFalse( list.get( 0).isUnique());

        // No.14 lJX^vpeB^OAds
        tagCell = sheet2.getRow( 80).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 1, list.size());
        assertEquals( "sheetName22", list.get( 0).getSheetName());
        assertEquals( "@TestChildEntity{childPropertyStr1=@LNAME(qvpeB1),childPropertyInt1=@LNAME(qvpeB1)}", list.get( 0).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertNull( list.get( 0).getPropertyName());
        assertFalse( list.get( 0).isUnique());

        // No.15 lJX^vpeB^OAp[^s
        tagCell = sheet2.getRow( 86).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch (ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 88, cell.getRow().getRowNum());
            assertEquals( 1, cell.getColumnIndex());
        }

        // No.16 vpeBɐl
        tagCell = sheet2.getRow( 92).getCell( 0);
        list.clear();
        list = parser.parse( sheet2, tagCell, data);
        assertEquals( 1, list.size());
        assertEquals( "sheetName23", list.get( 0).getSheetName());
        assertEquals( "10", list.get( 0).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertFalse( list.get( 0).isUnique());

        // No.17 vpeBɕ
        tagCell = sheet2.getRow( 98).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 100, cell.getRow().getRowNum());
            assertEquals( 1, cell.getColumnIndex());
        }

        // No.18 tvpeBɕ
        tagCell = sheet2.getRow( 104).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 106, cell.getRow().getRowNum());
            assertEquals( 1, cell.getColumnIndex());
        }

        // No.19 ݂ȂGeBeB
        tagCell = sheet2.getRow( 110).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 112, cell.getRow().getRowNum());
            assertEquals( 2, cell.getColumnIndex());
        }

        // No.20 ݂ȂvpeB
        tagCell = sheet2.getRow( 116).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 118, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
        }

        // No.21 ΏۃGeBeBۃNX
        tagCell = sheet2.getRow( 122).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet2, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 124, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
        }

        // No.22 }CiX͈͎w
        tagCell = sheet3.getRow( 5).getCell( 0);
        list.clear();
        list = parser.parse( sheet3, tagCell, data);
        assertEquals( 3, list.size());
        assertEquals( "sheetName1", list.get( 0).getSheetName());
        assertEquals( "sheetName2", list.get( 1).getSheetName());
        assertEquals( "sheetName3", list.get( 2).getSheetName());
        assertEquals( "value1", list.get( 0).getValue());
        assertEquals( 2, list.get( 1).getValue());
        assertEquals( "value3", list.get( 2).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity1.class, list.get( 1).getClazz());
        assertEquals( TestEntity2.class, list.get( 2).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyInt1", list.get( 1).getPropertyName());
        assertEquals( "propertyStr2", list.get( 2).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertTrue( list.get( 1).isUnique());
        assertTrue( list.get( 2).isUnique());

        // No.23 DataRowFrom > DataRowTo
        tagCell = sheet3.getRow( 9).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 9, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.24 DataRowFromsilj
        tagCell = sheet3.getRow( 17).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 17, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.25 DataRowTosilj
        tagCell = sheet3.getRow( 21).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 21, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.26 ResultKeyw
        tagCell = sheet3.getRow( 25).getCell( 0);
        list.clear();
        list = parser.parse( sheet3, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName7", list.get( 0).getSheetName());
        assertEquals( "sheetName8", list.get( 1).getSheetName());
        assertEquals( "value7", list.get( 0).getValue());
        assertEquals( 8, list.get( 1).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity1.class, list.get( 1).getClazz());
        assertEquals( "propertyStr1", list.get( 0).getPropertyName());
        assertEquals( "propertyInt1", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertTrue( list.get( 1).isUnique());

        // No.27 DataRowFromseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.28 DataRowToseXgi1sڂŃf[^IsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 4);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.29 DataRowFromseXgiŏIsŃf[^JnsɃvXwj
        tagCell = sheet4.getRow( 15).getCell( 0);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 15, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
        }

        // No.30 DataRowToseXgiŏIsŃf[^IsɃvXwj
        tagCell = sheet4.getRow( 15).getCell( 4);
        list.clear();
        try {
            list = parser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 15, cell.getRow().getRowNum());
            assertEquals( 4, cell.getColumnIndex());
        }

        // No.31 ftHg^O
        parser = new SheetToJavaSettingParser();
        tagCell = sheet1.getRow( 0).getCell( 0);
        list = parser.parse( sheet1, tagCell, data);
        assertEquals( 2, list.size());
        assertEquals( "sheetName2", list.get( 0).getSheetName());
        assertEquals( "sheetName3", list.get( 1).getSheetName());
        assertEquals( 2, list.get( 0).getValue());
        assertEquals( "value3", list.get( 1).getValue());
        assertEquals( TestEntity1.class, list.get( 0).getClazz());
        assertEquals( TestEntity2.class, list.get( 1).getClazz());
        assertEquals( "propertyInt1", list.get( 0).getPropertyName());
        assertEquals( "propertyStr2", list.get( 1).getPropertyName());
        assertTrue( list.get( 0).isUnique());
        assertTrue( list.get( 1).isUnique());
    }
}
