/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: DefaultSheetToSqlDataConverterTest.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.bbreak.excella.core.exception.ParseException;
import org.junit.Test;

/**
 * DefaultSheetToSqlDataConvertereXgNX
 * 
 * @since 1.0
 */
public class DefaultSheetToSqlDataConverterTest {

    @Test
    @SuppressWarnings( "unchecked")
    public final void testDefaultSheetToSqlDataConverter() throws ParseException, java.text.ParseException {

        Object object = null;
        
        DefaultSheetToSqlDataConverter converter = new DefaultSheetToSqlDataConverter();
        
        // ===============================================
        // convert( Object object, String dataType)
        // ===============================================
        // No.1 f[^^FAlF
        String dataType = "";
        object = "";
        String result = converter.convert( object, dataType);
        assertEquals( "''", result);
        
        // No.2 f[^^FAlFl
        object = new Double(10.0);
        result = converter.convert( object, dataType);
        assertEquals( "'10.0'", result);
        
        // No.3 f[^^FAlF
        object = new Integer(10);
        result = converter.convert( object, dataType);
        assertEquals( "'10'", result);
        
        // No.4 f[^^FAlFt
        Calendar cal = Calendar.getInstance();
        cal.setTime( DateFormat.getDateInstance().parse( "2009/06/08"));
        object = cal.getTime();
        result = converter.convert( object, dataType);
        Date expectedDate = cal.getTime();
        assertEquals( "'" + expectedDate.toString() + "'", result);
        
        // No.5 f[^^FlAlFl
        dataType = "l";
        object = new Double(10.0);
        result = converter.convert( object, dataType);
        assertEquals( "10.0", result);
        
        // No.6 f[^^FlAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
        
        // No.7 f[^^FAlFl
        dataType = "";
        object = new Integer(10);
        result = converter.convert( object, dataType);
        assertEquals( "10", result);
        
        // No.8 f[^^FAlF
        dataType = "";
        object = new Double(10.0);
        result = converter.convert( object, dataType);
        assertEquals( "10", result);
        
        // No.9 f[^^FAlF
        dataType = "";
        object = new Double(10.5);
        try {
            result = converter.convert( object, dataType);
        } catch (ParseException pe) {
            // O
        }
        
        // No.10 f[^^FlAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
        
        // No.11 f[^^F_lAlF^
        dataType = "_l";
        object = Boolean.TRUE;
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "true";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);

        object = "TRUE";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);

        object = "t";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "T";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "y";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);

        object = "Y";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "yes";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "YES";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = "1";
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        object = new Integer(1);
        result = converter.convert( object, dataType);
        assertEquals( "TRUE", result);
        
        // No.12 f[^^F_lAlFU
        object = Boolean.FALSE;
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "false";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);

        object = "FALSE";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);

        object = "f";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "F";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "n";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);

        object = "N";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "no";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "NO";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = "0";
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        object = new Integer(0);
        result = converter.convert( object, dataType);
        assertEquals( "FALSE", result);
        
        // No.13 f[^^F_lAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }

        // No.14 f[^^FtAlFt
        dataType = "t";
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'2009-06-08'", result);
        
        // No.15 f[^^FtAlF
        cal.set( 2009, 5, 8, 18, 1, 2);
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'2009-06-08'", result);
        
        // No.16 f[^^FtAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
        
        // No.17 f[^^FԁAlF
        dataType = "";
        cal.set( 2009, 5, 8, 18, 1, 2);
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'18:01:02.0'", result);
        
        // No.18 f[^^FԁAlFt
        cal.setTime( DateFormat.getDateInstance().parse( "2009/06/08"));
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'00:00:00.0'", result);

        // No.19 f[^^FԁAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
        
        // No.20 f[^^F^CX^vAlF
        dataType = "^CX^v";
        cal.set( 2009, 5, 8, 18, 1, 2);
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'2009-06-08 18:01:02.0'", result);
        
        // No.21 f[^^F^CX^vAlFt
        cal.setTime( DateFormat.getDateInstance().parse( "2009/06/08"));
        object = cal.getTime();
        result = converter.convert( object, dataType);
        assertEquals( "'2009-06-08 00:00:00.0'", result);
        
        // No.22 f[^^FԁAlF
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
        
        // No.23 f[^^F֐AlF
        dataType = "֐";
        object = "CURRENT_TIMESTAMP";
        result = converter.convert( object, dataType);
        assertEquals( "CURRENT_TIMESTAMP", result);
        
        // No.24 f[^^F֐AlFl
        object = new Double(10.0);
        result = converter.convert( object, dataType);
        assertEquals( "10.0", result);
        
        // No.25 f[^^F֐AlF
        object = new Integer(10);
        result = converter.convert( object, dataType);
        assertEquals( "10", result);
        
        // No.26 f[^^F֐AlFt
        cal.setTime( DateFormat.getDateInstance().parse( "2009/06/08"));
        object = cal.getTime();
        result = converter.convert( object, dataType);
        expectedDate = cal.getTime();
        assertEquals( expectedDate.toString(), result);
        
        // No.27 lFnull
        object = null;
        result = converter.convert( object, dataType);
        assertNull( result);
        
        // No.28 f[^^F݂Ȃf[^^
        dataType = "݂Ȃf[^^";
        object = "";
        try {
            result = converter.convert( object, dataType);
            fail();
        } catch (ParseException pe) {
            // O
        }
    }
}
