/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.ConstantValue;
import net.w_horse.excelpojo.annotation.Converter;
import net.w_horse.excelpojo.annotation.HorizontalRepeats;
import net.w_horse.excelpojo.annotation.LabeledCell;
import net.w_horse.excelpojo.annotation.MappedCell;
import net.w_horse.excelpojo.annotation.PointedCell;
import net.w_horse.excelpojo.annotation.VerticalRepeats;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.converter.NothingConverter;
import net.w_horse.excelpojo.excel.cellseeker.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.AbstractRepeatsSeeker;
import net.w_horse.excelpojo.excel.cellseeker.CellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.CellSeekerManager;
import net.w_horse.excelpojo.excel.cellseeker.ConstantValueCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.HorizontalRepeatsSeeker;
import net.w_horse.excelpojo.excel.cellseeker.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.MappedCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.PointedCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.VerticalRepeatsSeeker;
import net.w_horse.excelpojo.xml.tag.DataDirection;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;
import net.w_horse.excelpojo.xml.tag.Use;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ExcelPOJOAnnotationParser {
    private String targetClass = "";
    private static final String ANN_ATTR_TARGET_CLASS = "targetClass";
    private static final String ANN_ATTR_LABEL = "label";
    private static final String ANN_ATTR_POSITION = "position";
    private static final String ANN_ATTR_TERMINATE = "terminate";
    private static final String ANN_ATTR_RETRIEVE_FROM = RetrieveFrom.getTagName();
    private static final String ANN_ATTR_MARGED_ROWS = "margedRows";
    private static final String ANN_ATTR_MARGED_LABEL = "margedLabel";
    private static final String ANN_ATTR_USE = Use.getTagName();
    private static final String ANN_ATTR_LIST_CLASS = "listClass";
    private static final String ANN_ATTR_SUCCEED_FIELDS = "succeedFields";
    private static final String ANN_ATTR_RANGE = "range";

    public void setTargetClassProperties(HashMap<String, CellSeeker> hashMap, Class<?> clazz) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                CellSeeker cellSeeker;
                if (annotation instanceof VerticalRepeats && hashMap.containsKey(field.getName())) {
                    cellSeeker = (VerticalRepeatsSeeker)hashMap.get(field.getName());
                    this.setRepeatsSeekerField(((AbstractCellSeeker)cellSeeker).getExcelPOJOBridge(), this.getRepeatsAnnnotationInfo((VerticalRepeats)annotation), RetrieveFrom.BOTTOM.getValue(), DataDirection.RIGHT.getValue());
                } else if (annotation instanceof HorizontalRepeats && hashMap.containsKey(field.getName())) {
                    cellSeeker = (HorizontalRepeatsSeeker)hashMap.get(field.getName());
                    this.setRepeatsSeekerField(((AbstractCellSeeker)cellSeeker).getExcelPOJOBridge(), this.getRepeatsAnnnotationInfo((HorizontalRepeats)annotation), RetrieveFrom.RIGHT.getValue(), DataDirection.DOWN.getValue());
                }
                if (!hashMap.containsKey(field.getName())) {
                    cellSeeker = this.buildCellSeeker(annotation);
                    if (cellSeeker == null) continue;
                    cellSeeker.set(annotation, this);
                    hashMap.put(field.getName(), cellSeeker);
                }
                if (!(annotation instanceof Converter)) continue;
                cellSeeker = hashMap.get(field.getName());
                if (cellSeeker == null) {
                    throw new ExcelPOJOException("There is no annotation specified on the target field.");
                }
                if (!(cellSeeker.getConverter() instanceof NothingConverter)) continue;
                try {
                    cellSeeker.setConverter(this.createCellFieldConverter((Converter)annotation));
                }
                catch (Throwable throwable) {
                    throw new ExcelPOJOException(throwable);
                }
            }
        }
    }

    private CellFieldConverter createCellFieldConverter(Converter converter) throws Exception {
        Class clazz = ClassUtils.forName((String)converter.converterClass());
        String[] stringArray = converter.constractorArgs().split(",");
        Object[] objectArray = new Object[converter.constractorArgs().isEmpty() ? 0 : stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = stringArray[i].trim();
        }
        CellFieldConverter cellFieldConverter = (CellFieldConverter)Utils.instantiateTarget(clazz, objectArray);
        String[] stringArray2 = converter.properties().split(",");
        if (converter.properties().isEmpty()) {
            return cellFieldConverter;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray3 = stringArray2[i].split("=");
            String string = stringArray3[0].trim();
            String string2 = stringArray3[1].trim();
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz, (String)string);
            if (propertyDescriptor == null) continue;
            ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)cellFieldConverter, (Object[])new Object[]{string2});
        }
        return cellFieldConverter;
    }

    public void setCellSeeker(Annotation annotation, LabeledCellSeeker labeledCellSeeker) {
        LabeledCell labeledCell = (LabeledCell)annotation;
        labeledCellSeeker.setLabel(labeledCell.label());
        labeledCellSeeker.setRetrieveFrom(labeledCell.retrieveFrom().getValue());
        labeledCellSeeker.setMargedLabel(String.valueOf(labeledCell.margedLabel()));
        labeledCellSeeker.setMargedRows(labeledCell.margedRows());
        labeledCellSeeker.setUse(labeledCell.use().getValue());
        labeledCellSeeker.setRange(labeledCell.range());
    }

    public void setCellSeeker(Annotation annotation, PointedCellSeeker pointedCellSeeker) {
        PointedCell pointedCell = (PointedCell)annotation;
        pointedCellSeeker.setPosition(pointedCell.position());
        pointedCellSeeker.setUse(pointedCell.use().getValue());
    }

    public void setCellSeeker(Annotation annotation, ConstantValueCellSeeker constantValueCellSeeker) {
        ConstantValue constantValue = (ConstantValue)annotation;
        constantValueCellSeeker.setValue(constantValue.value());
    }

    public void setCellSeeker(Annotation annotation, VerticalRepeatsSeeker verticalRepeatsSeeker) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
        HashMap<String, String> hashMap = null;
        hashMap = annotation instanceof Bean ? this.getRepeatsAnnnotationInfo((Bean)annotation) : this.getRepeatsAnnnotationInfo((VerticalRepeats)annotation);
        this.setRepeatsSeeker(hashMap, verticalRepeatsSeeker, RetrieveFrom.BOTTOM.getValue(), DataDirection.RIGHT.getValue());
    }

    public void setCellSeeker(Annotation annotation, HorizontalRepeatsSeeker horizontalRepeatsSeeker) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
        HashMap<String, String> hashMap = null;
        hashMap = annotation instanceof Bean ? this.getRepeatsAnnnotationInfo((Bean)annotation) : this.getRepeatsAnnnotationInfo((HorizontalRepeats)annotation);
        this.setRepeatsSeeker(hashMap, horizontalRepeatsSeeker, RetrieveFrom.RIGHT.getValue(), DataDirection.DOWN.getValue());
    }

    public void setCellSeeker(Annotation annotation, MappedCellSeeker mappedCellSeeker) {
        MappedCell mappedCell = (MappedCell)annotation;
        mappedCellSeeker.setPreviousLabel(mappedCell.previousLabel());
        mappedCellSeeker.setPosition(mappedCell.position());
        mappedCellSeeker.setRetrieveFrom(mappedCell.retrieveFrom().getValue());
        mappedCellSeeker.setDataDirection(mappedCell.dataDirection().getValue());
        mappedCellSeeker.setMargedLabel(String.valueOf(mappedCell.margedLabel()));
        mappedCellSeeker.setUse(mappedCell.use().getValue());
        mappedCellSeeker.setRange(mappedCell.range());
    }

    private HashMap<String, String> getRepeatsAnnnotationInfo(VerticalRepeats verticalRepeats) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ANN_ATTR_TARGET_CLASS, verticalRepeats.targetClass());
        hashMap.put(ANN_ATTR_LABEL, verticalRepeats.label());
        hashMap.put(ANN_ATTR_POSITION, verticalRepeats.position());
        hashMap.put(ANN_ATTR_TERMINATE, verticalRepeats.terminate());
        hashMap.put(ANN_ATTR_RETRIEVE_FROM, verticalRepeats.retrieveFrom().getValue());
        hashMap.put(ANN_ATTR_MARGED_ROWS, String.valueOf(verticalRepeats.margedRows()));
        hashMap.put(ANN_ATTR_MARGED_LABEL, String.valueOf(verticalRepeats.margedLabel()));
        hashMap.put(ANN_ATTR_USE, verticalRepeats.use().getValue());
        hashMap.put(ANN_ATTR_LIST_CLASS, verticalRepeats.listClass());
        hashMap.put(ANN_ATTR_SUCCEED_FIELDS, verticalRepeats.succeedFields());
        hashMap.put(ANN_ATTR_RANGE, verticalRepeats.range());
        return hashMap;
    }

    private HashMap<String, String> getRepeatsAnnnotationInfo(HorizontalRepeats horizontalRepeats) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ANN_ATTR_TARGET_CLASS, horizontalRepeats.targetClass());
        hashMap.put(ANN_ATTR_LABEL, horizontalRepeats.label());
        hashMap.put(ANN_ATTR_POSITION, horizontalRepeats.position());
        hashMap.put(ANN_ATTR_TERMINATE, horizontalRepeats.terminate());
        hashMap.put(ANN_ATTR_RETRIEVE_FROM, horizontalRepeats.retrieveFrom().getValue());
        hashMap.put(ANN_ATTR_MARGED_ROWS, String.valueOf(horizontalRepeats.margedRows()));
        hashMap.put(ANN_ATTR_MARGED_LABEL, String.valueOf(horizontalRepeats.margedLabel()));
        hashMap.put(ANN_ATTR_USE, horizontalRepeats.use().getValue());
        hashMap.put(ANN_ATTR_LIST_CLASS, horizontalRepeats.listClass());
        hashMap.put(ANN_ATTR_SUCCEED_FIELDS, horizontalRepeats.succeedFields());
        hashMap.put(ANN_ATTR_RANGE, horizontalRepeats.range());
        return hashMap;
    }

    private HashMap<String, String> getRepeatsAnnnotationInfo(Bean bean) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ANN_ATTR_TARGET_CLASS, this.getTargetClass());
        hashMap.put(ANN_ATTR_LABEL, bean.label());
        hashMap.put(ANN_ATTR_POSITION, bean.position());
        hashMap.put(ANN_ATTR_TERMINATE, bean.terminate());
        hashMap.put(ANN_ATTR_RETRIEVE_FROM, bean.retrieveFrom().getValue());
        hashMap.put(ANN_ATTR_MARGED_ROWS, String.valueOf(bean.margedRows()));
        hashMap.put(ANN_ATTR_MARGED_LABEL, String.valueOf(bean.margedLabel()));
        hashMap.put(ANN_ATTR_USE, bean.use().getValue());
        hashMap.put(ANN_ATTR_LIST_CLASS, bean.listClass());
        hashMap.put(ANN_ATTR_SUCCEED_FIELDS, "");
        hashMap.put(ANN_ATTR_RANGE, bean.range());
        return hashMap;
    }

    private void setRepeatsSeeker(HashMap<String, String> hashMap, AbstractRepeatsSeeker abstractRepeatsSeeker, String string, String string2) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
        abstractRepeatsSeeker.setLabel(hashMap.get(ANN_ATTR_LABEL));
        abstractRepeatsSeeker.setPosition(hashMap.get(ANN_ATTR_POSITION));
        abstractRepeatsSeeker.setTerminate(hashMap.get(ANN_ATTR_TERMINATE));
        String string3 = hashMap.get(ANN_ATTR_RETRIEVE_FROM);
        abstractRepeatsSeeker.setRetrieveFrom(string3.isEmpty() ? string : string3);
        abstractRepeatsSeeker.setMargedRows(Boolean.valueOf(hashMap.get(ANN_ATTR_MARGED_ROWS)));
        abstractRepeatsSeeker.setMargedLabel(hashMap.get(ANN_ATTR_MARGED_LABEL));
        abstractRepeatsSeeker.setUse(hashMap.get(ANN_ATTR_USE));
        abstractRepeatsSeeker.setListClass(hashMap.get(ANN_ATTR_LIST_CLASS));
        abstractRepeatsSeeker.setSucceedFields(hashMap.get(ANN_ATTR_SUCCEED_FIELDS));
        abstractRepeatsSeeker.setRange(hashMap.get(ANN_ATTR_RANGE));
        ExcelPOJOBridge excelPOJOBridge = new ExcelPOJOBridge();
        excelPOJOBridge.setTargetClass(hashMap.get(ANN_ATTR_TARGET_CLASS));
        this.setRepeatsSeekerField(excelPOJOBridge, hashMap, string, string2);
        abstractRepeatsSeeker.setExcelPOJOBridge(excelPOJOBridge);
    }

    private void setRepeatsSeekerField(ExcelPOJOBridge excelPOJOBridge, HashMap<String, String> hashMap, String string, String string2) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
        HashMap<String, CellSeeker> hashMap2 = excelPOJOBridge.getTargetClassProperties();
        Class clazz = ClassUtils.forName((String)hashMap.get(ANN_ATTR_TARGET_CLASS));
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                CellSeeker cellSeeker;
                if (hashMap2.containsKey(field.getName()) || (cellSeeker = this.buildCellSeeker(annotation)) == null) continue;
                cellSeeker.set(annotation, this);
                if (cellSeeker instanceof LabeledCellSeeker) {
                    ((LabeledCellSeeker)cellSeeker).setRetrieveFrom(string);
                } else if (cellSeeker instanceof MappedCellSeeker) {
                    ((MappedCellSeeker)cellSeeker).setRetrieveFrom(string);
                    ((MappedCellSeeker)cellSeeker).setDataDirection(string2);
                }
                hashMap2.put(field.getName(), cellSeeker);
            }
        }
    }

    private CellSeeker buildCellSeeker(Annotation annotation) throws ExcelPOJOException {
        try {
            return CellSeekerManager.getCellSeekerInstance(annotation);
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String string) {
        this.targetClass = string;
    }
}

