/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.converter;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import org.springframework.util.StringUtils;

public class StringDateConverter
implements CellFieldConverter {
    private String cellType = String.class.getName();
    private String cellFormat = "yyyy/M/d";
    private String fieldType = String.class.getName();
    private String fieldFormat = "yyyyMMdd";

    @Override
    public Object convertField2Cell(Object object) throws ExcelPOJOException {
        return this.convert(object, this.fieldType, this.fieldFormat, this.cellType, this.cellFormat);
    }

    @Override
    public Object convertCell2Field(Object object) throws ExcelPOJOException {
        return this.convert(object, this.cellType, this.cellFormat, this.fieldType, this.fieldFormat);
    }

    private Object convert(Object object, String string, String string2, String string3, String string4) throws ExcelPOJOException {
        if (object == null || object instanceof String && !StringUtils.hasLength((String)((String)object))) {
            return object;
        }
        try {
            if (string.equals(Date.class.getName()) && string3.equals(String.class.getName())) {
                return new SimpleDateFormat(string4).format(object);
            }
            if (string.equals(String.class.getName()) && string3.equals(String.class.getName())) {
                Date date = new SimpleDateFormat(string2).parse((String)object);
                return new SimpleDateFormat(string4).format(date);
            }
            if (string.equals(String.class.getName()) && string3.equals(Date.class.getName())) {
                Date date = new SimpleDateFormat(string2).parse((String)object);
                return date;
            }
            String string5 = String.format("An illegal type is specified between [%s] and [%s].\nOnly between String and Date can be specified for a conversion type.", this.cellType, this.fieldType);
            throw new IllegalArgumentException(string5);
        }
        catch (Exception exception) {
            throw new ExcelPOJOException(exception);
        }
    }

    public void setCellType(String string) {
        this.cellType = string;
    }

    public void setCellFormat(String string) {
        this.cellFormat = string;
    }

    public void setFieldType(String string) {
        this.fieldType = string;
    }

    public void setFieldFormat(String string) {
        this.fieldFormat = string;
    }
}

