/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel.cellseeker;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.cellseeker.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.CellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.MappedCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.PointedCellSeeker;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRepeatsSeeker
extends AbstractCellSeeker {
    private String label;
    private String position;
    private String terminate;
    private String retrieveFrom;
    private String listClass = "java.util.ArrayList";
    private boolean margedRows = false;
    private String margedLabel;
    private String succeedFields = "";

    abstract int getRowLimit(Sheet var1);

    abstract AbstractCellSeeker.Offset getOffset(int var1);

    abstract AbstractCellSeeker.Offset getOffset4MappedCell(int var1);

    @Override
    public boolean verify() throws IllegalArgumentException, ExcelPOJOException {
        super.verify();
        if (!StringUtils.hasLength((String)this.getLabel()) && !StringUtils.hasLength((String)this.getPosition())) {
            throw new IllegalArgumentException("Neither the label nor the position are specified.");
        }
        Pattern pattern = Pattern.compile("\\{(\\s*\\w+(_\\w+)*\\s*=\\s*\\w+(_\\w+)*\\s*)(,(\\s*\\w+(_\\w+)*\\s*=\\s*\\w+(_\\w+)*\\s*))*\\}");
        if (!this.getSucceedFields().isEmpty() && !pattern.matcher(this.getSucceedFields()).matches()) {
            throw new IllegalArgumentException("There is a mistake in the format of the succeedFields specification. \nFormat:{fieldName1 = parentFieldName1 [, fieldName2 = parentFieldName2]...}");
        }
        if (StringUtils.hasLength((String)this.getListClass())) {
            try {
                Class clazz = ClassUtils.forName((String)this.getListClass());
                if (!ClassUtils.isAssignable(List.class, (Class)clazz) && !clazz.isArray()) {
                    throw new IllegalArgumentException("There is an invalid class in the listClass specification. ");
                }
            }
            catch (Throwable throwable) {
                throw new ExcelPOJOException(throwable);
            }
        }
        return true;
    }

    protected abstract AbstractCellSeeker.Offset getRangeOffset();

    @Override
    public Object seekCellValue(Sheet sheet, Class<?> clazz) throws ClassNotFoundException, LinkageError, IllegalArgumentException, ExcelPOJOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AbstractCellSeeker.Offset offset = this.seekCellPosition(sheet);
        if (offset == null) {
            if (Use.equalsIgnoreCase(Use.REQUIRED, this.getUse())) {
                throw new CellNotFoundException("label='" + this.getLabel() + "'");
            }
            return this.convertListObject(arrayList, ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass()));
        }
        HashMap<String, CellSeeker> hashMap = this.getExcelPOJOBridge().getTargetClassProperties();
        int n = this.getRowLimit(sheet);
        for (int i = 0; i <= n; ++i) {
            Class clazz2 = ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass());
            ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
            excelPOJOAnnotationParser.setTargetClassProperties(hashMap, clazz2);
            Object object = Utils.instantiateTarget(this.getExcelPOJOBridge().getTargetClass());
            boolean bl = false;
            for (String string : hashMap.keySet()) {
                Map<String, Object> map;
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz2, (String)string);
                if (propertyDescriptor == null) continue;
                CellSeeker cellSeeker = hashMap.get(string);
                cellSeeker.verify();
                if (cellSeeker instanceof LabeledCellSeeker) {
                    LabeledCellSeeker labeledCellSeeker = (LabeledCellSeeker)cellSeeker;
                    labeledCellSeeker.setRange(this.convertOffset2RangeString(offset, this.getRangeOffset()));
                    AbstractCellSeeker.Offset offset2 = labeledCellSeeker.seekCellPosition(sheet, offset, this.getOffset(i));
                    String string2 = this.getCellValue(sheet, offset2, String.class);
                    if (!this.getTerminate().isEmpty() && string2 != null && string2.equals(this.getTerminate())) break;
                    if (!this.isEmpty(string2)) {
                        bl = true;
                    }
                    map = this.getCellValue(sheet, offset2, propertyDescriptor.getPropertyType());
                    if (this.isEmpty(string2) && (this.isMargedRows() || labeledCellSeeker.isMargedRows())) {
                        map = this.seekMargedRowsValue(sheet, offset2, i, propertyDescriptor.getPropertyType(), labeledCellSeeker.getConverter());
                    }
                } else {
                    map = cellSeeker instanceof MappedCellSeeker ? ((MappedCellSeeker)cellSeeker).seekCellValue(sheet, offset, this.getOffset4MappedCell(0), this.getOffset(i)) : cellSeeker.seekCellValue(sheet, propertyDescriptor.getPropertyType());
                }
                ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{map});
            }
            if (!bl) break;
            arrayList.add(object);
        }
        return this.convertListObject(arrayList, ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass()));
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet) throws IllegalArgumentException, ExcelPOJOException {
        return this.seekCellPosition(sheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) throws IllegalArgumentException, ExcelPOJOException {
        AbstractCellSeeker abstractCellSeeker;
        if (!this.getLabel().isEmpty()) {
            LabeledCellSeeker labeledCellSeeker = new LabeledCellSeeker();
            labeledCellSeeker.setLabel(this.getLabel());
            labeledCellSeeker.setMargedLabel(this.getMargedLabel());
            labeledCellSeeker.setRetrieveFrom(this.getRetrieveFrom());
            labeledCellSeeker.setUse(this.getUse());
            labeledCellSeeker.setRange(this.getRange());
            abstractCellSeeker = labeledCellSeeker;
        } else {
            PointedCellSeeker pointedCellSeeker = new PointedCellSeeker();
            pointedCellSeeker.setPosition(this.getPosition());
            pointedCellSeeker.setUse(this.getUse());
            pointedCellSeeker.setRange(this.getRange());
            abstractCellSeeker = pointedCellSeeker;
        }
        ((AbstractCellSeeker)abstractCellSeeker).verify();
        return ((AbstractCellSeeker)abstractCellSeeker).seekCellPosition(sheet, offset, offset2);
    }

    private Object convertListObject(ArrayList<?> arrayList, Class<?> clazz) throws ClassNotFoundException, LinkageError {
        if (this.getListClass().isEmpty()) {
            return arrayList;
        }
        Class clazz2 = ClassUtils.forName((String)this.getListClass());
        if (ClassUtils.isAssignable(List.class, (Class)clazz2)) {
            Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)clazz2, (Class[])new Class[]{Collection.class});
            return BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{arrayList});
        }
        if (clazz2.isArray()) {
            Object object = Array.newInstance(clazz, arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                Array.set(object, i, arrayList.get(i));
            }
            return object;
        }
        return arrayList;
    }

    @Override
    public void setValue(Sheet sheet, Object object) throws IllegalArgumentException, ExcelPOJOException {
        AbstractCellSeeker.Offset offset = this.seekCellPosition(sheet);
        List list = null;
        if (ClassUtils.isAssignable(List.class, object.getClass())) {
            list = (List)object;
        } else if (object.getClass().isArray()) {
            list = CollectionUtils.arrayToList((Object)object);
        }
        HashMap<String, CellSeeker> hashMap = this.getExcelPOJOBridge().getTargetClassProperties();
        int n = 0;
        for (Object e : list) {
            for (String string : hashMap.keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(e.getClass(), (String)string);
                CellSeeker cellSeeker = hashMap.get(string);
                cellSeeker.setRange(this.convertOffset2RangeString(offset, this.getRangeOffset()));
                cellSeeker.verify();
                Object object2 = ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), e, (Object[])new Object[0]);
                if (cellSeeker instanceof MappedCellSeeker) {
                    ((MappedCellSeeker)cellSeeker).setValue(sheet, offset, this.getOffset4MappedCell(0), this.getOffset(n), object2);
                    continue;
                }
                cellSeeker.setValue(sheet, offset, this.getOffset(n), object2);
            }
            ++n;
        }
    }

    @Override
    public void setValue(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) {
    }

    private Object seekMargedRowsValue(Sheet sheet, AbstractCellSeeker.Offset offset, int n, Class<?> clazz, CellFieldConverter cellFieldConverter) throws ExcelPOJOException {
        Object object = Utils.convertIfNecessary(null, clazz);
        for (int i = 1; i <= n; ++i) {
            AbstractCellSeeker.Offset offset2 = this.getOffset(-i);
            object = this.getCellValue(this.getCell(sheet, offset, offset2), clazz);
            if (this.isEmpty(object)) continue;
            return object;
        }
        return object;
    }

    private boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        return false;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public String getPosition() {
        return this.position;
    }

    public void setTerminate(String string) {
        this.terminate = string;
    }

    public String getTerminate() {
        return this.terminate;
    }

    public void setRetrieveFrom(String string) {
        this.retrieveFrom = string;
    }

    public String getRetrieveFrom() {
        return this.retrieveFrom;
    }

    public void setListClass(String string) {
        this.listClass = string;
    }

    public String getListClass() {
        return this.listClass;
    }

    public void setMargedRows(boolean bl) {
        this.margedRows = bl;
    }

    public boolean isMargedRows() {
        return this.margedRows;
    }

    public void setMargedLabel(String string) {
        this.margedLabel = string;
    }

    public String getMargedLabel() {
        return this.margedLabel;
    }

    public void setSucceedFields(String string) {
        this.succeedFields = string;
    }

    public String getSucceedFields() {
        return this.succeedFields;
    }
}

