
#==============================================================================#
# exerb/recipefile.rb
# $Id: recipefile.rb,v 1.3 2003/02/21 05:14:48 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # RecipeFile Class
  class RecipeFile

    def initialize(filepath)
      @basedir = File.dirname(File.expand_path(filepath))
      @archive = Archive.new

      @corename = nil
      @corefile = nil
      @output   = nil
      @compress = false

      lineno = 0

      File.open(filepath) { |file|
        file.to_a
      }.collect { |line|
        [lineno += 1, line.strip]
      }.reject { |lineno, line|
        line.empty? || /^#/ =~ line
      }.collect { |lineno, line|
        [lineno, line.split(/\t+/)]
      }.each { |lineno, (type, p1, p2)|
        case type.downcase
        when 'kcode'    then @archive.set_kcode(p1)
        when 'corename' then @corename = p1
        when 'corefile' then @corefile = File.expand_path(p1, @basedir)
        when 'output'   then @output   = File.expand_path(p1, @basedir)
        when 'compress' then @compress = str2bool(p1, lineno)
        when 'script'   then @archive.add_script(p1, File.expand_path(p2 || p1, @basedir))
        when 'library'  then @archive.add_library(p1, File.expand_path(p2 || p1, @basedir))
        when 'binary'   then @archive.add_binary(p1, File.expand_path(p2 || p1, @basedir))
        else raise "Unknown directive '#{type}' in line #{lineno}"
        end
      }
    end

    attr_reader :archive, :corename, :corefile, :output, :compress

    def str2bool(str, lineno)
      case str
      when 'true',  'on',  'yes' then true
      when 'false', 'off', 'no'  then false
      else raise "Unknown parameter '#{str}' in line #{lineno}"
      end
    end
    private :str2bool

  end # RecipeFile

end # Exerb

#==============================================================================#
#==============================================================================#
