// $Id: exerb.h,v 1.31 2003/10/30 10:18:57 yuya Exp $

#pragma pack(push, 1)

typedef struct {
	DWORD signature1;
	DWORD signature2;
	DWORD offset_of_archive;
	union {
		DWORD all;
		struct {
			DWORD kcode:2;
			DWORD reserved:30;
		};
	} options;
} EXERB_HEADER;

typedef struct {
	DWORD signature;
	DWORD offset_of_name_table;
	DWORD size_of_name_table;
	DWORD offset_of_file_table;
	DWORD size_of_file_table;
	DWORD offset_of_plugin_table;
	DWORD size_of_plugin_table;
	union {
		DWORD all;
		struct {
			DWORD compressed:1;
			DWORD reserved:31;
		};
	} options;
} ARCHIVE_HEADER;

typedef struct {
	DWORD signature;
	WORD  number_of_headers;
	DWORD offset_of_headers;
	DWORD offset_of_pool;
} NAME_TABLE_HEADER;

typedef struct {
	WORD  id;
	DWORD offset_of_name;
} NAME_ENTRY_HEADER;

typedef struct {
	DWORD signature;
	WORD  number_of_headers;
	DWORD offset_of_headers;
	DWORD offset_of_pool;
} FILE_TABLE_HEADER;

typedef struct {
	WORD  id;
	DWORD offset_of_file;
	DWORD size_of_file;
	BYTE  type_of_file;
} FILE_ENTRY_HEADER;

typedef struct {
	DWORD signature;
	WORD  number_of_headers;
	DWORD offset_of_headers;
	DWORD offset_of_pool;
} PLUGIN_TABLE_HEADER;

typedef struct {
	DWORD offset_of_plugin;
	DWORD size_of_plugin;
} PLUGIN_ENTRY_HEADER;

#pragma pack(pop)

#define EXERB_HEADER_SIGNATURE1    0x52455845
#define EXREB_HEADER_SIGNATURE2    0x01000042
#define EXERB_HEADER_OPTIONS_KCODE_NONE 0
#define EXERB_HEADER_OPTIONS_KCODE_EUC  1
#define EXERB_HEADER_OPTIONS_KCODE_SJIS 2
#define EXERB_HEADER_OPTIONS_KCODE_UTF8 3

#define ARCHIVE_HEADER_SIGNATURE       0x01004145
#define NAME_TABLE_HEADER_SIGNATURE    0x0100544E
#define FILE_TABLE_HEADER_SIGNATURE    0x01005446
#define PLUGIN_TABLE_HEADER_SIGNATURE  0x01005450

#define FILE_ENTRY_HEADER_TYPE_RUBY_SCRIPT       1
#define FILE_ENTRY_HEADER_TYPE_BRUBY_BINARY      2
#define FILE_ENTRY_HEADER_TYPE_EXTENSION_LIBRARY 3
#define FILE_ENTRY_HEADER_TYPE_RESOURCE_LIBRARY  4
#define FILE_ENTRY_HEADER_TYPE_DATA_BINARY       5

#define GET_FIRST_NAME_ENTRY(table_header)    (NAME_ENTRY_HEADER*)((DWORD)(table_header) + (table_header)->offset_of_headers)
#define GET_FIRST_FILE_ENTRY(table_header)    (FILE_ENTRY_HEADER*)((DWORD)(table_header) + (table_header)->offset_of_headers)
#define GET_FIRST_PLUGIN_ENTRY(table_header)  (PLUGIN_ENTRY_HEADER*)((DWORD)(table_header) + (table_header)->offset_of_headers)

#define GET_NAME_TABLE_POOL(table_header)    (char*)((DWORD)(table_header) + (table_header)->offset_of_pool)
#define GET_FILE_TABLE_POOL(table_header)    (char*)((DWORD)(table_header) + (table_header)->offset_of_pool)
#define GET_PLUGIN_TABLE_POOL(table_header)  (char*)((DWORD)(table_header) + (table_header)->offset_of_pool)

#define GET_NAME_FROM_ENTRY_HEADER(table_header, entry_header)    (char*)(GET_NAME_TABLE_POOL(table_header) + (entry_header)->offset_of_name)
#define GET_FILE_FROM_ENTRY_HEADER(table_header, entry_header)    (char*)(GET_FILE_TABLE_POOL(table_header) + (entry_header)->offset_of_file)
#define GET_PLUGIN_FROM_ENTRY_HEADER(table_header, entry_header)  (char*)(GET_PLUGIN_TABLE_POOL(table_header) + (entry_header)->offset_of_plugin)
