// $Id: module.cpp,v 1.1 2003/10/27 02:46:52 yuya Exp $

#include <windows.h>
#include <ruby.h>
#include "module.h"

////////////////////////////////////////////////////////////////////////////////

extern VALUE rb_mExerb;
extern VALUE rb_eExerbRuntimeError;

extern int     g_loaded_resource_count;
extern HMODULE g_loaded_resource_table[];

////////////////////////////////////////////////////////////////////////////////

static VALUE rb_exerb_s_runtime_p(VALUE self);
static VALUE rb_exerb_s_load_string(VALUE self, VALUE id);
static VALUE rb_exerb_s_load_icon(VALUE self, VALUE id);
static VALUE rb_exerb_s_load_cursor(VALUE self, VALUE id);
static LPCTSTR exerb_convert_resource_id(VALUE value);

////////////////////////////////////////////////////////////////////////////////

void
Init_Exerb()
{
	rb_mExerb = ::rb_define_module("Exerb");
	::rb_define_singleton_method(rb_mExerb, "runtime?",    (VALUE (*)(...))rb_exerb_s_runtime_p, 0);
	::rb_define_singleton_method(rb_mExerb, "load_string", (VALUE (*)(...))rb_exerb_s_load_string, 1);
	::rb_define_singleton_method(rb_mExerb, "load_icon",   (VALUE (*)(...))rb_exerb_s_load_icon, 1);
	::rb_define_singleton_method(rb_mExerb, "load_cursor", (VALUE (*)(...))rb_exerb_s_load_cursor, 1);

	rb_eExerbRuntimeError = ::rb_define_class_under(rb_mExerb, "RuntimeError", rb_eException);
}

static VALUE
rb_exerb_s_runtime_p(VALUE self)
{
	return Qtrue;
}

static VALUE
rb_exerb_s_load_string(VALUE self, VALUE id)
{
	LPCSTR res_id = ::exerb_convert_resource_id(id);
	char buffer[512] = "";

	for ( int i = 0; i < g_loaded_resource_count; i++ ) {
		if ( ::LoadString(g_loaded_resource_table[i], (unsigned int)res_id, buffer, sizeof(buffer)) ) {
			return ::rb_str_new2(buffer);
		}
	}

	return Qnil;
}

static VALUE
rb_exerb_s_load_icon(VALUE self, VALUE id)
{
	LPCSTR res_id = ::exerb_convert_resource_id(id);

	for ( int i = 0; i < g_loaded_resource_count; i++ ) {
		HICON icon = ::LoadIcon(g_loaded_resource_table[i], res_id);
		if ( icon ) return INT2NUM((int)icon);
	}

	return Qnil;
}

static VALUE
rb_exerb_s_load_cursor(VALUE self, VALUE id)
{
	LPCSTR res_id = ::exerb_convert_resource_id(id);

	for ( int i = 0; i < g_loaded_resource_count; i++ ) {
		HCURSOR icon = ::LoadCursor(g_loaded_resource_table[i], res_id);
		if ( icon ) return INT2NUM((int)icon);
	}

	return Qnil;
}

static LPCTSTR
exerb_convert_resource_id(VALUE value)
{
	switch ( TYPE(value) ) {
	case T_FIXNUM:
		return MAKEINTRESOURCE(FIX2INT(value));
	case T_STRING:
		return RSTRING(value)->ptr;
	default:
		::rb_raise(rb_eArgError, "argument needs to be integer or string");
		return NULL;
	}
}

////////////////////////////////////////////////////////////////////////////////
