
#==============================================================================#
# $Id: base.rb,v 1.3 2003/11/28 09:28:25 yuya Exp $
#==============================================================================#

module Exerb

  module Win32

    module Struct

      class Base

        def initialize
          @position = nil
        end

        attr_reader :position

        def self.read(io)
          return self.new.read(io)
        end

        def size
          return self.pack.size
        end

        def read(io)
          @position = io.pos
          return self.unpack(io.read(self.size))
        end

        def update(str)
          str[@position, self.size] = self.pack
        end

      end # Base

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
