/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.solr;

import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeConcurrentUpdateSolrServer
extends ConcurrentUpdateSolrServer {
    private Throwable currentException = null;
    private final Object myLock = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeConcurrentUpdateSolrServer.class);

    public SafeConcurrentUpdateSolrServer(String solrServerUrl, int queueSize, int threadCount) {
        this(solrServerUrl, null, queueSize, threadCount);
    }

    public SafeConcurrentUpdateSolrServer(String solrServerUrl, HttpClient client, int queueSize, int threadCount) {
        super(solrServerUrl, client, queueSize, threadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable ex) {
        assert (ex != null);
        Object object = this.myLock;
        synchronized (object) {
            this.currentException = ex;
        }
        LOGGER.error("handleError", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilFinished() {
        super.blockUntilFinished();
        Object object = this.myLock;
        synchronized (object) {
            if (this.currentException != null) {
                throw new RuntimeException(this.currentException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearException() {
        Object object = this.myLock;
        synchronized (object) {
            this.currentException = null;
        }
    }
}

