/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.morphlines.solr.DocumentLoader;
import org.apache.solr.morphlines.solr.SafeConcurrentUpdateSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrServerDocumentLoader
implements DocumentLoader {
    private final SolrServer server;
    private long numLoadedDocs = 0L;
    private final int batchSize;
    private final List<SolrInputDocument> batch = new ArrayList<SolrInputDocument>();
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrServerDocumentLoader.class);

    public SolrServerDocumentLoader(SolrServer server, int batchSize) {
        if (server == null) {
            throw new IllegalArgumentException("solr server must not be null");
        }
        this.server = server;
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be a positive number: " + batchSize);
        }
        this.batchSize = batchSize;
    }

    @Override
    public void beginTransaction() {
        LOGGER.trace("beginTransaction");
        this.batch.clear();
        this.numLoadedDocs = 0L;
        if (this.server instanceof SafeConcurrentUpdateSolrServer) {
            ((SafeConcurrentUpdateSolrServer)this.server).clearException();
        }
    }

    @Override
    public void load(SolrInputDocument doc) throws IOException, SolrServerException {
        LOGGER.trace("load doc: {}", (Object)doc);
        this.batch.add(doc);
        if (this.batch.size() >= this.batchSize) {
            this.loadBatch();
        }
    }

    @Override
    public void commitTransaction() throws SolrServerException, IOException {
        LOGGER.trace("commitTransaction");
        if (this.batch.size() > 0) {
            this.loadBatch();
        }
        if (this.numLoadedDocs > 0L && this.server instanceof ConcurrentUpdateSolrServer) {
            ((ConcurrentUpdateSolrServer)this.server).blockUntilFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBatch() throws SolrServerException, IOException {
        this.numLoadedDocs += (long)this.batch.size();
        try {
            UpdateResponse updateResponse = this.server.add(this.batch);
        }
        finally {
            this.batch.clear();
        }
    }

    @Override
    public UpdateResponse rollbackTransaction() throws SolrServerException, IOException {
        LOGGER.trace("rollback");
        if (!(this.server instanceof CloudSolrServer)) {
            return this.server.rollback();
        }
        return new UpdateResponse();
    }

    @Override
    public void shutdown() {
        LOGGER.trace("shutdown");
        this.server.shutdown();
    }

    @Override
    public SolrPingResponse ping() throws SolrServerException, IOException {
        LOGGER.trace("ping");
        return this.server.ping();
    }

    public SolrServer getSolrServer() {
        return this.server;
    }
}

