/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    protected static final Logger log = LoggerFactory.getLogger(CoreContainer.class);
    private final SolrCores solrCores = new SolrCores(this);
    protected final Map<String, Exception> coreInitFailures = Collections.synchronizedMap(new LinkedHashMap());
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    private InfoHandler infoHandler;
    protected Properties containerProperties;
    private ConfigSetService coreConfigService;
    protected ZkContainer zkSys = new ZkContainer();
    protected ShardHandlerFactory shardHandlerFactory;
    private UpdateShardHandler updateShardHandler;
    protected LogWatcher logging = null;
    private CloserThread backgroundCloser = null;
    protected final ConfigSolr cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    protected final CoresLocator coresLocator;
    private String hostName;
    private volatile boolean isShutDown;

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(loader, ConfigSolr.fromSolrHome(loader, loader.getInstanceDir()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(solrHome));
    }

    public CoreContainer(SolrResourceLoader loader, ConfigSolr config) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = (SolrResourceLoader)Preconditions.checkNotNull((Object)loader);
        this.solrHome = loader.getInstanceDir();
        this.cfg = (ConfigSolr)Preconditions.checkNotNull((Object)config);
        this.coresLocator = config.getCoresLocator();
    }

    public CoreContainer(SolrResourceLoader loader, ConfigSolr config, CoresLocator locator) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = (SolrResourceLoader)Preconditions.checkNotNull((Object)loader);
        this.solrHome = loader.getInstanceDir();
        this.cfg = (ConfigSolr)Preconditions.checkNotNull((Object)config);
        this.coresLocator = locator;
    }

    protected CoreContainer(Object testConstructor) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
    }

    public static CoreContainer createAndLoad(String solrHome, File configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(loader, ConfigSolr.fromFile(loader, configFile));
        cc.load();
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        log.info("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstanceDir());
        String libDir = this.cfg.getSharedLibDirectory();
        if (libDir != null) {
            File f = FileUtils.resolvePath(new File(this.solrHome), libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.loader.addToClassLoader(libDir, null, false);
            this.loader.reloadLuceneSPI();
        }
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        this.updateShardHandler = new UpdateShardHandler(this.cfg);
        this.solrCores.allocateLazyCores(this.cfg.getTransientCacheSize(), this.loader);
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        this.hostName = this.cfg.getHost();
        log.info("Host Name: " + this.hostName);
        this.zkSys.initZooKeeper(this, this.solrHome, this.cfg);
        this.collectionsHandler = this.createHandler(this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        this.infoHandler = this.createHandler(this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.coreAdminHandler = this.createHandler(this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        this.coreConfigService = this.cfg.createCoreConfigService(this.loader, this.zkSys.getZkController());
        this.containerProperties = this.cfg.getSolrProperties("solr");
        ExecutorService coreLoadExecutor = Executors.newFixedThreadPool(this.zkSys.getZkController() == null ? this.cfg.getCoreLoadThreadCount() : Integer.MAX_VALUE, new DefaultSolrThreadFactory("coreLoadExecutor"));
        try {
            ExecutorCompletionService<SolrCore> completionService = new ExecutorCompletionService<SolrCore>(coreLoadExecutor);
            HashSet<Future<SolrCore>> pending = new HashSet<Future<SolrCore>>();
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            CoreContainer.checkForDuplicateCoreNames(cds);
            for (final CoreDescriptor cd : cds) {
                final String name = cd.getName();
                try {
                    if (cd.isTransient() || !cd.isLoadOnStartup()) {
                        this.solrCores.putDynamicDescriptor(name, cd);
                    }
                    if (!cd.isLoadOnStartup()) continue;
                    Callable<SolrCore> task = new Callable<SolrCore>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public SolrCore call() {
                            SolrCore c;
                            block3: {
                                c = null;
                                try {
                                    if (CoreContainer.this.zkSys.getZkController() != null) {
                                        CoreContainer.this.preRegisterInZk(cd);
                                    }
                                    c = CoreContainer.this.create(cd);
                                    CoreContainer.this.registerCore(cd.isTransient(), name, c, false, false);
                                }
                                catch (Exception e) {
                                    SolrException.log((Logger)log, null, (Throwable)e);
                                    if (c == null) break block3;
                                    c.close();
                                }
                            }
                            return c;
                        }
                    };
                    pending.add(completionService.submit(task));
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
            }
            while (pending != null && pending.size() > 0) {
                Future future;
                block21: {
                    try {
                        future = completionService.take();
                        if (future != null) break block21;
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted while loading core", (Throwable)e);
                    }
                }
                pending.remove(future);
                try {
                    SolrCore c = (SolrCore)future.get();
                    if (c == null) continue;
                    this.solrCores.putCoreToOrigName(c, c.getName());
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"Error loading core", (Throwable)e);
                }
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (coreLoadExecutor != null) {
                ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
        if (this.isZooKeeperAware()) {
            Collection<SolrCore> cores = this.getCores();
            if (cores != null) {
                for (SolrCore core : cores) {
                    try {
                        this.zkSys.registerInZk(core, true);
                    }
                    catch (Throwable t) {
                        SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)t);
                    }
                }
            }
            this.zkSys.getZkController().checkOverseerDesignate();
        }
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
            this.zkSys.publishCoresAsDown(this.solrCores.getCores());
        }
        try {
            this.coreAdminHandler.shutdown();
        }
        catch (Exception e) {
            log.warn("Error shutting down CoreAdminHandler. Continuing to shutdown CoreContainer.");
            e.printStackTrace();
        }
        try {
            block31: {
                Object e = this.solrCores.getModifyLock();
                synchronized (e) {
                    this.solrCores.getModifyLock().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block31;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            Object object = this.solrCores.getModifyLock();
            synchronized (object) {
                this.solrCores.getModifyLock().notifyAll();
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    this.shardHandlerFactory.close();
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        this.updateShardHandler.close();
                    }
                }
                finally {
                    this.zkSys.close();
                }
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not shutdown prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(boolean isTransientCore, String name, SolrCore core, boolean returnPrevNotClosed) {
        return this.registerCore(isTransientCore, name, core, returnPrevNotClosed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore registerCore(boolean isTransientCore, String name, SolrCore core, boolean returnPrevNotClosed, boolean registerInZk) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        if ((cd.isTransient() || !cd.isLoadOnStartup()) && this.solrCores.getDynamicDescriptor(name) == null) {
            this.solrCores.putDynamicDescriptor(name, cd);
        }
        SolrCore old = null;
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been shutdown");
        }
        old = isTransientCore ? this.solrCores.putTransientCore(this.cfg, name, core, this.loader) : this.solrCores.putCore(name, core);
        core.setName(name);
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            if (registerInZk) {
                this.zkSys.registerInZk(core, false);
            }
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrevNotClosed) {
            old.close();
        }
        if (registerInZk) {
            this.zkSys.registerInZk(core, false);
        }
        return old;
    }

    public SolrCore register(SolrCore core, boolean returnPrev) {
        return this.registerCore(core.getCoreDescriptor().isTransient(), core.getName(), core, returnPrev);
    }

    public SolrCore register(String name, SolrCore core, boolean returnPrev) {
        return this.registerCore(core.getCoreDescriptor().isTransient(), name, core, returnPrev);
    }

    public SolrCore create(String name, String instanceDir, String ... properties) {
        Properties props = new Properties();
        assert (properties.length % 2 == 0);
        for (int i = 0; i < properties.length; i += 2) {
            props.setProperty(properties[i], properties[i + 1]);
        }
        return this.create(new CoreDescriptor(this, name, instanceDir, props));
    }

    public SolrCore create(CoreDescriptor dcore) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has shutdown.");
        }
        try {
            ConfigSet coreConfig = this.coreConfigService.getConfig(dcore);
            log.info("Creating SolrCore '{}' using configuration from {}", (Object)dcore.getName(), (Object)coreConfig.getName());
            SolrCore core = new SolrCore(dcore, coreConfig);
            this.solrCores.addCreated(core);
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            return core;
        }
        catch (Exception e) {
            throw this.recordAndThrow(dcore.getName(), "Unable to create core: " + dcore.getName(), e);
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.solrCores.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.solrCores.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> getCoreInitFailures() {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, Exception>(this.coreInitFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) {
        try {
            name = this.checkDefault(name);
            SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
            }
            try {
                this.solrCores.waitAddPendingCoreOps(name);
                CoreDescriptor cd = core.getCoreDescriptor();
                ConfigSet coreConfig = this.coreConfigService.getConfig(cd);
                log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
                SolrCore newCore = core.reload(coreConfig, core);
                this.solrCores.removeCoreToOrigName(newCore, core);
                this.registerCore(false, name, newCore, false, false);
            }
            finally {
                this.solrCores.removeFromPendingOps(name);
            }
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to reload core: " + name, ex);
        }
    }

    private String checkDefault(String name) {
        return null == name || name.isEmpty() ? this.getDefaultCoreName() : name;
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        n0 = this.checkDefault(n0);
        n1 = this.checkDefault(n1);
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: " + n0 + " with " + n1);
    }

    public SolrCore remove(String name) {
        name = this.checkDefault(name);
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        SolrCore removed = this.solrCores.remove(name, true);
        this.coresLocator.delete(this, cd);
        return removed;
    }

    public void rename(String name, String toName) {
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                this.registerCore(false, toName, core, false);
                name = this.checkDefault(name);
                SolrCore old = this.solrCores.remove(name, false);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        for (CoreDescriptor cd : this.getCoreDescriptors()) {
            if (!cd.getName().equals(coreName)) continue;
            return cd;
        }
        return null;
    }

    public String getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name = this.checkDefault(name), true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getDynamicDescriptor(name);
        if (desc == null) {
            Exception e = this.getCoreInitFailures().get(name);
            if (null != e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.preRegisterInZk(desc);
                }
                core = this.create(desc);
                core.open();
                this.registerCore(desc.isTransient(), name, core, false);
            } else {
                core.open();
            }
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    protected <T> T createHandler(String handlerClass, Class<T> clazz) {
        return this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public String getDefaultCoreName() {
        return this.cfg.getDefaultCoreName();
    }

    @Deprecated
    public boolean isPersistent() {
        return this.cfg.isPersistent();
    }

    public String getAdminPath() {
        return this.cfg.getAdminPath();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public void preRegisterInZk(CoreDescriptor p) {
        this.zkSys.getZkController().preRegister(p);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrException recordAndThrow(String name, String msg, Exception ex) {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
            this.coreInitFailures.put(name, ex);
        }
        log.error(msg, (Throwable)ex);
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)ex);
    }

    String getCoreToOrigName(SolrCore core) {
        return this.solrCores.getCoreToOrigName(core);
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }
}

