/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class FieldFacetStats {
    public final String name;
    final SchemaField facet_sf;
    final SchemaField field_sf;
    final boolean calcDistinct;
    public final Map<String, StatsValues> facetStatsValues;
    List<HashMap<String, Integer>> facetStatsTerms;
    final AtomicReader topLevelReader;
    AtomicReaderContext leave;
    final ValueSource valueSource;
    AtomicReaderContext context;
    FunctionValues values;
    SortedDocValues topLevelSortedValues = null;

    public FieldFacetStats(SolrIndexSearcher searcher, String name, SchemaField field_sf, SchemaField facet_sf, boolean calcDistinct) {
        this.name = name;
        this.field_sf = field_sf;
        this.facet_sf = facet_sf;
        this.calcDistinct = calcDistinct;
        this.topLevelReader = searcher.getAtomicReader();
        this.valueSource = facet_sf.getType().getValueSource(facet_sf, null);
        this.facetStatsValues = new HashMap<String, StatsValues>();
        this.facetStatsTerms = new ArrayList<HashMap<String, Integer>>();
    }

    private StatsValues getStatsValues(String key) throws IOException {
        StatsValues stats = this.facetStatsValues.get(key);
        if (stats == null) {
            stats = StatsValuesFactory.createStatsValues(this.field_sf, this.calcDistinct);
            this.facetStatsValues.put(key, stats);
            stats.setNextReader(this.context);
        }
        return stats;
    }

    public void facet(int docID) throws IOException {
        String key = this.values.exists(docID) ? this.values.strVal(docID) : null;
        StatsValues stats = this.getStatsValues(key);
        stats.accumulate(docID);
    }

    public boolean facetTermNum(int docID, int statsTermNum) throws IOException {
        int term;
        int arrIdx;
        if (this.topLevelSortedValues == null) {
            this.topLevelSortedValues = FieldCache.DEFAULT.getTermsIndex(this.topLevelReader, this.name);
        }
        if ((arrIdx = (term = this.topLevelSortedValues.getOrd(docID))) >= 0 && arrIdx < this.topLevelSortedValues.getValueCount()) {
            String key = term == -1 ? null : this.topLevelSortedValues.lookupOrd(term).utf8ToString();
            while (this.facetStatsTerms.size() <= statsTermNum) {
                this.facetStatsTerms.add(new HashMap());
            }
            Map statsTermCounts = this.facetStatsTerms.get(statsTermNum);
            Integer statsTermCount = (Integer)statsTermCounts.get(key);
            if (statsTermCount == null) {
                statsTermCounts.put(key, 1);
            } else {
                statsTermCounts.put(key, statsTermCount + 1);
            }
            return true;
        }
        return false;
    }

    public boolean accumulateTermNum(int statsTermNum, BytesRef value) throws IOException {
        if (value == null) {
            return false;
        }
        while (this.facetStatsTerms.size() <= statsTermNum) {
            this.facetStatsTerms.add(new HashMap());
        }
        for (Map.Entry<String, Integer> stringIntegerEntry : this.facetStatsTerms.get(statsTermNum).entrySet()) {
            Integer count;
            Map.Entry<String, Integer> pairs = stringIntegerEntry;
            String key = pairs.getKey();
            StatsValues facetStats = this.facetStatsValues.get(key);
            if (facetStats == null) {
                facetStats = StatsValuesFactory.createStatsValues(this.field_sf, this.calcDistinct);
                this.facetStatsValues.put(key, facetStats);
            }
            if ((count = pairs.getValue()) == null) continue;
            facetStats.accumulate(value, count);
        }
        return true;
    }

    public void setNextReader(AtomicReaderContext ctx) throws IOException {
        this.context = ctx;
        this.values = this.valueSource.getValues(Collections.emptyMap(), ctx);
        for (StatsValues stats : this.facetStatsValues.values()) {
            stats.setNextReader(ctx);
        }
    }
}

