/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.FieldOptions;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

public class TermVectorComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "tv";
    protected NamedList initParams;
    public static final String TERM_VECTORS = "termVectors";

    private Set<String> getFields(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        String[] fldLst = params.getParams("tv.fl");
        if (null == fldLst || 0 == fldLst.length || 1 == fldLst.length && 0 == fldLst[0].length()) {
            SolrReturnFields rf = new SolrReturnFields(params.getParams("fl"), rb.req);
            if (((ReturnFields)rf).wantsAllFields()) {
                return null;
            }
            Set<String> fieldNames = ((ReturnFields)rf).getLuceneFieldNames();
            return null != fieldNames ? fieldNames : Collections.emptySet();
        }
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (String fl : fldLst) {
            fieldNames.addAll(Arrays.asList(SolrPluginUtils.split(fl)));
        }
        return fieldNames;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        DocIterator iter;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        NamedList termVectors = new NamedList();
        rb.rsp.add(TERM_VECTORS, termVectors);
        IndexSchema schema = rb.req.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        String uniqFieldName = null;
        if (keyField != null) {
            uniqFieldName = keyField.getName();
            termVectors.add("uniqueKeyFieldName", (Object)uniqFieldName);
        }
        FieldOptions allFields = new FieldOptions();
        allFields.termFreq = params.getBool("tv.tf", false);
        allFields.positions = params.getBool("tv.positions", false);
        allFields.offsets = params.getBool("tv.offsets", false);
        allFields.docFreq = params.getBool("tv.df", false);
        allFields.tfIdf = params.getBool("tv.tf_idf", false);
        if (params.getBool("tv.all", false)) {
            allFields.termFreq = true;
            allFields.positions = true;
            allFields.offsets = true;
            allFields.docFreq = true;
            allFields.tfIdf = true;
        }
        HashMap<String, FieldOptions> fieldOptions = new HashMap<String, FieldOptions>();
        NamedList warnings = new NamedList();
        ArrayList<String> noTV = new ArrayList<String>();
        ArrayList<String> noPos = new ArrayList<String>();
        ArrayList<String> noOff = new ArrayList<String>();
        Set<String> fields = this.getFields(rb);
        if (null != fields) {
            for (String field : fields) {
                if (null == field || "score".equals(field)) continue;
                boolean fieldIsUniqueKey = field.equals(uniqFieldName);
                SchemaField sf = schema.getFieldOrNull(field);
                if (sf != null) {
                    if (sf.storeTermVector()) {
                        FieldOptions option = (FieldOptions)fieldOptions.get(field);
                        if (option == null) {
                            option = new FieldOptions();
                            option.fieldName = field;
                            fieldOptions.put(field, option);
                        }
                        option.termFreq = params.getFieldBool(field, "tv.tf", allFields.termFreq);
                        option.docFreq = params.getFieldBool(field, "tv.df", allFields.docFreq);
                        option.tfIdf = params.getFieldBool(field, "tv.tf_idf", allFields.tfIdf);
                        option.positions = params.getFieldBool(field, "tv.positions", allFields.positions);
                        if (option.positions && !sf.storeTermPositions() && !fieldIsUniqueKey) {
                            noPos.add(field);
                        }
                        option.offsets = params.getFieldBool(field, "tv.offsets", allFields.offsets);
                        if (!option.offsets || sf.storeTermOffsets() || fieldIsUniqueKey) continue;
                        noOff.add(field);
                        continue;
                    }
                    if (fieldIsUniqueKey) continue;
                    noTV.add(field);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: " + field);
            }
        }
        boolean hasWarnings = false;
        if (!noTV.isEmpty()) {
            warnings.add("noTermVectors", noTV);
            hasWarnings = true;
        }
        if (!noPos.isEmpty()) {
            warnings.add("noPositions", noPos);
            hasWarnings = true;
        }
        if (!noOff.isEmpty()) {
            warnings.add("noOffsets", noOff);
            hasWarnings = true;
        }
        if (hasWarnings) {
            termVectors.add("warnings", (Object)warnings);
        }
        DocListAndSet listAndSet = rb.getResults();
        List<Integer> docIds = this.getInts(params.getParams("tv.docIds"));
        if (docIds != null && !docIds.isEmpty()) {
            iter = docIds.iterator();
        } else {
            DocList list = listAndSet.docList;
            iter = list.iterator();
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        DirectoryReader reader = searcher.getIndexReader();
        final String finalUniqFieldName = uniqFieldName;
        final ArrayList uniqValues = new ArrayList();
        StoredFieldVisitor getUniqValue = new StoredFieldVisitor(){

            public void stringField(FieldInfo fieldInfo, String value) {
                uniqValues.add(value);
            }

            public void intField(FieldInfo fieldInfo, int value) {
                uniqValues.add(Integer.toString(value));
            }

            public void longField(FieldInfo fieldInfo, long value) {
                uniqValues.add(Long.toString(value));
            }

            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
                return fieldInfo.name.equals(finalUniqFieldName) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
            }
        };
        TermsEnum termsEnum = null;
        while (iter.hasNext()) {
            Integer docId = (Integer)iter.next();
            NamedList docNL = new NamedList();
            if (keyField != null) {
                reader.document(docId.intValue(), getUniqValue);
                String uniqVal = null;
                if (uniqValues.size() != 0) {
                    uniqVal = (String)uniqValues.get(0);
                    uniqValues.clear();
                    docNL.add("uniqueKey", (Object)uniqVal);
                    termVectors.add(uniqVal, (Object)docNL);
                }
            } else {
                termVectors.add("doc-" + docId, (Object)docNL);
            }
            if (null != fields) {
                for (Map.Entry entry : fieldOptions.entrySet()) {
                    String field = (String)entry.getKey();
                    Terms vector = reader.getTermVector(docId.intValue(), field);
                    if (vector == null) continue;
                    termsEnum = vector.iterator(termsEnum);
                    this.mapOneVector((NamedList<Object>)docNL, (FieldOptions)entry.getValue(), (IndexReader)reader, docId, vector.iterator(termsEnum), field);
                }
                continue;
            }
            Fields vectors = reader.getTermVectors(docId.intValue());
            for (String field : vectors) {
                Terms terms = vectors.terms(field);
                if (terms == null) continue;
                termsEnum = terms.iterator(termsEnum);
                this.mapOneVector((NamedList<Object>)docNL, allFields, (IndexReader)reader, docId, termsEnum, field);
            }
        }
    }

    private void mapOneVector(NamedList<Object> docNL, FieldOptions fieldOptions, IndexReader reader, int docID, TermsEnum termsEnum, String field) throws IOException {
        BytesRef text;
        NamedList fieldNL = new NamedList();
        docNL.add(field, (Object)fieldNL);
        DocsAndPositionsEnum dpEnum = null;
        while ((text = termsEnum.next()) != null) {
            String term = text.utf8ToString();
            NamedList termInfo = new NamedList();
            fieldNL.add(term, (Object)termInfo);
            int freq = (int)termsEnum.totalTermFreq();
            if (fieldOptions.termFreq) {
                termInfo.add("tf", (Object)freq);
            }
            dpEnum = termsEnum.docsAndPositions(null, dpEnum);
            boolean useOffsets = false;
            boolean usePositions = false;
            if (dpEnum != null) {
                dpEnum.nextDoc();
                usePositions = fieldOptions.positions;
                useOffsets = fieldOptions.offsets;
            }
            NamedList positionsNL = null;
            NamedList theOffsets = null;
            if (usePositions || useOffsets) {
                for (int i = 0; i < freq; ++i) {
                    int pos = dpEnum.nextPosition();
                    if (usePositions && pos >= 0) {
                        if (positionsNL == null) {
                            positionsNL = new NamedList();
                            termInfo.add("positions", (Object)positionsNL);
                        }
                        positionsNL.add("position", (Object)pos);
                    }
                    if (useOffsets && theOffsets == null) {
                        if (dpEnum.startOffset() == -1) {
                            useOffsets = false;
                        } else {
                            theOffsets = new NamedList();
                            termInfo.add("offsets", (Object)theOffsets);
                        }
                    }
                    if (theOffsets == null) continue;
                    theOffsets.add("start", (Object)dpEnum.startOffset());
                    theOffsets.add("end", (Object)dpEnum.endOffset());
                }
            }
            int df = 0;
            if (fieldOptions.docFreq || fieldOptions.tfIdf) {
                df = reader.docFreq(new Term(field, text));
            }
            if (fieldOptions.docFreq) {
                termInfo.add("df", (Object)df);
            }
            if (!fieldOptions.tfIdf) continue;
            double tfIdfVal = (double)freq / (double)df;
            termInfo.add("tf-idf", (Object)tfIdfVal);
        }
    }

    private List<Integer> getInts(String[] vals) {
        ArrayList<Integer> result = null;
        if (vals != null && vals.length > 0) {
            result = new ArrayList<Integer>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                try {
                    result.add(new Integer(vals[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            NamedList termVectors = new NamedList();
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x40) == 0 || !sreq.params.getBool(COMPONENT_NAME, false)) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList nl = (NamedList)srsp.getSolrResponse().getResponse().get(TERM_VECTORS);
                    for (int i = 0; i < nl.size(); ++i) {
                        String key = nl.getName(i);
                        ShardDoc sdoc = rb.resultIds.get(key);
                        if (null == sdoc) {
                            if (termVectors.indexOf(key, 0) >= 0) continue;
                            termVectors.add(key, nl.getVal(i));
                            continue;
                        }
                        int idx = sdoc.positionInResponse;
                        arr[idx] = new NamedList.NamedListEntry(key, nl.getVal(i));
                    }
                }
            }
            termVectors.addAll(SolrPluginUtils.removeNulls(new NamedList((Map.Entry[])arr)));
            rb.rsp.add(TERM_VECTORS, termVectors);
        }
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_9/solr/core/src/java/org/apache/solr/handler/component/TermVectorComponent.java $";
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Vectors";
    }
}

