/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLDataSource
extends DataSource<Reader> {
    Logger LOG = LoggerFactory.getLogger(URLDataSource.class);
    private String baseUrl;
    private String encoding;
    private int connectionTimeout = 5000;
    private int readTimeout = 10000;
    private Context context;
    private Properties initProps;
    static final Pattern URIMETHOD = Pattern.compile("\\w{3,}:/");
    private static final Pattern CHARSET_PATTERN = Pattern.compile(".*?charset=(.*)$", 2);
    public static final String ENCODING = "encoding";
    public static final String BASE_URL = "baseUrl";
    public static final String UTF_8 = StandardCharsets.UTF_8.name();
    public static final String CONNECTION_TIMEOUT_FIELD_NAME = "connectionTimeout";
    public static final String READ_TIMEOUT_FIELD_NAME = "readTimeout";
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 10000;

    @Override
    public void init(Context context, Properties initProps) {
        this.context = context;
        this.initProps = initProps;
        this.baseUrl = this.getInitPropWithReplacements(BASE_URL);
        if (this.getInitPropWithReplacements(ENCODING) != null) {
            this.encoding = this.getInitPropWithReplacements(ENCODING);
        }
        String cTimeout = this.getInitPropWithReplacements(CONNECTION_TIMEOUT_FIELD_NAME);
        String rTimeout = this.getInitPropWithReplacements(READ_TIMEOUT_FIELD_NAME);
        if (cTimeout != null) {
            try {
                this.connectionTimeout = Integer.parseInt(cTimeout);
            }
            catch (NumberFormatException e) {
                this.LOG.warn("Invalid connection timeout: " + cTimeout);
            }
        }
        if (rTimeout != null) {
            try {
                this.readTimeout = Integer.parseInt(rTimeout);
            }
            catch (NumberFormatException e) {
                this.LOG.warn("Invalid read timeout: " + rTimeout);
            }
        }
    }

    @Override
    public Reader getData(String query) {
        URL url = null;
        try {
            Matcher m;
            String cType;
            url = URIMETHOD.matcher(query).find() ? new URL(query) : new URL(this.baseUrl + query);
            this.LOG.debug("Accessing URL: " + url.toString());
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(this.connectionTimeout);
            conn.setReadTimeout(this.readTimeout);
            InputStream in = conn.getInputStream();
            String enc = this.encoding;
            if (enc == null && (cType = conn.getContentType()) != null && (m = CHARSET_PATTERN.matcher(cType)).find()) {
                enc = m.group(1);
            }
            if (enc == null) {
                enc = UTF_8;
            }
            DataImporter.QUERY_COUNT.get().incrementAndGet();
            return new InputStreamReader(in, enc);
        }
        catch (Exception e) {
            this.LOG.error("Exception thrown while getting data", (Throwable)e);
            throw new DataImportHandlerException(500, "Exception in invoking url " + url, e);
        }
    }

    @Override
    public void close() {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private String getInitPropWithReplacements(String propertyName) {
        String expr = this.initProps.getProperty(propertyName);
        if (expr == null) {
            return null;
        }
        return this.context.replaceTokens(expr);
    }
}

