/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.ModuleGraphWriter;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartIni;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Version;
import org.eclipse.jetty.start.config.CommandLineConfigSource;
import org.eclipse.jetty.start.config.ConfigSource;

public class Main {
    private static final int EXIT_USAGE = 1;
    private BaseHome baseHome;
    private StartArgs jsvcStartArgs;

    public static void main(String[] args) {
        boolean test = false;
        try {
            Main main = new Main();
            StartArgs startArgs = main.processCommandLine(args);
            test = startArgs.isTestingModeEnabled();
            main.start(startArgs);
        }
        catch (UsageException e) {
            StartLog.error(e.getMessage(), new Object[0]);
            Main.usageExit(e.getCause(), e.getExitCode(), test);
        }
        catch (Throwable e) {
            Main.usageExit(e, -9, test);
        }
    }

    static void usageExit(int exit) {
        Main.usageExit(null, exit, false);
    }

    static void usageExit(Throwable t, int exit, boolean test) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar $JETTY_HOME/start.jar [options] [properties] [configs]");
        System.err.println("       java -jar $JETTY_HOME/start.jar --help  # for more information");
        if (test) {
            System.err.println("EXIT: " + exit);
        } else {
            System.exit(exit);
        }
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void dumpClasspathWithVersions(Classpath classpath) {
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Jetty Server Classpath:");
        System.out.println("-----------------------");
        if (classpath.count() == 0) {
            System.out.println("No classpath entries and/or version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the --module=name command line options will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            System.out.printf("%2d: %24s | %s\n", i++, this.getVersion(element), this.baseHome.toShortForm(element));
        }
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    private String getVersion(File element) {
        String name;
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile() && (name = element.getName().toLowerCase(Locale.ENGLISH)).endsWith(".jar")) {
            return JarVersion.getVersion(element);
        }
        return "";
    }

    public void invokeMain(ClassLoader classloader, StartArgs args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException {
        Class<?> invoked_class = null;
        String mainclass = args.getMainClassname();
        try {
            invoked_class = classloader.loadClass(mainclass);
        }
        catch (ClassNotFoundException e) {
            StartLog.error("Nothing to start, exiting ...", new Object[0]);
            StartLog.debug(e);
            Main.usageExit(-2);
            return;
        }
        StartLog.debug("%s - %s", invoked_class, invoked_class.getPackage().getImplementationVersion());
        CommandLineBuilder cmd = args.getMainArgs(false);
        String[] argArray = cmd.getArgs().toArray(new String[0]);
        StartLog.debug("Command Line Args: %s", cmd.toString());
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        StartLog.endStartLog();
        main.invoke(null, method_params);
    }

    public void listConfig(StartArgs args) {
        StartLog.endStartLog();
        args.dumpEnvironment();
        args.dumpJvmArgs();
        args.dumpSystemProperties();
        args.dumpProperties();
        this.dumpClasspathWithVersions(args.getClasspath());
        args.dumpActiveXmls();
    }

    public void listModules(StartArgs args) {
        List<String> tags = args.getListModules();
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Available Modules:");
        System.out.println("==================");
        System.out.println("tags: " + tags);
        args.getAllModules().dump(tags);
        System.out.println();
        System.out.println("Enabled Modules:");
        System.out.println("================");
        Modules modules = args.getAllModules();
        modules.dumpEnabled();
    }

    public StartArgs processCommandLine(List<String> cmdLine) throws Exception {
        return this.processCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public StartArgs processCommandLine(String[] cmdLine) throws Exception {
        CommandLineConfigSource cmdLineSource = new CommandLineConfigSource(cmdLine);
        this.baseHome = new BaseHome(cmdLineSource);
        StartLog.debug("jetty.home=%s", this.baseHome.getHome());
        StartLog.debug("jetty.base=%s", this.baseHome.getBase());
        StartLog.debug("Parsing collected arguments", new Object[0]);
        StartArgs args = new StartArgs(this.baseHome);
        args.parse(this.baseHome.getConfigSources());
        Modules modules = new Modules(this.baseHome, args);
        StartLog.debug("Registering all modules", new Object[0]);
        modules.registerAll();
        for (String enabledModule : args.getEnabledModules()) {
            for (String source : args.getSources(enabledModule)) {
                String shortForm = this.baseHome.toShortForm(source);
                modules.enable(enabledModule, shortForm);
            }
        }
        args.setAllModules(modules);
        List<Module> activeModules = modules.getEnabled();
        Version START_VERSION = new Version(StartArgs.VERSION);
        for (Module enabled : activeModules) {
            if (!enabled.getVersion().isNewerThan(START_VERSION)) continue;
            throw new UsageException(-6, "Module [" + enabled.getName() + "] specifies jetty version [" + enabled.getVersion() + "] which is newer than this version of jetty [" + START_VERSION + "]", new Object[0]);
        }
        for (String name : args.getSkipFileValidationModules()) {
            Module module = modules.get(name);
            module.setSkipFilesValidation(true);
        }
        args.expandSystemProperties();
        args.expandLibs();
        args.expandModules(activeModules);
        args.resolveExtraXmls();
        args.resolvePropertyFiles();
        return args;
    }

    public void start(StartArgs args) throws IOException, InterruptedException {
        BaseBuilder baseBuilder;
        StartLog.debug("StartArgs: %s", args);
        Classpath classpath = args.getClasspath();
        System.setProperty("java.class.path", classpath.toString());
        if (args.isHelp()) {
            this.usage(true);
        }
        if (args.isListClasspath()) {
            this.dumpClasspathWithVersions(classpath);
        }
        if (args.isListConfig()) {
            this.listConfig(args);
        }
        if (args.getListModules() != null) {
            this.listModules(args);
        }
        if (args.getModuleGraphFilename() != null) {
            Path outputFile = this.baseHome.getBasePath(args.getModuleGraphFilename());
            System.out.printf("Generating GraphViz Graph of Jetty Modules at %s%n", this.baseHome.toShortForm(outputFile));
            ModuleGraphWriter writer = new ModuleGraphWriter();
            writer.config(args.getProperties());
            writer.write(args.getAllModules(), outputFile);
        }
        if (args.isDryRun()) {
            CommandLineBuilder cmd = args.getMainArgs(true);
            System.out.println(cmd.toString(StartLog.isDebugEnabled() ? " \\\n" : " "));
        }
        if (args.isStopCommand()) {
            this.doStop(args);
        }
        if (args.isUpdateIni()) {
            for (ConfigSource config : this.baseHome.getConfigSources()) {
                System.out.printf("ConfigSource %s%n", config.getId());
                block3: for (StartIni ini : config.getStartInis()) {
                    for (String line : ini.getAllLines()) {
                        Matcher m = Module.SET_PROPERTY.matcher(line);
                        if (!m.matches() || m.groupCount() != 3) continue;
                        String name = m.group(2);
                        String value = m.group(3);
                        Props.Prop p = args.getProperties().getProp(name);
                        if (p == null || !"#".equals(m.group(1)) && value.equals(p.value)) continue;
                        ini.update(this.baseHome, args.getProperties());
                        continue block3;
                    }
                }
            }
        }
        if ((baseBuilder = new BaseBuilder(this.baseHome, args)).build()) {
            StartLog.info("Base directory was modified", new Object[0]);
        } else if (args.isCreateFiles() || !args.getStartModules().isEmpty()) {
            StartLog.info("Base directory was not modified", new Object[0]);
        }
        args.getAllModules().checkEnabledModules();
        if (!args.isRun()) {
            return;
        }
        if (args.isExec()) {
            CommandLineBuilder cmd = args.getMainArgs(true);
            cmd.debug();
            ProcessBuilder pbuilder = new ProcessBuilder(cmd.getArgs());
            StartLog.endStartLog();
            final Process process = pbuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StartLog.debug("Destroying " + process, new Object[0]);
                    process.destroy();
                }
            });
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            System.exit(0);
            return;
        }
        if (args.hasJvmArgs() || args.hasSystemProperties()) {
            StartLog.warn("System properties and/or JVM args set.  Consider using --dry-run or --exec", new Object[0]);
        }
        ClassLoader cl = classpath.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.invokeMain(cl, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Main.usageExit(e, -2, args.isTestingModeEnabled());
        }
    }

    private void doStop(StartArgs args) {
        Props.Prop stopHostProp = args.getProperties().getProp("STOP.HOST", true);
        Props.Prop stopPortProp = args.getProperties().getProp("STOP.PORT", true);
        Props.Prop stopKeyProp = args.getProperties().getProp("STOP.KEY", true);
        Props.Prop stopWaitProp = args.getProperties().getProp("STOP.WAIT", true);
        String stopHost = "127.0.0.1";
        int stopPort = -1;
        String stopKey = "";
        if (stopHostProp != null) {
            stopHost = stopHostProp.value;
        }
        if (stopPortProp != null) {
            stopPort = Integer.parseInt(stopPortProp.value);
        }
        if (stopKeyProp != null) {
            stopKey = stopKeyProp.value;
        }
        if (stopWaitProp != null) {
            int stopWait = Integer.parseInt(stopWaitProp.value);
            this.stop(stopHost, stopPort, stopKey, stopWait);
        } else {
            this.stop(stopHost, stopPort, stopKey);
        }
    }

    public void stop(String host, int port, String key) {
        this.stop(host, port, key, 0);
    }

    public void stop(String host, int port, String key, int timeout) {
        if (host == null || host.length() == 0) {
            host = "127.0.0.1";
        }
        try {
            if (port <= 0 || port > 65535) {
                System.err.println("STOP.PORT property must be specified with a valid port number");
                Main.usageExit(-7);
            }
            if (key == null) {
                key = "";
                System.err.println("STOP.KEY property must be specified");
                System.err.println("Using empty key");
            }
            try (Socket s = new Socket(InetAddress.getByName(host), port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        StartLog.info("Waiting %,d seconds for jetty to stop%n", timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            StartLog.debug("Received \"%s\"", response);
                            if (!"Stopped".equals(response)) continue;
                            StartLog.warn("Server reports itself as Stopped", new Object[0]);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            StartLog.warn("Timed out waiting for stop confirmation", new Object[0]);
            System.exit(-9);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4, this.jsvcStartArgs.isTestingModeEnabled());
        }
        catch (Exception e) {
            Main.usageExit(e, -9, this.jsvcStartArgs.isTestingModeEnabled());
        }
    }

    public void usage(boolean exit) {
        StartLog.endStartLog();
        if (!Main.printTextResource("org/eclipse/jetty/start/usage.txt")) {
            StartLog.warn("detailed usage resource unavailable", new Object[0]);
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static boolean printTextResource(String resourceName) {
        boolean resourcePrinted;
        block40: {
            resourcePrinted = false;
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
                if (stream != null) {
                    try (InputStreamReader reader = new InputStreamReader(stream);
                         BufferedReader buf = new BufferedReader(reader);){
                        String line;
                        resourcePrinted = true;
                        while ((line = buf.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block40;
                    }
                }
                StartLog.warn("Unable to find resource: " + resourceName, new Object[0]);
            }
            catch (IOException e) {
                StartLog.warn(e);
            }
        }
        return resourcePrinted;
    }

    public void init(String[] args) throws Exception {
        try {
            this.jsvcStartArgs = this.processCommandLine(args);
        }
        catch (UsageException e) {
            StartLog.error(e.getMessage(), new Object[0]);
            Main.usageExit(e.getCause(), e.getExitCode(), false);
        }
        catch (Throwable e) {
            Main.usageExit(e, -9, false);
        }
    }

    public void start() throws Exception {
        this.start(this.jsvcStartArgs);
    }

    public void stop() throws Exception {
        this.doStop(this.jsvcStartArgs);
    }

    public void destroy() {
    }
}

