/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.memcached.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataMap;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class MemcachedSessionDataMap
extends AbstractLifeCycle
implements SessionDataMap {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "11211";
    protected MemcachedClient _client;
    protected int _expirySec = 0;
    protected boolean _heartbeats = true;
    protected XMemcachedClientBuilder _builder;

    public MemcachedSessionDataMap(String host, String port) {
        if (host == null || port == null) {
            throw new IllegalArgumentException("Host: " + host + " port: " + port);
        }
        this._builder = new XMemcachedClientBuilder(host + ":" + port);
    }

    public MemcachedSessionDataMap(List<InetSocketAddress> addresses) {
        this._builder = new XMemcachedClientBuilder(addresses);
    }

    public MemcachedSessionDataMap(List<InetSocketAddress> addresses, int[] weights) {
        this._builder = new XMemcachedClientBuilder(addresses, weights);
    }

    public XMemcachedClientBuilder getBuilder() {
        return this._builder;
    }

    public void setExpirySec(int sec) {
        this._expirySec = sec;
    }

    public boolean isHeartbeats() {
        return this._heartbeats;
    }

    public void setHeartbeats(boolean heartbeats) {
        this._heartbeats = heartbeats;
    }

    public void initialize(SessionContext context) {
        try {
            this._client = this._builder.build();
            this._client.setEnableHeartBeat(this.isHeartbeats());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SessionData load(String id) throws Exception {
        SessionData data = (SessionData)this._client.get(id);
        return data;
    }

    public void store(String id, SessionData data) throws Exception {
        this._client.set(id, this._expirySec, (Object)data);
    }

    public boolean delete(String id) throws Exception {
        this._client.delete(id);
        return true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._client != null) {
            this._client.shutdown();
            this._client = null;
        }
    }
}

