#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'remastering/remastertool_utility'

require "gettext"
require 'gconf2'

require 'pluginhtmlGlade'

class  Html < PluginhtmlGlade
  include GetText

  attr :glade
  
	PROG_PATH = "pluginhtml.glade"
	PROG_NAME = "remastertool_plugin_html"

	DISPLAY_NAME	= "HTML"		# display name
	VERSION			= "V1.0"		# plugin version 

	# Gconf アクセスキー
	CONF_KEY_TAG1 = "/apps/remasteringtool/plugin/html/tag1"
	CONF_KEY_TAG2 = "/apps/remasteringtool/plugin/html/tag2"
	CONF_KEY_TAG3 = "/apps/remasteringtool/plugin/html/tag3"
	CONF_KEY_OPTION = "/apps/remasteringtool/plugin/html/option"

	# HTML constant
	HEADER_TOP = "<html><head>\n<title>%s</title>\n" + 
				 "<meta content='text/html; charset=UTF-8' http-equiv='Content-Type'/>\n"
	HEADER_BUTTOM = "\n</head>\n"
	BODY_TOP = "<body>\n"
	BODY_BOTTOM = "</body>\n</html>\n"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	HTML_TITLE = _("Remastering procedure")
	MSG_ERR_SAVE_PROC = _("Error occured while storing the remastering procedure file.\n\n%s")
	MSG_WAR_OPTION_OK = _("Please set all the tag of a large item, an middle item, and a small item.")

	# ファイルタイプ情報
	TYPE_DESC = _("HTML file")
	EXT = "html"

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)	
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = true			# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE

		@tool_min_vl = "V1.0"
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return false if tool_version < @tool_min_vl

		read_option		# read option setting
		true
	end

	#=== オプションダイアログの表示
	#
	#HTMLプラグインのオプションダイアログを表示する。
	#
	#復帰値:: なし
	#
	def show_option
		@glade["dialog_option"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_option"].show
	end

	#===リマスタリング手順ファイルの保存
	#
	#パラメタで指定されたXMLドキュメントをファイルに保存する
	#
	#fname:: 保存先リマスタリング手順ファイル
	#doc:: リマスタリング手順XMLドキュメント
	#復帰値:: BOOL  true=保存成功, false=保存失敗
	#
	def write_procedure(fname, doc)
		contents = sprintf(HEADER_TOP, HTML_TITLE, doc.xml_decl.encoding)
		contents << @glade["textview_style"].buffer.text unless @glade["textview_style"].buffer.text.empty?
		contents << BODY_TOP + BODY_TOP

		doc.root.elements.each {|elm|
			contents << parse_element(elm, 0) + "\n"
		}

		contents << BODY_BOTTOM

		begin
			RTUtility.write_file(fname, contents)
			true
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow,
					Gtk::Dialog::MODAL, Gtk::MessageDialog::ERROR,
					Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_SAVE_PROC, $!.to_s))
			dlg.run
			dlg.destroy
			false
		end
	end

	#===保存ファイルの形式取得
	#
	#プラグインで保存するファイル形式の情報を返却する
	#
	#復帰値:: Array [説明, 拡張子]
	#
	def get_file_type()
		[TYPE_DESC, EXT]
	end

private

	#===リマスタリング手順の解析
	#
	#指定さらたXML要素を解析して、指定要素に対応するHTMLドキュメントを作成する。
	#
	#elm:: リマスタリング手順XMLドキュメントの解析対象エレメント
	#generation:: XML要素の階層
	#復帰値:: 指定要素に対応するHTMLドキュメント
	#
	def parse_element(elm, generation)
		tag = ""
		tag_begin = ""
		tag_end = ""
		case generation
		when 0: tag = @glade["entry_large"].text
		when 1: tag = @glade["entry_middle"].text
		when 2: tag = @glade["entry_small"].text
		else tag_end = "\n"
		end
		unless tag.empty?
			tag_begin = "<" + tag + ">";  tag_end = "</" + tag + ">\n"
		end
		contents = tag_begin + elm.name
		contents << ":" + elm.text if elm.has_text?
		elm.attributes.each {|name, value| contents << " " + name + "=" + value + "\n" }
	 	contents << tag_end
		elm.elements.each {|child|
			contents << parse_element(child, generation + 1) + "\n"
		}
		return contents
	end


	########################################
	# Option dialog
	########################################

	#===オプション設定の読み込み
	#
	#gconfを通してプラグインのオプション設定を読み込む。
	#
	#復帰値:: なし
	#
	def read_option
		gconf = GConf::Client.default

		# 大項目タグ
		@glade["entry_large"].text = gconf[CONF_KEY_TAG1] ? gconf[CONF_KEY_TAG1] : "H1"

		# 中項目タグ
		@glade["entry_middle"].text = gconf[CONF_KEY_TAG2] ? gconf[CONF_KEY_TAG2] : "H2"

		# 小項目タグ
		@glade["entry_small"].text = gconf[CONF_KEY_TAG3] ? gconf[CONF_KEY_TAG3] : "H3"

		# ヘッダ部追加文字列
		@glade["textview_style"].buffer.text = gconf[CONF_KEY_OPTION] ? gconf[CONF_KEY_OPTION] : ""
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にキャンセルボタンのハンドラを呼び出し、キャンセルボタンと同じ動作を実現する。
	#
	#widget:: オプションダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_option_delete_event(widget, arg0)
		on_cancelbutton_clicked @glade["cancelbutton"]
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にオプションダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_cancelbutton_clicked(widget)
		@glade["dialog_option"].hide
		read_option
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時にダイアログの設定値をgconfを使用して保存する。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_okbutton_clicked(widget)
		# 大項目、中項目、小項目の入力チェック
		if @glade["entry_large"].text.strip.empty? || @glade["entry_middle"].text.strip.empty? ||
		   @glade["entry_small"].text.strip.empty?
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow,
					Gtk::Dialog::MODAL, Gtk::MessageDialog::WARNING,
					Gtk::MessageDialog::BUTTONS_OK, MSG_WAR_OPTION_OK)
			dlg.run
			dlg.destroy
			return
		end

		gconf = GConf::Client.default

		# 大項目タグ
		gconf[CONF_KEY_TAG1] = @glade["entry_large"].text.strip

		# 中項目タグ
		gconf[CONF_KEY_TAG2] = @glade["entry_middle"].text.strip

		# 小中項目タグ
		gconf[CONF_KEY_TAG3] = @glade["entry_small"].text.strip

		# その他のヘッダ追記情報
		gconf[CONF_KEY_OPTION] = @glade["textview_style"].buffer.text

		# ダイアログを閉じる
		@glade["dialog_option"].hide
	end
end
