#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/remastertool_utility'
require 'pluginqemuGlade'

require 'gettext'
require 'gconf2'


class Qemu < PluginqemuGlade

  include GetText

  attr :glade
  
	PROG_PATH = "pluginqemu.glade"
	PROG_NAME = "remastertool_plugin_qemu"

	DISPLAY_NAME	= "QEMU"		# display name
	VERSION			= "V1.0"		# plugin version 

	KEYLAYOUTS = [  "ar", "da", "de", "de-ch", "en-gb", "en-us", "es", "et", "fi", "fo",
				    "fr", "fr-be", "fr-ca", "fr-ch", "hr", "hu", "is", "it", "ja", "lt",
				    "lv", "mk", "nl", "nl-be", "no", "pl", "pt", "pt-br", "ru", "sl",
					"sv", "th", "tr" ]
	DEFAULT_KEY = "ja"
	DEFAULT_MEM = 256

	# Gconf アクセスキー
	CONF_KEY_CMD = "/apps/remasteringtool/plugin/qemu/command"
	CONF_KEY_MEM = "/apps/remasteringtool/plugin/qemu/memory"
	CONF_KEY_LAYOUT = "/apps/remasteringtool/plugin/qemu/keylayout"
	CONF_KEY_OPTION = "/apps/remasteringtool/plugin/qemu/option"

	# qemuコマンドのパス取得コマンド
	CMD_WHICH_QEMU = "which qemu"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	TITLE_SELECT_CMD = _("Choose qemu command")

	MSG_WARN_NO_CMD = _("Please specify the command.")

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)	
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = true			# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE
		@tool_min_vl = "V1.0"

		initialize_option_dialog	# initialize option dialog

		read_option					# read option setting
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== オプションダイアログの表示
	#
	#QEMUプラグインのオプションダイアログを表示する。
	#
	#復帰値:: なし
	#
	def show_option
		@glade["dialog_option"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_option"].show
	end

	#=== 仮想マシンの実行
	#
	#指定のisoイメージで仮想マシンを実行する。
	#
	#media_image:: 仮想マシン上で実行するOSのisoイメージ
	#use_net:: ネットワーク使用の有無
	#boot_cmd:: カーネル引数
	#復帰値:: なし
	#
	def run(media_image, use_net = false, boot_cmd = "")
		# コマンドライン文字列の作成
		cmd = get_cmd(media_image, use_net, boot_cmd)
		inputAry = nil
		if boot_cmd.length > 0
			inputAry = Array.new
			boot_cmd.split(//).each{|x|
				case x
					when " " : x = "spc"
					when "-" : x = "minus"
					when "+" : x = "plus"
					when "=" : x = "equal"
				end
 				inputAry.push("sendkey " + x)
			}
			inputAry.push("sendkey ret")
		end
		RTUtility.exec_workOS_command(cmd, nil, nil, inputAry)
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成前に設定内容に誤りがないか確認を行う。
	#QEMUプラグインではチェック項目がないので常にtrueで復帰する。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		true
	end

private

	#=== 仮想マシンの起動時のコマンドライン文字列の作成
	#
	#指定のisoイメージでqemuを起動するためのコマンドライン文字列を作成する。
	#
	#media_image:: 仮想マシン上で実行するOSのisoイメージ
	#use_net:: ネットワーク使用の有無
	#boot_cmd:: カーネルパラメタ
	#復帰値:: なし
	#
	def get_cmd(media_image, use_net, boot_cmd)
		cmd = @glade["entry_cmd"].text + " -no-kqemu -boot d -cdrom " + media_image \
			+ " -m " + @glade["spinbutton_memory"].value.to_i.to_s \
			+ " -k " + @glade["combobox_keyboard"].active_text \
			+ " " + @glade["entry_other"].text
		cmd << " -monitor stdio" unless boot_cmd.empty?
		cmd << " -net nic,model=ne2k_pci -net user" if use_net
		cmd
	end

	########################################
	# option dialog
	########################################

	#===オプション設定の読み込み
	#
	#gconfを通してプラグインのオプション設定を読み込む。
	#
	#復帰値:: なし
	#
	def read_option
		gconf = GConf::Client.default

		# QEMUコマンド名
		if gconf[CONF_KEY_CMD] == nil
			# 設定を取得できない場合は which qemu の結果を設定
			outAry = Array.new
			status = RTUtility.exec_workOS_command(CMD_WHICH_QEMU, outAry,nil,nil,nil,"",false)
			@glade["entry_cmd"].text = status == 0 ? outAry[0] : "qemu"
		else
			@glade["entry_cmd"].text = gconf[CONF_KEY_CMD]
		end

		# 仮想マシンメモリサイズ
		if gconf[CONF_KEY_MEM] == nil
			# 設定を取得できない場合はデフォルトのメモリサイズ(128M)を設定
			@glade["spinbutton_memory"].value = DEFAULT_MEM
		else
			@glade["spinbutton_memory"].value = gconf[CONF_KEY_MEM]
		end

		# キーボードレイアウト
		if gconf[CONF_KEY_LAYOUT] == nil
			# 設定を取得できない場合はデフォルトのレイアウト(jaキーボード)を設定
			key_layout = DEFAULT_KEY
		else
			key_layout = gconf[CONF_KEY_LAYOUT]
		end

		@glade["combobox_keyboard"].model.each { |model,path,iter|
			if iter[0].casecmp(key_layout) == 0
				@glade["combobox_keyboard"].active_iter = iter
				break
			end
		}

		# QEMUその他のオプション
		@glade["entry_other"].text = gconf[CONF_KEY_OPTION] ? gconf[CONF_KEY_OPTION] : ""
	end

	#===オプションダイアログの初期設定
	#
	#オプションダイアログ中の部品を作成する。
	#
	#復帰値:: なし
	#
	def initialize_option_dialog
		# スピンボタンの設定
		@glade["spinbutton_memory"].set_range(1, 99999999)

		# keyboardレイアウトコンボボックスの設定
		KEYLAYOUTS.each { |val| @glade["combobox_keyboard"].append_text(val) }
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時に[閉じる]ボタンのハンドラを呼び出し、[閉じる]ボタンと同じ動作を実現する。
	#
	#widget:: オプションダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_detail_delete_event(widget, arg0)
		on_button_option_cancel_clicked @glade["button_detail_close"]
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にオプションダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_button_option_cancel_clicked(widget)
		read_option		# オプション情報を取得しなおす
		@glade["dialog_option"].hide
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時にダイアログの設定値をgconfを使用して保存する。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_button_option_ok_clicked(widget)
		# 入力チェック
		begin
			raise MSG_WARN_NO_CMD if @glade["entry_cmd"].text.strip.empty?
		rescue
			dlg = Gtk::MessageDialog.new(@glade["dialog_option"], Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK,
					$!.to_s)
			dlg.run
			dlg.destroy
			return
		end

		gconf = GConf::Client.default

		# QEMUコマンド名
		gconf[CONF_KEY_CMD] = @glade["entry_cmd"].text

		# 仮想マシンメモリサイズ
		gconf[CONF_KEY_MEM] = @glade["spinbutton_memory"].value

		# キーボードレイアウト
		gconf[CONF_KEY_LAYOUT] = @glade["combobox_keyboard"].active_text

		# QEMUその他のオプション
		gconf[CONF_KEY_OPTION] = @glade["entry_other"].text

		# ダイアログを閉じる
		@glade["dialog_option"].hide
	end

	#=== [開く]ボタンクリック持のイベントハンドラ
	#
	#[開く]ボタンクリック時にファイル選択ダイアログを開き、指定されたファイル名
	#を[コマンド]エントリに設定する。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_cmd_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_SELECT_CMD,
												@glade["dialog_option"],
												Gtk::FileChooser::ACTION_OPEN,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		@glade["entry_cmd"].text = chooser.filename if chooser.run == Gtk::Dialog::RESPONSE_OK
		chooser.destroy
	end

end
