require "remastering/remastertool_const"
require "remastering/pluginBase"

class PluginBaseEmulator < PluginBase

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		super
	end

	#=== プラグイン形式の取得
	#
	#プラグインの形式を返却する。エミュレータプラグインでは"EMULATOR"を返却する。
	#
	#復帰値:: プラグインタイプ("EMULATOR")
	#
	def get_plugin_type
		PLUGIN_TYPE_EMULATOR
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成時にメディアを作成する前に呼び出され、設定内容に誤りがないか確認を行う。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		true
	end

	#=== 仮想マシンの実行
	#
	#指定のisoイメージで仮想マシンを実行する。
	#
	#media_image:: 仮想マシン上で実行するOSのisoイメージ
	#use_net:: ネットワーク使用の有無
	#boot_cmd:: カーネル引数
	#復帰値:: なし
	#
	def run(media_image, use_net = false, boot_cmd = "")
	end
end