#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_distributionGlade'
require 'remastering/remastertool_module'
require 'remastering/remastertool_utility'

class RemastertoolDistribution < RemastertoolDistributionGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	PROG_PATH = "remastertool_distribution.glade"
	FUNC_NAME = _("Make distribution")
	FUNC_CREATE_OS = _("create OS image")
	FUNC_PROFILE_OS = _("profiling OS image")
	FUNC_CREATE_MEDIA = _("create remastering media")

	MSG_INFO_COMPLETE = _("remastering is finished")

	# ディストリビューション作成ペインの XML要素
	XML_ROOT = ["DistInfo", _("Distribution_Information")]
	XML_IMAGE = ["Image", _("Image")]
	XML_IMAGE_XPATH = XML_ROOT[0] + "/" + XML_IMAGE[0]
	XML_MEDIA = ["Media", _("Media")]
	XML_MEDIA_XPATH = XML_ROOT[0] + "/" + XML_MEDIA[0]
	XML_ACCEL = ["Accel", _("Bootup_Acceleration")]
	XML_ACCEL_XPATH = XML_ROOT[0] + "/" + XML_ACCEL[0]
	XML_EMULATOR = ["Emulator", _("Emulation_software")]
	XML_EMULATOR_XPATH = XML_ROOT[0] + "/" + XML_EMULATOR[0]
	XML_DO_ACCEL = [_("apply"), _("not_apply") ]
	XML_ATTR_EXEC = ["exec", _("execution")]
	XML_DO_EXECUTED = [_("done"), _("not done")]

	#=== ディストリビューション作成画面の初期化処理
	#
	#ディストリビューション作成画面を初期化する。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルドメイン名
	#file_pane_obj:: ファイル画面のインスタンス
	#packgae_pane_obj:: パッケージ追加/削除画面のインスタンス
	#復帰値:: なし
	#
	def initialize(gladeDir, domain, file_pane_obj, package_pane_obj, fixed_pane_obj)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
		@mediapluginWidgets = Array.new
		@file_pane_obj = file_pane_obj
		@package_pane_obj = package_pane_obj
		@fixed_pane_obj = fixed_pane_obj
	
		# メディアコンボボックスの設定とプラグイン固有域の表示
		create_mediaCombo

		# 起動高速化部の初期設定
		create_emuCombo

		# 環境の初期化
		init_environ
	end


	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素を取り出し、対応する部品に設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# OSイメージの作成
		elm = root.get_elements(XML_IMAGE_XPATH)[0]
		@create_os_image = (elm != nil and elm.attributes[XML_ATTR_EXEC[0]] and elm.attributes[XML_ATTR_EXEC[0]].casecmp(true.to_s) == 0)

		# 出力先メディア
		elm = root.get_elements(XML_MEDIA_XPATH)[0]
		set_combo(@glade["combobox_media"], elm)
		@create_os_media = (elm != nil and elm.attributes[XML_ATTR_EXEC[0]] != nil and elm.attributes[XML_ATTR_EXEC[0]].casecmp(true.to_s) == 0)

		# 起動高速化ラジオボタン
		elm = root.get_elements(XML_ACCEL_XPATH)[0]
		if (elm and elm.text.casecmp(true.to_s) == 0)
			@glade["radiobutton_disable"].active = false
			@glade["radiobutton_enable"].active = true
		else
			@glade["radiobutton_disable"].active = true
			@glade["radiobutton_enable"].active = false
		end
		@profile_os_image = (elm != nil and elm.attributes[XML_ATTR_EXEC[0]] != nil and elm.attributes[XML_ATTR_EXEC[0]].casecmp(true.to_s) == 0)

		# エミュレータソフト
		elm = root.get_elements(XML_EMULATOR_XPATH)[0]
		set_combo(@glade["combobox_emu"], elm)

		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(ディストリビューション作成部)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])

		# OSイメージの作成
		elm = REXML::Element.new(XML_IMAGE[localize])
		if localize == 0
			elm.add_attribute(XML_ATTR_EXEC[localize], @create_os_image)
		else
			elm.add_attribute(XML_ATTR_EXEC[localize], @create_os_image ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
		end
		elmRoot.add_element elm

		# 出力先メディア
		elm = REXML::Element.new(XML_MEDIA[localize])
		elm.text = @glade["combobox_media"].active_text
		if localize == 0
			elm.add_attribute(XML_ATTR_EXEC[localize], @create_os_media)
		else
			elm.add_attribute(XML_ATTR_EXEC[localize], @create_os_media ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
		end
		elmRoot.add_element elm

		# 起動高速化ラジオボタン
		elm = REXML::Element.new(XML_ACCEL[localize])
		if localize == 0
			elm.text = @glade["radiobutton_enable"].active?.to_s
			elm.add_attribute(XML_ATTR_EXEC[localize], @profile_os_image)
		else
			elm.text = @glade["radiobutton_enable"].active? ? XML_DO_ACCEL[0] : XML_DO_ACCEL[1]
			elm.add_attribute(XML_ATTR_EXEC[localize], @profile_os_image ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
		end
		elmRoot.add_element elm

		# エミュレータソフト
		elm = REXML::Element.new(XML_EMULATOR[localize])
		elm.text = @glade["combobox_emu"].active_text
		elmRoot.add_element elm

		elmRoot
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		return @glade["combobox_media"].active != @active_media || \
				@glade["radiobutton_enable"].active? != @radio_accel || \
				@glade["combobox_emu"].active != @active_emu || \
				@init_create_os_image != @create_os_image || \
				@init_profile_os_image != @profile_os_image || \
				@init_create_os_media != @create_os_media
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@active_media = @glade["combobox_media"].active
		@radio_accel = @glade["radiobutton_enable"].active?
		@active_emu = @glade["combobox_emu"].active
		@init_create_os_image = @create_os_image
		@init_profile_os_image = @profile_os_image
		@init_create_os_media = @create_os_media
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		# 出力先メディア
		@glade["combobox_media"].active = 0
		@active_media = 0

		# 起動高速化ラジオボタン
		@glade["radiobutton_enable"].active = true
		@radio_accel = true

		# エミュレータソフト
		@glade["combobox_emu"].active = 0
		@active_emu = 0

		@init_create_os_image = FALSE
		@create_os_image = FALSE
		@init_profile_os_image = FALSE
		@profile_os_image = FALSE
		@init_create_os_media = FALSE
		@create_os_media = FALSE
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		ary = Array.new
		ary.push( [ @create_os_image, FUNC_NAME, FUNC_CREATE_OS, "" ] )
		ary.push( [ @profile_os_image, FUNC_NAME, FUNC_PROFILE_OS, "" ] )
		ary.push( [ @create_os_media, FUNC_NAME, FUNC_CREATE_MEDIA, "" ] )
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#返却した手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		@create_os_image = list[0][0]
		@profile_os_image = list[1][0]
		@create_os_media = list[2][0]
	end

	#===エミュレータプラグインの取得
	#
	#選択しているエミュレータプラグイン名を取得する。
	#
	#復帰値:: [エミュレータ]コンボボックスで選択しているプラグイン名
	#
	def get_emulator
		@glade["combobox_emu"].active_text
	end

	#===メディアプラグインの取得
	#
	#選択しているメディアプラグイン名を取得する。
	#
	#復帰値:: [出力メディア]コンボボックスで選択しているプラグイン名
	#
	def get_media
		@glade["combobox_media"].active_text
	end

	#=== OSイメージの再作成が必要であることを通知
	#
	#ファイル操作、パッケージのインストール／アンインストールによりOSイメージ
	#の再作成が必要であることを通知する。
	#この呼び出しにより、ディストリビューション作成画面の「OSイメージの作成」、「プロファイリング」、
	#「メディアの作成」の各手順が身実行状態になる。
	#
	#復帰値:: なし
	#
	def need_osimage_remake
		@create_os_image = false
		@profile_os_image = false
		@create_os_media = false
	end

private


	#=== [メディア]コンボボックスの内容設定
	#
	#[メディア]コンボボックスにエクスポートプラグイン名の一覧を設定する。
	#
	#復帰値:: なし
	#
	def create_mediaCombo
		RTUtility.get_media_plugins.each { |key, value|
			widget = value.get_makeDist_widget
			@mediapluginWidgets.push widget
			@glade["combobox_media"].append_text(key)
			widget.reparent @glade["vbox_media_plugin"]
		}
	end

	#=== [エミュレータ]コンボボックスの内容設定
	#
	#[エミュレータ]コンボボックスにエクスポートプラグイン名の一覧を設定する。
	#
	#復帰値:: なし
	#
	def create_emuCombo
		RTUtility.get_emulator_plugins.each_key { |key| @glade["combobox_emu"].append_text(key) }
	end

	#=== map event handler for distribution making screen
	#
	#set radio button when distrubution makeing screen is mapped.
	#
	#widget:: distrubution makeing screen widget
	#return:: none
	#
	def on_mainBox_map(widget)
		on_combobox_media_changed(@glade["combobox_media"])
	end

	#=== [メディア]コンボボックス選択変更時のイベントハンドラ
	#
	#メディア種別変更時にメディアプラグインの表示しているメディア情報を切替える。
	#
	#widget:: [メディア]コンボボックスのWidget
	#復帰値:: なし
	#
	def on_combobox_media_changed(widget)
		@mediapluginWidgets.each { | wid | wid.hide }
		@mediapluginWidgets[widget.active].show

		# 起動高速化適用の有無をチェックし、適用可ならアクティブ状態、不可ならインアクティブ状態に関連部品を設定する
		sensitive = RTUtility.get_media_plugins[widget.active_text].can_accelerate?
		if sensitive && RTUtility.get_os_plugin
			sensitive = RTUtility.get_os_plugin.can_accelerate?
		end
		@glade["hbox_radio"].sensitive = sensitive
		@glade["combobox_emu"].sensitive = @glade["radiobutton_enable"].active? && sensitive
	end

	#=== [開始]ボタンクリック時のイベントハンドラ
	#
	#[開始]ボタンクリック時にリマスタリング対象OSを作成する
	#
	#widget:: [開始]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_start_clicked(widget)
		media_plugin = RTUtility.get_media_plugins[@glade["combobox_media"].active_text]
		os_plugin    = RTUtility.get_os_plugin
		emu_plugin   = RTUtility.get_emulator_plugins[@glade["combobox_emu"].active_text]

		# 入力チェック
		return unless @package_pane_obj.check_for_make_distribution
		return unless @file_pane_obj.check_for_make_distribution
		return unless @fixed_pane_obj.check_for_make_distribution
		return unless os_plugin.check_for_make_distribution
		return unless media_plugin.check_for_make_distribution
		return unless emu_plugin.check_for_make_distribution

		# 定型処理（パッケージインストール前）
		return unless @fixed_pane_obj.do_fixed_procedure(IDX_FIXED_BEFORE_PACKAGE)

		# パッケージのインストール/アンインストール
		return unless @package_pane_obj.install_package

		# 定型処理（ファイル操作前）
		return unless @fixed_pane_obj.do_fixed_procedure(IDX_FIXED_BEFORE_FILE)

		# ファイルの追加/削除/入れ替え
		return unless @file_pane_obj.install_file

		# 定型処理（OSイメージ作成前）
		return unless @fixed_pane_obj.do_fixed_procedure(IDX_FIXED_BEFORE_CREATEOS)

		# OSイメージの作成
		unless @create_os_image
			return unless os_plugin.create_os
			@create_os_image = true
		end

		if @profile_os_image == FALSE && @glade["radiobutton_enable"].active? && @glade["hbox_radio"].sensitive?

			# 起動高速化のためにプロファイリングの準備を行う
			return unless os_plugin.prepare_profile

			# メディアの作成
			return unless media_plugin.create_media_image(os_plugin.get_media_dir)

			# 作成したメディアを起動し、プロファイリングする
			return unless os_plugin.do_profile(media_plugin.get_output_image, emu_plugin)

			@profile_os_image = true
		end

		# 定型処理（OSイメージ作成後）
		return unless @fixed_pane_obj.do_fixed_procedure(IDX_FIXED_AFTER_CREATEOS)

		# メディアの作成
		unless @create_os_media
			return unless media_plugin.create_media_image(os_plugin.get_media_dir)
			@create_os_media = true
		end

		# 完了メッセージを出力する
		RTUtility.get_logger.info("distribution:on_button_start_clicked " + MSG_INFO_COMPLETE)
		dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
				Gtk::MessageDialog::INFO,
				Gtk::MessageDialog::BUTTONS_OK, MSG_INFO_COMPLETE)
		dlg.run
		dlg.destroy
	end

	#=== [有効]/[無効]ラジオボタンクリック時のイベントハンドラ
	#
	#[有効]クリック時は[エミュレータ]コンボボックスを有効にし、[無効]クリック時は無効状態に設定する
	#
	#widget:: [有効]/[無効]ラジオボタンのWidget
	#復帰値:: なし
	#
	def on_radiobutton_clicked(widget)
		@glade["combobox_emu"].sensitive = @glade["radiobutton_enable"].active?
	end

	#=== コンボボックスの選択項目の設定
	#
	#パラメタで指定されたコンボボックスをパラメタで指定した文字列が選択状態になるように設定する
	#
	#combo:: 選択状態を設定するコンボボックス
	#elm:: 選択状態を設定するテキストが設定されているXMLエレメント
	#復帰値:: なし
	#
	def set_combo(combo, elm)
		if elm
			combo.model.each do |model,path,iter|
				if elm.text && iter[0].casecmp(elm.text) == 0
					combo.active_iter = iter
					break
				end
			end
		else
			combo.active = 0
		end
	end

end
