#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'fileutils'
require 'pathname'
require 'gconf2'
require 'find'

require 'remastering/remastertool_utility'

require 'plugindebGlade'

class Deb < PlugindebGlade
  include GetText

  attr :glade

	PROG_NAME = "remastertool_plugin_deb"
	PROG_PATH = "plugindeb.glade"

	CMD_INSTALLED = "dpkg-query -W -f='${Package}__DELIM__${Version}__DELIM__${Installed-Size}__DELIM__${Description}\\n' | grep -v -E '^ '"
	CMD_INSTALLABLE = "apt-cache dumpavail | egrep -E '^Package:|^Version:|^Description'"
	CMD_INSTALLABLE_LOCAL = "dpkg-deb -W --showformat='${Package}__DELIM__${Version}__DELIM__${Description}\\n' %s | grep -v -E '^ '"
	CMD_UPDATE = "apt-get update"
	#依存パッケージ一覧の取得
	CMD_GET_DPENDS = "apt-get -s -q=2 --force-yes %s %s | grep -e '^Inst ' -e '^Remv'"
	CMD_RET_INST = "Inst"
	CMD_RET_REMV = "Remv"
	CMD_GET_PKGS = "apt-get -d -y -q=1 --force-yes --reinstall install %s"

	# パッケージのインストール/アンインストール
	CMD_INSTALL_PKGS = "apt-get --force-yes -q=2 %s %s"
#	CMD_INSTALL_PKGS_MK = "dpkg -i %s"

	# パッケージの作成
	CMD_MK_TEMPLETE = "(cd %s; echo \"\" | dh_make -n -s -e \"%s\")"
	CMD_MK_PKG = "(cd %s; dpkg-buildpackage -b -rfakeroot)"

	# パッケージの展開
	CMD_EXTRACT_PKG = "dpkg -x %s %s"
	CMD_EXTRACT_CTL = "dpkg -e %s %s"

	# パッケージ情報の追加
	CMD_APTARCH = "(mkdir -p %s; cd %s ; apt-ftparchive packages . | gzip -c9 > Packages.gz)"

	# パッケージファイルの削除
	CMD_CLEAN = "apt-get clean; rm -f %s/*.deb"

	DISPLAY_NAME	= "Deb"			# display name
	VERSION			= "V1.0"		# plugin version 

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	TITLE_COPYRIGHT = _("Choose copyright templete")
	TITLE_LOG =		  _("Choose change log templete")
	TITLE_README =	  _("Choose README.Debian")
	TITLE_SEL_PKGDIR = _("Choose package search directory")

	MSG_ERR_NO_PACKAGE = _("Cannot find package file.")
	MSG_ERR_EXTRACT_PACKAGE = _("Cannot ectract package file(%s).")
	MSG_ERR_DOWNLOAD_PACKAGE = _("Cannot download package file(%d).")
	MSG_ERR_CREATE_TEMPLETE = _("Cannot create package templete(%d).")
	MSG_WAIT_EXPORT = _("The resource used by the Deb plugin is exported.")
	MSG_WAIT_IMPORT = _("The resource used by the Deb plugin is imported.")
	MSG_ERR_EXPORT = _("Failed to export.\n%s")
	MSG_ERR_IMPORT = _("Failed to import.\n%s")
	MSG_QUE_PKG_UPDATE = _("It is necessary to update the package index to install\nthe made package.\nIs the package index right now updated?")
	MSG_QUE_SET_UPDATE = _("It is necessary to update the package index to reflect \nthe setting.\nIs the package index right now updated?")

	FILE_CONTROL = "control"
	FILE_CHANGE_LOG = "/usr/share/doc/%s/changelog.Debian.gz"
	FILE_CHANGE_LOG2 = "/usr/share/doc/%s/changelog.gz"
	FILE_COPYRIGHT = "/usr/share/doc/%s/copyright"
	FILE_README = "/usr/share/doc/%s/README.Debian"
	DIR_TEMPLETE_COPYRIGHT = "/usr/share/debhelper/dh_make/licenses"

	PKG_SECTIONS = ["main", "non-free", "contrib"]
	PKG_SUBSECTIONS = ["admin", "base", "comm", "debian-installer", "devel",
		"doc", "editors", "electronics", "embedded", "games", "gnome", "graphics",
		"hamradio", "interpreters", "kde","libdevel", "libs", "mail", "math",
		"misc", "net", "news", "oldlibs", "otherosfs", "perl", "python",
		"science", "shells", "sound", "tex", "text", "utils", "virtual", "web", "x11"]
	PKG_ARCHS = ["any", "all", "alpha", "amd64", "arm", "hurd-i386", "i386", "ia64",
		"m68k", "mips", "mipsel", "powerpc", "s390", "sparc"]
	PKG_PRIORITY = ["required", "important", "standard", "optional", "extra"]

	PKG_COMPARE = ["<<", "<=", "=", ">=", ">>"]
	PKG_RELATION = ["Depends", "Recommends", "Suggests", "Conflicts", "Replaces", "Provides", "Pre-Depends"]

	PKG_DEPLIST_HEADER = [_("Package"), _("Necessary version"), _("Relation")]
	PKG_SELDEPLIST_HEADER = [_("Package"), _("Description")]

	MSG_INF_PKG_INSTALLED = _("Now collecting installed packages.\nPlease wait for a while.")
	MSG_INF_PKG_INSTALLABLE = _("Now collecting installable packages.\nPlease wait for a while.")
	MSG_INF_PKG_UPDATE = _("Now updating package index.\nPlease wait for a while.")
	MSG_INF_PKG_EXTRACT = _("Now extracting specified package.\nPlease wait for a while.")
	MSG_INF_PKG_DELETE = _("Now deleting package files.\nPlease wait for a while.")
	MSG_WARN_OPT_NOINIT = _("Please execute the option setting after completing initial setting.")
	MSG_WARN_OPT_NOREPOS = _("Because the sources.list file doesn't exist, the acquisition place of the package cannot be edited.")
	MSG_INF_PKG_DOWNLOAD = _("Now downloading the %s package files.\nPlease wait for a while.")
	MSG_WARN_NO_NAME	= _("Please specify the package name.")
	MSG_WARN_NO_VERSION	= _("Please specify the package version.")
	MSG_WARN_NO_DESC	= _("Please specify the package description.")
	MSG_WARN_NO_SUBSECT	= _("Please specify the package sub section.")
	MSG_WARN_NO_ARCH	= _("Please specify the package architecture.")
	MSG_WARN_NO_MAINT	= _("Please specify the package mentainer.")
	MSG_WARN_NO_EMAIL	= _("Please specify the mentainer E-Mail address.")
	MSG_WARN_NO_CHANGELOG	= _("Please specify the change log.")
	MSG_WARN_NO_SELDEPPKG	= _("Please select the depend package.")
	MSG_WARN_NO_INPUTDEPPKG	= _("Please specify the depend package.")
	MSG_WARN_NO_LOCALPKGDIR	= _("Please specify the package search directory.")

	# Gconf アクセスキー
	CONF_KEY_SEARCHDIR = "/apps/remasteringtool/plugin/deb/seach_directory"
	DEFAULT_SEARCHDIR  = "/var/cache/remastering/archives/deb"

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)

		@my_dir = dir
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = true			# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE
		@initialize_deplistdlg = false
		@modified = false
		@tab_page = nil
		@tmp_dirs = Array.new
	
		@tool_min_vl = "V1.0"

		read_option					# read option information
		make_detail_dialog			# create detail dialog parts
		make_depend_dialog			# create depend dialog parts

		init_environ				# initialize environment
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== プラグインの終了処理
	#
	#プラグイン固有の終了処理を実装する。
	#
	#復帰値:: なし
	#
	def end_plugin
		@tmp_dirs.each{|dir|
			begin
				FileUtils.rm_rf(dir)
			rescue
			end
		}
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		#パッケージ作成画面部品
		@glade["entry_name"].text = ""
		@glade["entry_version"].text = ""
		@glade["textview_desc"].buffer.text = ""

		#パッケージ詳細情報ダイアログ部品
		@glade["combobox_section"].active = 0
		@glade["combobox_subsection"].active = 0
		@glade["combobox_arch"].active = 0
		@glade["combobox_priority"].active = 0
		@glade["entry_maintainer"].text = ""
		@glade["entry_email"].text = ""
		@glade["textview_copyright"].buffer.text = ""
		@glade["textview_log"].buffer.text = ""
		@glade["treeview_depend"].model.clear
		@glade["textview_readme"].buffer.text = ""

		@modified = false
		@pkg_make_name = ""
		@pkg_make_vl = ""
		@pkg_make_dir = ""
	end

	#=== インストール済みパッケージの一覧取得
	#
	#リマスタリング対象OS上にインストールされているパッケージの一覧を取得する。
	#
	#復帰値:: インストール済みパッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン, パッケージサイズ, パッケージ説明文]
	#
	def get_installed_packages
		ret_ary = Array.new
		out_ary = Array.new
		RTUtility.exec_remasterOS_command(CMD_INSTALLED, out_ary, nil, nil,
			RTUtility.mainWindow, MSG_INF_PKG_INSTALLED, false, false)

		# 取得したデータを返却用の形式に成形する。
		out_ary.each {|line| ret_ary.push line.split("__DELIM__") }
		ret_ary
	end

	#=== インストール可能パッケージの一覧取得
	#
	#リマスタリング対象OS上にインストール可能なパッケージの一覧を取得する。
	#
	#復帰値:: インストール可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_installable_packages
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_INSTALLABLE)
		ret_ary = get_packages(true)
		RTUtility.end_wait_window
		ret_ary
	end

	#=== パッケージインデックスの更新
	#
	#apt-get updateコマンドを発行し、パッケージインデックスを最新化する。
	#
	#復帰値:: なし
	#
	def update_package_index
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_UPDATE)
		# 作業用OS上のローカルパッケージ検索ディレクトリからリマスタリング対象OSのローカルパッケージ
		# 検索ディレクトリにパッケージファイルをコピーする
		FileUtils.mkdir_p(File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text))
		RTUtility.exec_workOS_command(
			"cp -r #{@glade["entry_pkgdir"].text}/*.deb #{File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text)}")

		# sources.listにローカルパッadd_source_listケージ検索ディレクトリを追加する(apt-getでローカルディレクトリ上
		# のパッケージファイルを扱うことができるようにする)
		add_source_list

		# パッケージインデックスアップデートコマンドを発行する
		RTUtility.exec_remasterOS_command(CMD_UPDATE, nil, nil, nil, nil, "", true, true)
		RTUtility.end_wait_window
	end

	#=== パッケージ作成画面の右上ペインに表示するWidgetの返却
	#
	#パッケージ作成画面でパッケージ形式「Deb」が選択されたときに表示する
	#Widgetを返却する。
	#
	#復帰値:: パッケージ作成画面に表示するWidget
	#
	def get_makePackage_widget
		@glade["vbox_mkpackage"]
	end

	#=== オプションダイアログの表示
	#
	#debプラグインのオプションダイアログを表示する。
	#
	#復帰値:: なし
	#
	def show_option
		@glade["dialog_option"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_option"].show
	end

	#=== 読み込み可能パッケージの一覧取得
	#
	#作業用OS上で読み込み可能なパッケージの一覧を取得する。
	#
	#復帰値:: 読み込み可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_readable_packages
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_INSTALLABLE)
		ret_ary = get_packages(false)

		# ローカルパッケージの情報取得
		outAry = Array.new
		Dir[File.join(@glade["entry_pkgdir"].text.strip, "*.deb")].each{|deb|
			outAry.clear
			if RTUtility.exec_workOS_command(sprintf(CMD_INSTALLABLE_LOCAL, deb), outAry, nil, nil, nil, "", false)
				ary = outAry[0].split("__DELIM__")
				ret_ary.push ary unless ret_ary.include?(ary)
			end
		}
		RTUtility.end_wait_window
		ret_ary
	end

	#=== 依存パッケージ一覧の取得
	#
	#パラメタの操作を行うことによりインストールまたはアンインストールされるパッケージの一覧
	#を返却する。
	#また、パラメタ download が true の場合、パッケージをキャッシュディレクトリにダウン
	#ロードする。
	#
	#pkgs:: インストール／アンインストールパッケージ情報配列
	#       [ [インストールパッケージ１, バージョン1], [インストールパッケージ2, バージョン2], ... ]
	#opration::操作(true=インストール、false=アンインストール)
	#download::パッケージのダウンロードの要/不要。true=要、false=不要(省略時はfalse)
	#復帰値:: 依存パッケージ情報の2次元配列
	#          ary1[ary2, ary2, ary2...]
	#          ary2= [パッケージ名、バージョン、操作(true=インストール、false=アンインストール),
	#					 インストール/アンインストール操作コマンド]
	#
	def get_depend_packages(pkgs, opration, download = false)
		all_pkg = Array.new
		pkgs.each{|ary|
			if opration
				all_pkg.push(ary.join("="))
			else
				all_pkg.push(ary[0])
			end
		}
		pkg_str = all_pkg.join(" ")
		cmd = sprintf(CMD_GET_DPENDS, opration ? "install" : "remove", pkg_str)
		cmd_exec = sprintf(CMD_INSTALL_PKGS, opration ? "install" : "remove --purge", pkg_str)
		cmd_out_ary = Array.new
		ret_ary = Array.new
		RTUtility.exec_remasterOS_command(cmd, cmd_out_ary)

		cmd_out_ary.each{|pkginfo|
			ope, pkg, ver = pkginfo.split
			ver = ver.sub(/^\[(.+)\]/, '\1').sub(/^\(/, '')
			ret_ary.push([pkg, ver, ope == CMD_RET_INST, ret_ary.empty? ? cmd_exec : ""])

			# ダウンロード指定がtrue、かつ、インストール対象パッケージが1つ以上ある場合はapt-getコマンドを発行
			begin
				download_package(pkg, ver) if download && (ope == CMD_RET_INST)
			rescue
				RTUtility.get_logger.error("deb:get_depend_packages: " + $!.to_s)
			end
		}
		ret_ary
	end

	#=== インストール後の環境掃除
	#
	#インストール成功後にパッケージファイルなどの掃除を行う。
	#
	#復帰値:: なし
	#
	def clear
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_DELETE)
		# リマスタリング作業用リソースの退避
		backup_resource
		# パッケージファイルを削除する
		RTUtility.exec_remasterOS_command(sprintf(CMD_CLEAN, @glade["entry_pkgdir"].text))
		RTUtility.end_wait_window
	end

	#=== リマスタリング環境のインポート
	#
	#引数のdirで示すディレクトリ内の資産を現在のリマスタリング環境に適用する。
	#
	#dir:: インポート資源ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def import(dir)
		list_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
					RTUtility.get_apt_setting("Dir::State"),
					RTUtility.get_apt_setting("Dir::State::lists"))
		source_list = File.join(RTUtility.get_os_plugin.get_root_dir,
						RTUtility.get_apt_setting("Dir::Etc"),
						RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
		pkg_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
						@glade["entry_pkgdir"].text)
		cache_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
					RTUtility.get_apt_setting("Dir::Cache"),
					RTUtility.get_apt_setting("Dir::Cache::archives"))

		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_IMPORT)
		begin
			# パッケージファイルを（リマスタOS上の)ローカルパッケージ検索ディレクトリに格納する
			FileUtils.mkdir_p(pkg_dir)
			cmd = sprintf("cp -a %s %s", File.join(dir, "*.deb"), pkg_dir)
			RTUtility.exec_workOS_command(cmd)

			# source.listをリマスタOS上の)/etc/aptに格納する
			src = File.join(dir, RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
			if File.exist?(src)
				FileUtils.mkdir_p(File.dirname(source_list))
				RTUtility.exec_workOS_command("cp -a #{src} #{source_list}")
			end

			# *.listファイルを/var/lib/apt/listsに格納する	
			src = File.join(dir, RTUtility.get_apt_setting("Dir::State::lists"))
			if File.exist?(src)
				FileUtils.mkdir_p(list_dir)
				RTUtility.exec_workOS_command("cp -a #{src}/* #{list_dir}")
			end

			# リマスタリング対象OS上のローカルパッケージ検索ディレクトリにPackages.gzを作成する
			if RTUtility.isInitialized?
				add_source_list
				do_check_update(MSG_QUE_SET_UPDATE)
			end

			RTUtility.end_wait_window

		rescue
			RTUtility.end_wait_window
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_IMPORT, $!.to_s))
			dlg.run
			dlg.destroy
			return false
		end
		true
	end

	#=== リマスタリング環境のエクスポート
	#
	#引数のdirで示すディレクトリにの現在のリマスタリング環境資産を格納する。
	#
	#dir:: エクスポート先ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def export(dir)
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_EXPORT)
		begin
			backup_resource
			FileUtils.mkdir_p(dir)
			RTUtility.exec_workOS_command("cp -a #{@glade["entry_pkgdir"].text}/* #{dir}")
			RTUtility.end_wait_window
		rescue
			RTUtility.end_wait_window
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_EXPORT, $!.to_s))
			dlg.run
			dlg.destroy
			return false
		end
		true
	end

private

	########################################
	# パッケージ作成画面
	########################################
	#=== [詳細]ボタンクリック持のイベントハンドラ
	#
	#パッケージ詳細情報ダイアログを表示する。
	#
	#widget:: [詳細]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_detail_clicked(widget)
		@glade["dialog_detail"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_detail"].show
	end

	########################################
	# Option dialog
	########################################

	#=== オプション情報の読み込み
	#
	#オプション情報を読み込み、対応する部品に設定する。
	#
	#復帰値:: なし
	#
	def read_option
		# パッケージ検索ディレクトリの読み込み
		gconf = GConf::Client.default
		@glade["entry_pkgdir"].text = gconf[CONF_KEY_SEARCHDIR] ? gconf[CONF_KEY_SEARCHDIR] : DEFAULT_SEARCHDIR
	end

	#=== オプションダイアログ表示時のイベントハンドラ
	#
	#/etc/apt/sources.listを読み込みダイアログのテキストビューに設定する。
	#
	#widget:: オプションダイアログのWidget
	#復帰値:: なし
	#
	def on_dialog_option_map(widget)
		unless @tab_page
			sourceList = File::SEPARATOR +
						File.join(RTUtility.get_apt_setting("Dir::Etc"),
								RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
			notebook = Gtk::Notebook.new
			@glade["dialog-option-vbox"].pack_start(notebook, true, true, 10)
			@glade["dialog-option-vbox"].reorder_child(notebook, 0)
			scroll = Gtk::ScrolledWindow.new
			scroll.shadow_type = Gtk::SHADOW_IN
			scroll.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
			buffer = Gtk::TextBuffer.new
			@tab_page = Gtk::TextView.new(buffer)
			scroll.add(@tab_page)
			label = Gtk::Label.new(File.basename(sourceList))
			notebook.append_page(scroll, label)
			notebook.page = 0
			notebook.show_all
		end

		if RTUtility.isInitialized?
			@tab_page.sensitive = true
			# 初期設定が完了している場合、sources.listを読み込み、タブ表示する
			sourceList = File::SEPARATOR +
						File.join(RTUtility.get_apt_setting("Dir::Etc"),
								RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
	
			begin
				@tab_page.buffer.set_text(RTUtility.read_file(sourceList, true))
			rescue
				@tab_page.sensitive = false
				dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::WARNING,
						Gtk::MessageDialog::BUTTONS_OK, MSG_WARN_OPT_NOREPOS)
				dlg.run
				dlg.destroy
				return
			end
		else
			# 初期設定が完了していいない場合、表示域を無効状態にして警告メッセージを表示する
			@tab_page.sensitive = false
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING,
					Gtk::MessageDialog::BUTTONS_OK, MSG_WARN_OPT_NOINIT)
			dlg.run
			dlg.destroy
		end
	end

	#=== [参照]ボタンクリック持のイベントハンドラ
	#
	#[参照]ボタンクリック時にディレクトリ選択ダイアログを開き、ローカルパッケージ検索ディレクトリを
	#選択する。
	#
	#widget:: [参照]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_pkgdir_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_SEL_PKGDIR,
												@glade["dialog_option"],
												Gtk::FileChooser::ACTION_SELECT_FOLDER,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		begin
			path = Pathname.new(@glade["entry_pkgdir"].text.strip).realpath
			path = File.dirname(path) unless File.directory?(path)
			chooser.current_folder = path
		rescue
		end
		@glade["entry_pkgdir"].set_text(chooser.filename) if chooser.run == Gtk::Dialog::RESPONSE_OK
		chooser.destroy
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にキャンセルボタンのハンドラを呼び出し、キャンセルボタンと同じ動作を実現する。
	#
	#widget:: オプションダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_option_delete_event(widget, arg0)
		on_cancelbutton_clicked(@glade["cancelbutton"])
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にオプションダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_cancelbutton_clicked(widget)
		@glade["dialog_option"].hide
		read_option
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時にオプション情報を保存してからダイアログを閉じる。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_okbutton_clicked(widget)
		# 入力チェック
		if @glade["entry_pkgdir"].text.strip.empty?
			dlg = Gtk::MessageDialog.new(@glade["dialog_option"], Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK,
					MSG_WARN_NO_LOCALPKGDIR)
			dlg.run
			dlg.destroy
			return
		end

		if @tab_page.sensitive?
			sourceList = File::SEPARATOR +
						File.join(RTUtility.get_apt_setting("Dir::Etc"),
								RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
			RTUtility.write_file(sourceList, @tab_page.buffer.text, true)

			@glade["entry_pkgdir"].text = @glade["entry_pkgdir"].text.strip
	
			# リマスタリング対象OS上のローカルパッケージ検索ディレクトリにPackages.gzを作成する
			add_source_list
		end

		gconf = GConf::Client.default
		gconf[CONF_KEY_SEARCHDIR] = @glade["entry_pkgdir"].text.strip

		on_cancelbutton_clicked(@glade["cancelbutton"])

		# パッケージインデックスの更新確認を行う。
		do_check_update(MSG_QUE_SET_UPDATE) if @tab_page.sensitive?
	end


	########################################################
	# パッケージ作成機能
	########################################################

public

	#=== パッケージの読み込み
	#
	#パッケージファイルを展開して内容を読み込む。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#復帰値:: なし
	#
	def read_package(name, version)
		temp = ""
		begin
			# パッケージファイルの場所を取得
			pkg_path = search_package(name, version)

			# お待ちくださいウインドウを表示する。
			RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_EXTRACT)

			# 展開先ディレクトリを作成
			temp = make_directory

			# 返却用のパッケージ内ファイル一覧リストを作成する
			ret_ary = get_file_list(pkg_path, temp)
	
			# controlファイルの読み込み
			apply_control(pkg_path, temp)
	
			# change log/copyright/README.debianの読み込み
			begin
				@glade["textview_log"].buffer.text = RTUtility.read_gzip_file(File.join(temp, sprintf(FILE_CHANGE_LOG, name)))
			rescue
				begin
					@glade["textview_log"].buffer.text = RTUtility.read_gzip_file(File.join(temp, sprintf(FILE_CHANGE_LOG2, name)))
				rescue
				end
			end
			begin
				@glade["textview_copyright"].buffer.text = RTUtility.read_file(File.join(temp, sprintf(FILE_COPYRIGHT, name)))
			rescue
			end
			begin
				@glade["textview_readme"].buffer.text = RTUtility.read_gzip_file(File.join(temp, sprintf(FILE_README, name) + ".gz"))
			rescue
				begin
					@glade["textview_readme"].buffer.text = RTUtility.read_file(File.join(temp, sprintf(FILE_README, name)))
				rescue
				end
			end
			RTUtility.end_wait_window

		rescue
			RTUtility.end_wait_window
			RTUtility.get_logger.error("deb:read_package: " + $!.to_s)
			# パッケージ読み込み中にエラーが発生した場合はエラーメッセージを表示する
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return

#		ensure
#			FileUtils.rm_rf(temp) unless temp.empty?
		end

		ret_ary
	end

	#=== パッケージの作成
	#
	#パッケージ作成画面で設定した情報にしたがってパッケージを作成する。
	#
	#fileAry:: パッケージ内容ファイルリスト
	#          Array1 = [Array2, Array2, ...]
    #          Array2 = [fileパス, file prefix]
	#復帰値:: 作成パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、常にtrue, インストール操作コマンド]
	#備考::作成したパッケージは ローカルパッケージ検索ディレクトリにコピーする．
	#
	def make_package(fileAry)
		pkg_array = nil

		#設定項目のチェック
		return unless check_input

		begin
			if @pkg_make_dir.empty? or @pkg_make_name.empty? or @pkg_make_vl.empty? or
				@pkg_make_name != @glade["entry_name"].text or
				@pkg_make_vl != @glade["entry_version"].text

				# パッケージディレクトリの作成
				@pkg_make_dir = make_directory
				# パッケージ雛型の作成
				@pkg_make_dir = make_templete @pkg_make_dir

				@pkg_make_name = @glade["entry_name"].text
				@pkg_make_vl = @glade["entry_version"].text
			end

			# パッケージ格納ファイルのコピー
			copy_file(@pkg_make_dir, fileAry)
	
			# パッケージの作成
			pkg_array = make @pkg_make_dir
			if pkg_array
				@pkg_make_dir = ""
			end

		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
#			FileUtils.rm_rf(@pkg_make_dir) unless @pkg_make_dir.empty?
			return nil
		end
		pkg_array
	end

private

	#=== パッケージ格納ディレクトリの取得
	#
	#指定されたパッケージをローカルパッケージ検索ディレクトリから検索する。見付からない場合、ネットワーク
	#上からダウンロードする。ダウンロードできない場合、例外を発生する。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#復帰値:: パッケージファイルのパス（絶対パス）
	#
	def search_package(name, version)
		path = ""

		# 展開するパッケージをローカルパッケージ検索ディレクトリ内から検索する
		files = Dir[File.join(@glade["entry_pkgdir"].text, name + "_" + version + "_*.deb") ]
		if files.size > 0
			RTUtility.get_logger.debug("found pkg file in local: " + files[0])
			path = files[0]
		else
			# ローカルパッケージ検索ディレクトリに存在しない場合、ダウンロードする
			download_package(name, version, false)
			down_dir = File::SEPARATOR +
						File.join(RTUtility.get_apt_setting("Dir::Cache"),
								RTUtility.get_apt_setting("Dir::Cache::archives"))
			files = Dir[File.join(down_dir, name + "_" + version + "_*.deb") ]
			raise MSG_ERR_NO_PACKAGE if files.empty?
			RTUtility.get_logger.debug("found pkg file in internet: " + files[0])
			path = files[0]
		end
		path
	end

	#=== パッケージ内ファイル一覧の取得
	#
	#指定されたパッケージファイルを指定のテンプディレクトリに展開し、含まれるファイルの一覧を
	#作成する。
	#
	#pkg_file:: パッケージファイル名（絶対パス形式）
	#temp:: パッケージ展開用テンプディレクトリ
	#復帰値:: ファイルリスト
	#        Array1 = [Array2, Array2, ...]
	#        Array2 = [ファイル名、ディレクトリ名、プレフィックス（作業ディレクトリ）
	#備考:: ディレクトリ名は絶対パスから展開用のテンプディレクトリを削除したパス（インス
	#       トールパス）にして返却する。プレフィックスるには取り除いたパス（展開用テンプディレクトリ）
	#       のパスを設定する。
	#
	def get_file_list(pkg_file, temp)
		# パッケージの展開
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_PKG, pkg_file, temp))
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status.to_s) unless status == 0

		# ファイル一覧リストの作成
		ret_ary = Array.new
		Find.find(temp) {|file|
			# 配列は[ファイル名, ディレクトリ名, プレフィックス]
			unless File.directory?(file)			# ディレクトリは除外
				ret_ary.push( [ File.basename(file.sub(temp, "")), File.dirname(file.sub(temp, "")), temp ])
			end
		 }
		ret_ary
	end

	#=== パッケージのダウンロード
	#
	#指定されたパッケージをダウンロードする。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#remasteros:: ダウンロード先 true=理マスタリング対象OS, false=作業用OS
	#
	#復帰値:: なし
	#
	def download_package(name, version, remasteros = true)
		# aptコマンドでパッケージとバージョンを指定してダウンロードする
		cmd = sprintf(CMD_GET_PKGS, name + "=" + version)
		status = 0
		if remasteros
			RTUtility.get_logger.debug("download package #{name} to remastering os")
			status = RTUtility.exec_remasterOS_command(cmd, nil, nil, nil, RTUtility.mainWindow, sprintf(MSG_INF_PKG_DOWNLOAD, name), true, true)
		else
			RTUtility.get_logger.debug("download package #{name} to work os")
			RTUtility.show_wait_window(RTUtility.mainWindow, sprintf(MSG_INF_PKG_DOWNLOAD, name))
			status = RTUtility.exec_workOS_command(cmd)
			RTUtility.end_wait_window
		end
		raise sprintf(MSG_ERR_DOWNLOAD_PACKAGE, status) unless status == 0
	end

	#=== controlファイルの読み込み
	#
	#パッケージを展開してコントロールを抽出する。
	#
	#pkg_file:: パッケージファイル名（絶対パス形式）
	#temp:: パッケージ展開用テンプディレクトリ
	#復帰値:: なし
	#
	def apply_control(pkg_file, temp)
		# パッケージファイルを展開して制御ファイルを抽出する
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_CTL, pkg_file, temp))
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status.to_s) unless status == 0
		begin
			control = RTUtility.read_file(File.join(temp, FILE_CONTROL))
		rescue
			raise sprintf(MSG_ERR_EXTRACT_PACKAGE, $!.to_s)
		end

		# controlファイルの各行に対して解析を行う
		@glade["treeview_depend"].model.clear
		control.split("\n").each{|line|
			case line
			when /^(Package: )(.*$)/
				@glade["entry_name"].text = $~[2]
			when /^(Version: )(.*$)/
				@glade["entry_version"].text = $~[2]
			when /^(Section: )(.*$)/
				subsect = $~[2]
				sect = "main"
				if subsect.include? "/"
					sect, subsect = subsect.split("/")
				end
				set_combo(@glade["combobox_section"], sect)
				set_combo(@glade["combobox_subsection"], subsect)
			when /^(Priority: )(.*$)/
				set_combo(@glade["combobox_priority"], $~[2])
			when /^(Maintainer: )(.*)<(.*)>/
				@glade["entry_maintainer"].text = $~[2]
				@glade["entry_email"].text = $~[3]
			when /^(Architecture: )(.*)/
				set_combo(@glade["combobox_arch"], $~[2])
			when /^(Depends): (.*)/,   /^(Suggests): (.*)/, /^(Recommends): (.*)/,
				 /^(Conflicts): (.*)/, /^(Replaces): (.*)/, /^(Provides): (.*)/,
				 /^(Pre-Depends): (.*)/
				analyze_relation($~[1], $~[2]) unless $~[2].empty?
			when /^(Description: )(.*)/
				@glade["textview_desc"].buffer.text = $~[2]
			when /^ (.*)$/
				@glade["textview_desc"].buffer.insert(@glade["textview_desc"].buffer.end_iter, "\n" + $~[1])
			else
			end
		}
	end

	#=== 依存関係の解析
	#
	#パッケージ依存関係を解析して詳細情報ダイアログの依存関係リストに設定する。
	#
	#relation:: 依存関係
	#content:: 依存関係情報（ex. "libc6 (>= 2.3.6-6), libgd2-noxpm (>= 2.0.33)")
	#復帰値:: なし
	#
	def analyze_relation(relation, content)
		# ","で区切って各依存関係定義を配列にする
		content.split(",").each {|pkg|
			name = pkg.strip
			version = ""
			if pkg =~ /(.+) \((.+)\)/
				name = $~[1]
				version = $~[2]
			end
			RTUtility.add_list(@glade["treeview_depend"], [name.strip, version.strip, relation.strip])
		}
	end

	#=== パッケージ作成画面の入力チェック
	#
	#パッケージを作成するときに必須入力項目がすべて入力されているかチェックする。
	#
	#復帰値:: なし
	#
	def check_input
		# 必須入力項目がすべて入力されているかチェックする
		begin
			raise MSG_WARN_NO_NAME if @glade["entry_name"].text.strip.empty?
			raise MSG_WARN_NO_VERSION if @glade["entry_version"].text.strip.empty?
			raise MSG_WARN_NO_DESC if @glade["textview_desc"].buffer.text.strip.empty?
			raise MSG_WARN_NO_SUBSECT if @glade["combobox_subsection"].active_text.strip.empty?
			raise MSG_WARN_NO_ARCH if @glade["combobox_arch"].active_text.strip.empty?
			raise MSG_WARN_NO_MAINT if @glade["entry_maintainer"].text.strip.empty?
			raise MSG_WARN_NO_EMAIL if @glade["entry_email"].text.strip.empty?
			raise MSG_WARN_NO_CHANGELOG if @glade["textview_log"].buffer.text.strip.empty?
			[@glade["entry_name"], @glade["entry_version"], @glade["entry_maintainer"], @glade["entry_email"]].each{|widget| widget.text = widget.text.strip}

#			[@glade["textview_desc"], @glade["textview_log"]].each{|widget| widget.buffer.text = widget.buffer.text.strip}
			true
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK,
					$!.to_s)
			dlg.run
			dlg.destroy
			false
		end
	end

	#=== パッケージ作成用ディレクトリの作成
	#
	#パッケージ作成用のディレクトリを作成する。
	#
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def make_directory
		index = 0
		temp = File.join(Dir.tmpdir, DISPLAY_NAME + $$.to_s + index.to_s)
		begin
			while true
				File.ftype(temp)
				index = index + 1
				temp = File.join(Dir.tmpdir, DISPLAY_NAME + $$.to_s + index.to_s)
			end
		rescue
		end

		FileUtils.mkdir_p(temp)
		@tmp_dirs.push(temp)
		temp
	end

	#=== パッケージテンプレートの作成
	#
	#パッケージ作成用のテンプレートを作成する。
	#
	#dir:: パッケージテンプレート作成用ディレクトリ
	#復帰値:: パッケージテンプレート格納ディレクトリ
	#
	def make_templete(dir)
		# テンプレート作成用ディレクトリの作成
		temp = File.join(dir, @glade["entry_name"].text + "-" + @glade["entry_version"].text.split("-")[0])
		FileUtils.mkdir_p(temp)

		# パッケージテンプレートの作成
		cmd = sprintf(CMD_MK_TEMPLETE, temp, @glade["entry_email"].text)
		status = RTUtility.exec_workOS_command(cmd)
		raise sprintf(MSG_ERR_CREATE_TEMPLETE, status) unless status == 0
		temp
	end

	#=== 内容のコピー
	#
	#パッケージ作成用のディレクトリを作成する。
	#
	#dir:: パッケージ作成用ディレクトリ
	#file_ary:: パッケージに含めるファイル名一覧
	#復帰値:: なし
	#
	def copy_file(dir, file_ary)
		# パッケージでインストールされるファイルのコピー
		pkg_file_dir = File.join(dir, "pkg_files")
		FileUtils.rm_rf(pkg_file_dir)
		FileUtils.mkdir_p(pkg_file_dir)

		file_ary.each{|ary|
			src  = File.join(ary[1], ary[0])
			dest = File.join(pkg_file_dir, ary[0])
			if FileTest.directory?(src) && FileTest.directory?(dest)
				dest = File.dirname(dest)
			else
				FileUtils.mkdir_p(File.dirname(dest))
			end
			RTUtility.exec_workOS_command("cp -a #{src} #{dest}")
		}

		# パッケージ設定ファイルのコピー
		debian_dir = File.join(dir, "debian")
		RTUtility.write_file(File.join(debian_dir, "copyright"),
			@glade["textview_copyright"].buffer.text)					# コピーライトファイル
		RTUtility.write_file(File.join(debian_dir, "changelog"),
			@glade["textview_log"].buffer.text)							# change log
		RTUtility.write_file(File.join(debian_dir, "README.Debian"),
			@glade["textview_readme"].buffer.text)						# README.debian

		# control ファイルの内容置換
		control_new = ""
		exist_vl = false
		end_control = false
		control = RTUtility.read_file(File.join(dir, "debian", FILE_CONTROL))
		control.split("\n").each{|line|
			case line
			when /^(Package: ).*/, /^(Source: ).*/
				line = $~[1] + @glade["entry_name"].text.strip
			when /^(Version: ).*/
				line = $~[1] + @glade["entry_version"].text.strip
				exist_vl = true
			when /^(Section: ).*/
				line = $~[1] + @glade["combobox_section"].active_text + "/" + @glade["combobox_subsection"].active_text
			when /^(Priority: ).*/
				line = $~[1] + @glade["combobox_priority"].active_text
			when /^(Maintainer: ).*/
				line = $~[1] + @glade["entry_maintainer"].text.strip + " <" + @glade["entry_email"].text.strip + ">"
			when /^(Architecture: ).*/
				line = $~[1] + @glade["combobox_arch"].active_text
			when /^(Depends: )(.*)/
				PKG_RELATION.each{|rel|
					line << get_relation(rel)
				}
				line.chomp!
			when /^(Description: ).*/
				line = $~[1] + @glade["textview_desc"].buffer.text.strip.gsub("\n", "\n ")
				end_control = true
			when /^ <.+>$/
				line = ""
			else
			end
			control_new << line + "\n"
			break if end_control
		}
		# 編集したcontrol ファイルを書き戻す
		RTUtility.write_file(File.join(dir, "debian", FILE_CONTROL), control_new)

		# Makefileのコピー
		FileUtils.cp(File.join(@my_dir, "Makefile.buildpackage"), File.join(dir, "Makefile"))
	end

	#=== 依存関係の抽出
	#
	#パラメタで指定された依存関係をcontrolファイルの形式で抽出する。
	#
	#rel:: 抽出する依存関係
	#復帰値:: 依存関係文字列
	#
	def get_relation(rel)
		rel_str = rel == "Depends" ? ", " : rel + ": "
		iter = @glade["treeview_depend"].model.iter_first
		if iter
			begin
				if iter[2] == rel
					rel_str << iter[0]
					rel_str << " (" + iter[1] + ")" unless iter[1].empty?
					rel_str << ","
				end
			end while iter.next!
		end
		rel_str = rel_str.sub(/,$/, "")
		rel_str = rel_str.sub(/$/, "\n")
	end

	#=== パッケージの作成
	#
	#パッケージをビルドする。
	#
	#dir:: パッケージの雛型のディレクトリ
	#復帰値:: 作成したパッケージのじ情報 [パッケージ名,バージョン,true,インストールコマンド]
	#
	def make(dir)
		# パッケージ作成コマンドの実行
		cmd = sprintf(CMD_MK_PKG, dir)
		RTUtility.exec_workOS_command(cmd)
		ary = nil
		ret_array = Array.new
		if @glade["combobox_arch"].active_text == "any"
			ary = Dir[File.join(dir, "..", @glade["entry_name"].text + "_" + @glade["entry_version"].text + "_*.deb")]
		else
			ary = Dir[File.join(dir, "..", @glade["entry_name"].text + "_" + @glade["entry_version"].text + "_" + @glade["combobox_arch"].active_text + ".deb")]
		end
		return nil if ary.size == 0 

		path = Pathname.new(ary[0])

		FileUtils.mkdir_p(@glade["entry_pkgdir"].text)
		FileUtils.cp(ary[0], @glade["entry_pkgdir"].text)
		ret_array.push [@glade["entry_name"].text, @glade["entry_version"].text,
					 true,
					 sprintf(CMD_INSTALL_PKGS, "install", @glade["entry_name"].text) + "=" + @glade["entry_version"].text]

		# 作業用OS上のローカルパッケージ検索ディレクトリからリマスタリング対象OSのローカルパッケージ
		# 検索ディレクトリにパッケージファイルをコピーする
		if RTUtility.isInitialized?
			remaster_dir = File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text)
			FileUtils.mkdir_p(remaster_dir)
			RTUtility.exec_workOS_command("mkdir -p " + remaster_dir + " && cp " + ary[0] + " " + remaster_dir)

			# sources.listにローカルパッケージ検索ディレクトリを追加する(apt-getでローカルディレクトリ上
			# のパッケージファイルを扱うことができるようにする)
			add_source_list
			do_check_update(MSG_QUE_PKG_UPDATE)
		end

		return ret_array
	end

	#=== /etc/apt/source.listへのエントリ追加
	#
	# /etc/apt/source.listにオプションダイアログで設定したローカルパッケージ検索ディレクトリを追加する。
	#
	#復帰値:: なし
	#
	def add_source_list
		sourceList = File::SEPARATOR +
			File.join(RTUtility.get_apt_setting("Dir::Etc"),
			RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
	
		findPkgDir = false
		source_list = RTUtility.read_file(sourceList, true)
		source_list.split("\n").each{|line|
			ary = line.split
			next if ary.size < 3
			if ary[0] == "deb" and ary[1] == ("file:" + @glade["entry_pkgdir"].text + "/")
				findPkgDir = true
				break
			end
		}
		add_line = "deb file:" + File.join(@glade["entry_pkgdir"].text) + "/ ./"
		unless findPkgDir
			source_list << "\n" + add_line
			RTUtility.write_file(sourceList, source_list, true)
		end
		cmd = sprintf(CMD_APTARCH, @glade["entry_pkgdir"].text, @glade["entry_pkgdir"].text)
		status = RTUtility.exec_remasterOS_command(cmd)
	end

	#=== パッケージインデックスの更新実施チェック
	#
	#パッケージインデックスの更新を実施してもいいか確認を行う。
	#実施OKの場合はパッケージインデックス更新メソッドを呼び出す。
	#msg::表示メッセージ
	#復帰値:: なし
	#
	def do_check_update(msg)
		# パッケージインデックスを更新してもいいか確認する
		dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
				Gtk::MessageDialog::QUESTION,
				Gtk::MessageDialog::BUTTONS_YES_NO, msg)
		response = dlg.run
		dlg.destroy
		if response == Gtk::Dialog::RESPONSE_YES
			update_package_index
		end
	end

	#=== コンボボックスの選択項目の設定
	#
	#パラメタで指定されたコンボボックスをパラメタで指定した文字列が選択状態になるように設定する
	#
	#combo:: 選択状態を設定するコンボボックス
	#elm:: 選択状態を設定するテキストが設定されているXMLエレメント
	#復帰値:: なし
	#
	def set_combo(combo, text)
		combo.model.each do |model,path,iter|
			if iter[0].casecmp(text) == 0
				combo.active_iter = iter
				break
			end
		end
	end

	########################################
	# パッケージ詳細情報 dialog
	########################################

	#=== パッケージ詳細情報ダイアログの初期化
	#
	#パッケージ詳細情報ダイアログ内の部品を初期化する。
	#
	#復帰値:: なし
	#
	def make_detail_dialog
		#セクションコンボボックスの内容設定
		PKG_SECTIONS.each {|str| @glade["combobox_section"].append_text str }
		#サブセクションコンボボックスの内容設定
		PKG_SUBSECTIONS.each {|str| @glade["combobox_subsection"].append_text str }
		#アーキテクチャコンボボックスの内容設定
		PKG_ARCHS.each {|str| @glade["combobox_arch"].append_text str }
		#優先度コンボボックスの内容設定
		PKG_PRIORITY.each {|str| @glade["combobox_priority"].append_text str }
		# 依存関係リストのヘッダを作成する
		PKG_DEPLIST_HEADER.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_depend"].append_column(column)
		}
		@glade["treeview_depend"].set_model(Gtk::ListStore.new(String, String, String))
		@glade["treeview_depend"].selection.mode = Gtk::SELECTION_MULTIPLE
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: パッケージ情報詳細ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_detail_delete_event(widget, arg0)
		@glade["dialog_detail"].hide
	end

	#=== [閉じる]ボタンクリック持のイベントハンドラ
	#
	#[閉じる]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: [閉じる]ボタンのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_button_detail_close_clicked(widget)
		@glade["dialog_detail"].hide
	end

	#=== [開く]ボタン(コピーライト)クリック持のイベントハンドラ
	#
	#[開く]ボタン(コピーライト)クリック時にファイル選択ダイアログを開き、
	#指定されたファイルをテキストビューに読み込む。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_copyright_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_COPYRIGHT,
												@glade["dialog_detail"],
												Gtk::FileChooser::ACTION_OPEN,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		chooser.set_current_folder(DIR_TEMPLETE_COPYRIGHT)
		if chooser.run == Gtk::Dialog::RESPONSE_OK
			@glade["textview_copyright"].buffer.set_text(RTUtility.read_file(chooser.filename))
		end
		chooser.destroy
	end

	#=== [開く]ボタン(更新履歴)クリック持のイベントハンドラ
	#
	#[開く]ボタン(更新履歴)クリック時にファイル選択ダイアログを開き、
	#指定されたファイルをテキストビューに読み込む。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button1_log_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_LOG,
												@glade["dialog_detail"],
												Gtk::FileChooser::ACTION_OPEN,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		if chooser.run == Gtk::Dialog::RESPONSE_OK
			@glade["textview_log"].buffer.set_text(RTUtility.read_file(chooser.filename))
		end
		chooser.destroy
	end

	#=== [開く]ボタン(README.Debian)クリック持のイベントハンドラ
	#
	#[開く]ボタン(README.Debian歴)クリック時にファイル選択ダイアログを開き、
	#指定されたファイルをテキストビューに読み込む。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_readme_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_LOG,
												@glade["dialog_detail"],
												Gtk::FileChooser::ACTION_OPEN,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		if chooser.run == Gtk::Dialog::RESPONSE_OK
			@glade["textview_readme"].buffer.set_text(RTUtility.read_file(chooser.filename))
		end
		chooser.destroy
	end

	#=== [追加]ボタンクリック持のイベントハンドラ
	#
	#[追加]ボタンクリック時に依存パッケージ選択ダイアログを開き、依存パッケージの選択を行う。
	#
	#widget:: [追加]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_dep_add_clicked(widget)
		@glade["dialog_pkgselect"].set_transient_for(@glade["dialog_detail"])
		@glade["dialog_pkgselect"].show
	end

	#=== 依存パッケージの追加
	#
	#依存パッケージパッケージ選択ダイアログで選択したパッケージを依存パッケージリストに追加する。
	#
	#addArry:: 追加するパッケージ情報(2次元配列)
	#         [[name1, dep version1, relation1],[name2, dep version2, relation2],...]
	#復帰値:: なし
	#
	def add_deplist(addArry)
		addArry.each{ |pkginf|
			iter = @glade["treeview_depend"].model.append
			iter[0] = pkginf[0]
			iter[1] = pkginf[1]
			iter[2] = pkginf[2]
		}
	end

	#=== [削除]ボタンクリック持のイベントハンドラ
	#
	#依存パッケージリストから選択されたパッケージを削除する。
	#
	# 	#widget:: [削除]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_dep_del_clicked(widget)
		RTUtility.del_list(@glade["treeview_depend"])
	end

	########################################
	# 依存パッケージ選択 dialog
	########################################

	#=== 依存パッケージ選択ダイアログの初期化
	#
	#依存パッケージ選択ダイアログ内の部品を作成する。
	#
	#復帰値:: なし
	#
	def make_depend_dialog
		# 依存関係リストのヘッダを作成する
		PKG_SELDEPLIST_HEADER.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_sel_deppackage"].append_column(column)
		}
		@glade["treeview_sel_deppackage"].set_model(Gtk::ListStore.new(String, String))
		@glade["treeview_sel_deppackage"].selection.mode = Gtk::SELECTION_MULTIPLE

		# バージョン比較用のコンボボックスの内容を作成する
		PKG_COMPARE.each {|str| @glade["combobox_compare"].append_text str }

		# 依存関係のコンボボックスの内容を作成する
		PKG_RELATION.each {|str| @glade["combobox_relation"].append_text str }
	end

	#=== ラジオボタンクリック持のイベントハンドラ
	#
	#ラジオボタンクリック時に非選択側の入力域を無効状態にする。
	#
	#widget:: クリックしたラジオボタンのWidget
	#復帰値:: なし
	#
	def on_radio_list_clicked(widget)
		if widget == @glade["radio_list"]
			@glade["treeview_sel_deppackage"].set_sensitive true
			@glade["entry_sel_package"].set_sensitive false
		else
			@glade["treeview_sel_deppackage"].set_sensitive false
			@glade["entry_sel_package"].set_sensitive true
		end
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にキャンセルボタンのハンドラを呼び出し、キャンセルボタンと同じ動作を実現する。
	#
	#widget:: 依存パッケージ選択ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_pkgselect_delete_event(widget, arg0)
		on_button_sel_cancel_clicked(@glade["button_sel_cancel"])
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: [キャンセル]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_sel_cancel_clicked(widget)
		@glade["dialog_pkgselect"].hide
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時に依存パッケージ情報を詳細設定ダイアログに通知し、ダイアログを閉じる。
	#
	#widget:: [OK]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_sel_ok_clicked(widget)
		addPkgs = Array.new
		begin
			if @glade["radio_list"].active?
				# リストから選択
				selection = false
				@glade["treeview_sel_deppackage"].selection.selected_each{|model, path, iter|
					addPkgs.push(
						make_dep_array(iter[0], @glade["entry_dep_version"].text.strip,
									@glade["combobox_compare"].active_text,
									@glade["combobox_relation"].active_text))
					selection = true
				}
				raise MSG_WARN_NO_SELDEPPKG unless selection
			else
				# 直接指定
				raise MSG_WARN_NO_INPUTDEPPKG if @glade["entry_sel_package"].text.strip.empty?
				
				addPkgs.push(
					make_dep_array(@glade["entry_sel_package"].text.strip,
								@glade["entry_dep_version"].text.strip, 
								@glade["combobox_compare"].active_text,
								@glade["combobox_relation"].active_text))
			end
			add_deplist addPkgs
			@glade["dialog_pkgselect"].hide

		rescue
			# パッケージ読み込み中にエラーが発生した場合はエラーメッセージを表示する
			dlg = Gtk::MessageDialog.new(@glade["dialog_pkgselect"], Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return
		end
	end

	#=== 依存パッケージ情報配列の作成
	#
	#依存パッケージ情報を配列(name, depend version, relation)にして返却する。
	#
	#name:: パッケージ名
	#dep_version:: 依存するバージョン
	#compare:: バージョン比較方法
	#relation:: 関係
	#復帰値:: 依存パッケージ情報
	#         [name1, compare dep version, relation]
	#
	def make_dep_array(name, dep_version, compare, relation)
		if dep_version.strip.empty?
			version = ""
		else
			version = compare.strip  + " " + dep_version.strip
		end
		[name.strip, version, relation]
	end

	#=== 依存パッケージ選択ダイアログ表示時のイベントハンドラ
	#
	#依存パッケージ選択ダイアログ表示時に利用可能なパッケージの一覧を選択リストに設定する。
	#
	#widget:: 依存パッケージ選択ダイアログのWidget
	#復帰値:: なし
	#
	def on_dialog_pkgselect_map(widget)
		unless @initialize_deplistdlg
			installable = get_readable_packages
			installable.each { |ary|
				iter = @glade["treeview_sel_deppackage"].model.append
				iter[0] = ary[0]
				iter[1] = ary[2]
			}
			@initialize_deplistdlg = true
			@glade["treeview_sel_deppackage"].model.set_sort_column_id(0)	# =リストの先頭カラムでソート
		end

		@glade["combobox_compare"].active = 0
		@glade["combobox_relation"].active = 0
		@glade["radio_list"].clicked
		@glade["entry_sel_package"].text = ""
		@glade["entry_dep_version"].text = ""
		@glade["scrolledwindow_seldep_list"].vadjustment.value = @glade["scrolledwindow_seldep_list"].vadjustment.lower
		@glade["treeview_sel_deppackage"].selection.unselect_all
	end

	#=== インストール可能パッケージの一覧取得
	#
	#リマスタリング対象OS上にインストール可能なパッケージの一覧を取得する。
	#
	#remaster:: 情報の取得先(true=リマスタリング対象OS, flase=作業用OS)
	#復帰値:: インストール可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_packages(remater = true)
		outAry = Array.new
		regexp1 = /^Package: (.+)/
		regexp2 = /^Version: (.+)/
		regexp3 = /^Description: (.+)/
		pkg = ""
		ver = ""
		desc = ""
		if remater
			RTUtility.exec_remasterOS_command(CMD_INSTALLABLE, outAry, nil, nil,
				nil, "", false, false)
		else
			RTUtility.exec_workOS_command(CMD_INSTALLABLE, outAry, nil, nil,
				nil, "", false)
		end

		installableAry = Array.new
		outAry.each { |line|
			if regexp1 =~ line
				# Package
				pkg = $~[1]
			elsif regexp2 =~ line
				ver = $~[1]
			elsif regexp3 =~ line
				desc = $~[1]
				unless (pkg.empty? || ver.empty? || desc.empty?)
					installableAry.push [pkg, ver, desc]
				end
				pkg = ""
				ver = ""
				desc = ""
			end
		}
		installableAry
	end

	#=== リマスタリング環境の保存
	#
	#リマスタリング作業中に保存したファイルを作業用OSのローカルパッケージ検索ディレクトリに退避する。
	#
	#復帰値:: なし
	#
	def backup_resource
		# パッケージインデックス保存用にxxx.listファイルを退避する
		list_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
					RTUtility.get_apt_setting("Dir::State"),
					RTUtility.get_apt_setting("Dir::State::lists"))
		source_list = File.join(RTUtility.get_os_plugin.get_root_dir,
						RTUtility.get_apt_setting("Dir::Etc"),
						RTUtility.get_apt_setting("Dir::Etc::sourcelist"))
		pkg_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
						@glade["entry_pkgdir"].text)
		cache_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
					RTUtility.get_apt_setting("Dir::Cache"),
					RTUtility.get_apt_setting("Dir::Cache::archives"))

		# リマスタOS上の/var/cache/apt/archiveのパッケージを作業用OSのローカルパッケージ検索dirに格納する
		FileUtils.mkdir_p(@glade["entry_pkgdir"].text)
		RTUtility.exec_workOS_command("cp -a " + File.join(cache_dir, "*.deb") + " " +  @glade["entry_pkgdir"].text)

		# リマスタOS上のローカルパッケージ検索ディレクトリのパッケージを作業用OSのローカルパッケージ検索dirに格納する
		RTUtility.exec_workOS_command("cp -a " + File.join(pkg_dir, "*.deb") + " " +  @glade["entry_pkgdir"].text)

		# リマスタOS上の/etc/apt/sources.listを作業用OSのローカルパッケージ検索dirに格納する
		RTUtility.exec_workOS_command("cp -a " + source_list + " " + @glade["entry_pkgdir"].text) if File.exist?(source_list)

		# リマスタ対象OS上の/var/lib/apt/listsを作業用OSのローカルパッケージ検索dirに格納する
		if File.directory?(list_dir)
			RTUtility.exec_workOS_command("cp -a " + list_dir + " " + @glade["entry_pkgdir"].text)
			local_list_dir = File.join(@glade["entry_pkgdir"].text, RTUtility.get_apt_setting("Dir::State::lists"))
			FileUtils.rm_rf([File.join(local_list_dir, "lock"), File.join(local_list_dir, "partial")])
		end
	end

end
