#!/usr/bin/env ruby
#
#

require 'remastering/pluginBaseExport'
require 'remastering/remastertool_utility'

require "gettext"
require 'rexml/document'


class Xml < PluginBaseExport
  include GetText

	PROG_NAME = "remastertool_plugin_xml"
	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	# constant definition
	DISPLAY_NAME	= "XML"				# display name
	VERSION			= "V1.0"			# plugin version 

	#メッセージ定義
	MSG_ERR_LOAD_PROC = _("Error occured while reading the remastering procedure file.\n\n%s")
	MSG_ERR_SAVE_PROC = _("Error occured while storing the remastering procedure file.\n\n%s")

	# ファイルタイプ情報
	TYPE_DESC = _("remastering procedure file")
	EXT = "rpml"

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super()
		@display_name = DISPLAY_NAME
		@version = VERSION
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE
		@have_about = true				# about dialog is having
		@have_option = false			# Option dialog is not having

		@tool_min_vl = "V1.0"
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#===リマスタリング手順ファイルの保存
	#
	#パラメタで指定されたXMLドキュメントをファイルに保存する
	#
	#fname:: 保存先リマスタリング手順ファイル
	#doc:: リマスタリング手順XMLドキュメント
	#復帰値:: BOOL  true=保存成功, false=保存失敗
	#
	def write_procedure(fname, doc)
		begin
			open(fname, "w"){ |fs| doc.write(fs, 0) }
			true
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow,
					Gtk::Dialog::MODAL, Gtk::MessageDialog::ERROR,
					Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_SAVE_PROC, $!.to_s))
			dlg.run
			dlg.destroy
			false
		end
	end

	#===リマスタリング手順ファイルのロード
	#
	#パラメタで指定されたファイルからリマスタリング手順を読み込む。
	#
	#fname:: リマスタリング手順ファイル名
	#復帰値:: 正常終了時=XMLドキュメント(REXML::Document)、異常終了時:nil
	#
	def read_procedure(fname)
		doc = nil
		begin
			# リマスタリング手順ファイルを開き、REXMLでパーズする。
			open(fname) {|fs|
				doc = REXML::Document.new fs
			}

		rescue
			# 発生した例外をメッセージダイアログで表示する
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow,
					Gtk::Dialog::MODAL, Gtk::MessageDialog::ERROR,
					Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_LOAD_PROC, $!.to_s))
			dlg.run
			dlg.destroy
			doc = nil
		end
		doc
	end

	#===保存ファイルの形式取得
	#
	#プラグインで保存するファイル形式の情報を返却する
	#
	#復帰値:: Array [説明, 拡張子]
	#
	def get_file_type()
		[TYPE_DESC, EXT]
	end

end
