require "remastering/remastertool_const"
require "remastering/pluginBase"

class PluginBaseMedia < PluginBase

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		super
		@can_accel = false
	end

	#=== プラグイン形式の取得
	#
	#プラグインの形式を返却する。メディアプラグインでは"MEDIA"を返却する。
	#
	#復帰値:: プラグインタイプ("MEDIA")
	#
	def get_plugin_type
		PLUGIN_TYPE_MEDIA
	end

	#=== ディストリビューション作成画面に表示するプラグイン固有域のWidge取得
	#
	#ディストリビューション作成画面に表示するプラグイン固有域のWidgを返却する。
	#
	#復帰値:: ディストリビューション作成画面に表示するプラグイン固有域のWidge
	#
	def get_makeDist_widget
		nil
	end

	#=== メディアの作成
	#
	#パラメタで取得したメディアディレクトリの内容をISOイメージ化する。
	#
	#media_dir:: OSメディア内容格納ディレクトリ
	#復帰値:: BOOL : true=成功、false=失敗
	#
	def create_media_image(media_dir)
		true
	end

	#=== リマスタリング対象OSの起動高速化の可/不可の取得
	#
	#リマスタリング対象OSで起動高速化の適用が可能か否かを返却する。
	#
	#復帰値:: BOOL true=起動高速化適用可能、false=起動高速化適用不可
	#
	def can_accelerate?
		@can_accel
	end


	#===メディアイメージファイルパスの取得
	#
	#作成したメディア形式ファイルのパスを返却する。
	#起動高速化適用時にemulatorプラグインから呼び出される。
	#
	#復帰値:: 作成したメディア形式ファイルのパス
	#
	def get_output_image
		""
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成時にメディアを作成する前に呼び出され、設定内容に誤りがないか確認を行う。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		true
	end

end