require "remastering/remastertool_const"
require "remastering/pluginBase"

class PluginBasePackage < PluginBase

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		super
	end

	#=== プラグイン形式の取得
	#
	#プラグインの形式を返却する。パッケージプラグインでは"PACKAGE"を返却する。
	#
	#復帰値:: プラグインタイプ("PACKAGE")
	#
	def get_plugin_type
		PLUGIN_TYPE_PACKAGE
	end

	#=== パッケージ形式の取得
	#
	#プラグインのパッケージ形式を返却する。
	#
	#復帰値:: パッケージの形式(RPM, Deb, etc)
	#
	def get_package_type
		@package_type
	end

	#=== ディストリビューション作成時の設定項目チェック
	#
	#ディストリビューション作成時画面でOSイメージを作成する直前に呼び出され、
	#設定項目のチェックを実施する。
	#
	#復帰値:: BOOL true=設定エラーなし、false=設定エラーあり
	#
	def check_for_make_distribution
		true
	end

	#=== インストール済みパッケージの一覧取得
	#
	#リマスタリング対象OS上にインストールされているパッケージの一覧を取得する。
	#
	#復帰値:: インストール済みパッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージサイズ, パッケージ説明文]
	#
	def get_installed_packages
		Array.new
	end

	#=== インストール可能パッケージの一覧取得
	#
	#リマスタリング対象OS上にインストール可能なパッケージの一覧を取得する。
	#
	#復帰値:: インストール可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_installable_packages
		Array.new
	end

	#=== 読み込み可能パッケージの一覧取得
	#
	#作業用OS上で読み込み可能なパッケージの一覧を取得する。
	#
	#復帰値:: 読み込み可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_readable_packages
		Array.new
	end

	#=== 依存パッケージ一覧の取得
	#
	#パラメタの操作を行うことによりインストールまたはアンインストールされるパッケージの一覧
	#を返却する。
	#また、パラメタ download が true の場合、パッケージをキャッシュディレクトリにダウン
	#ロードする。
	#
	#name::操作対象パッケージ名
	#version::パッケージバージョン
	#opration::操作(true=インストール、false=アンインストール)
	#download::パッケージのダウンロードの要/不要。true=要、false=不要(省略時はfalse)
	#復帰値:: 依存パッケージ情報の2次元配列
	#          ary1[ary2, ary2, ary2...]
	#          ary2= [パッケージ名、バージョン、操作(true=インストール、false=アンインストール),
	#					 インストール/アンインストール操作コマンド]
	#
	def get_depend_packages(name, opration, download = false)
		Array.new
	end

	#=== パッケージのインストール
	#
	#引数のパッケージ情報配列にしたがってパッケージのインストール/アンインストールを実施する。
	#インストール/アンインストールが成功したパッケージについてはパッケージ情報配列の実行済フラグ
	#をtrueに設定する。
	#
	#pkgAry::パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、操作, 実行済フラグ(true=実行済、false=未実行]
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def install_package(pkgAry)
		pkgAry.each{|ary| ary[3] = true }
		true
	end

	#=== パッケージの作成
	#
	#パッケージ作成画面で設定した情報にしたがってパッケージを作成する。
	#
	#復帰値:: なし
	#
	def make_package
	end

	#=== パッケージの読み込み
	#
	#指定されたパッケージの読み込み、パッケージ作成画面に表示している部品に設定する
	#
	#復帰値:: なし
	#
	def read_package(name, version)
	end

	#=== パッケージインデックスの更新
	#
	#パッケージインデックスを最新化する。
	#
	#復帰値:: なし
	#
	def update_package_index
	end

	#=== インストール後の環境掃除
	#
	#インストール成功後にパッケージファイルなどの掃除を行う。
	#
	#復帰値:: なし
	#
	def clear
	end
end