#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_fixedGlade'
require 'remastering/remastertool_module'

class RemastertoolFixed < RemastertoolFixedGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	PROG_PATH = "remastertool_fixed.glade"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	FUNC_NAME = _("Fixed processing")

	HEADER_LIST = [_("command"), _("parameter"), _("executed timing"), "timing index", _("executed")]
	TIMING_LIST = [_("before install package"), _("before exchange file"),
					_("before create os image"), _("after create os image") ]

	# XMLプラグイン向けの XML要素
	XML_ROOT = ["FixedProcInfo", _("Fixed_processing_information")]
	XML_PROCESS = ["fixedProcess", _("fixed_process")]
	XML_PROC_XPATH = XML_ROOT[0] + "/" + XML_PROCESS[0]
	XML_ATTR_NAME = ["command", _("command")]
	XML_ATTR_PARAM = ["parameter", _("parameter")]
	XML_ATTR_TIMING = ["timing", _("executed timing")]
	XML_ATTR_EXEC = ["exec", _("execution")]
	XML_DO_EXECUTED = [_("done"), _("not done")]

	# message definition
	MSG_WARN_NO_CMD = _("Please sepcify a command")
	MSG_ERR_CMD = _("The error occurred while executing the fixed form processing of %s(%d).")
	MSG_WAIT_FIXED_PROC = _("Now executing fixed procedure.\nPlease wait for a while.")

	#=== コンストラクタ
	#
	#画面オブジェクトの作成&初期状態への設定を行う。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルのドメイン名
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
	
		@modified = false
		@treeFile = nil

		create_parts		# ツリー&定型処理一覧リストの作成
		init_environ		# 環境の初期化
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@glade["treeview_right"].model.clear
		@glade["entry_main_cmd"].text = ""
		@glade["entry_main_param"].text = ""
		@glade["combobox_timing"].active = 0
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		ary = Array.new
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				ary.push( [ iter[4] == true.to_s, FUNC_NAME, iter[2], iter[0] + " " + iter[1] ] )
			end while iter.next!
		end
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		i = 0
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				iter[4] = list[i][0].to_s
				i+= 1
			end while iter.next!
		end
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# XMLドキュメントから メディアディレクトリと作業用ディレクトリを抽出し、
		# インスタンス変数と対応するエントリに設定する。
		root.get_elements(XML_PROC_XPATH).each{|elm|
			name = elm.attributes[XML_ATTR_NAME[0]]
			param = elm.attributes[XML_ATTR_PARAM[0]]
			timing = elm.attributes[XML_ATTR_TIMING[0]]
			executed = elm.attributes[XML_ATTR_EXEC[0]]
			next if name == nil || param == nil || timing == nil || executed == nil
			# 定型処理一覧リストに追加する
			RTUtility.add_list(@glade["treeview_right"], [ name, param, TIMING_LIST[timing.to_i], timing, executed], true)
		}

		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(コマンドテストプラグイン)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])
		
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				elm = REXML::Element.new(XML_PROCESS[localize])
				elm.add_attribute(XML_ATTR_NAME[localize], iter[0])
				elm.add_attribute(XML_ATTR_PARAM[localize], iter[1])
				if localize == 0
					elm.add_attribute(XML_ATTR_TIMING[localize], iter[3])
					elm.add_attribute(XML_ATTR_EXEC[localize], (iter[4] && iter[4].casecmp(true.to_s) == 0) ? true.to_s : false.to_s)
				else
					elm.add_attribute(XML_ATTR_TIMING[localize], iter[2])
					elm.add_attribute(XML_ATTR_EXEC[localize], (iter[4] && iter[4].casecmp(true.to_s) == 0) ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
				end
				elmRoot.add_element elm
			end while iter.next!
		end
		elmRoot

	end

	#===定型処理の実行
	#
	#proc_typeで指定された実行タイミングの定型処理を実行する。
	#
	#proc_type:: タイミング
	#復帰値:: BOOL。true=正常終了, false=異常終了
	#
	def do_fixed_procedure(proc_type)
		return true unless (iter = @glade["treeview_right"].model.iter_first)
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_FIXED_PROC)
		begin
			if iter[4] != true.to_s && proc_type.to_s == iter[3]
				cmd = iter[0] + " " + iter[1]
				status = RTUtility.exec_workOS_command(cmd)
				unless status == 0
					RTUtility.end_wait_window
					# 実行NGの場合、エラーメッセージを表示する。
					dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
							Gtk::MessageDialog::ERROR,
							Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_CMD, TIMING_LIST[proc_type], status))
					dlg.run
					dlg.destroy
					RTUtility.get_logger.error("fixed:do_fixed_procedure " + sprintf(MSG_ERR_CMD, TIMING_LIST[proc_type], status))
					return false
				end
				iter[4] = true.to_s
				@modified = true
			end
			RTUtility.end_wait_window
		end while iter.next!
		true
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		@treeFile.refresh if @treeFile
	end

private

	#=== 定型処理リストの作成
	#
	#定型処理リストを作成する。
	#
	#復帰値:: なし
	#
	def create_parts
		# 作業用OSファイルツリーの作成
		@treeFile = RTFileTreeView.new
		@glade["scrolledwindow_left"].add(@treeFile)
		# ツリー選択変更時のシグナルを登録する
		@treeFile.selection.signal_connect("changed"){ |widget|
			path = @treeFile.get_selected_file
			@glade["entry_main_cmd"].text = path if path
		}

		# コンボボックスの作成
		TIMING_LIST.each {|str| @glade["combobox_timing"].append_text(str)}

		# 定型処理一覧リストの作成
		HEADER_LIST.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_right"].append_column(column)
		}

		model = Gtk::ListStore.new(String, String, String, String, String)
		@glade["treeview_right"].set_model(model)
		@glade["treeview_right"].get_column(3).visible = false
		@glade["treeview_right"].get_column(4).visible = false
		@glade["treeview_right"].selection.mode = Gtk::SELECTION_MULTIPLE

	end

	#=== [削除]ボタンクリック持のイベントハンドラ
	#
	#[削除]ボタンクリック時に選択中のテスト項目をリストから削除する。
	#
	#widget:: 削除ボタンのWidget
	#復帰値:: なし
	#
	def on_button_main_delete_clicked(widget)
		# ユーティリティクラスを使用してリストで選択中の項目を削除する
		@modified = true if RTUtility.del_list(@glade["treeview_right"])
	end

	#=== [追加]ボタンクリック持のイベントハンドラ
	#
	#[追加]ボタンクリック時に左ペインの内容をリストに追加する。
	#
	#widget:: 追加ボタンのWidget
	#復帰値:: なし
	#
	def on_button_main_add_clicked(widget)
		begin
			raise MSG_WARN_NO_CMD if @glade["entry_main_cmd"].text.strip.empty?
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
										 Gtk::MessageDialog::WARNING,
										 Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return
		end

		# 定型処理一覧リストに追加する
		if RTUtility.add_list(@glade["treeview_right"],
			[ @glade["entry_main_cmd"].text.strip, @glade["entry_main_param"].text.strip,
			 @glade["combobox_timing"].active_text, @glade["combobox_timing"].active.to_s])
			@modified = true 

			if @glade["combobox_timing"].active <= (TIMING_LIST.size - 1)
				RTUtility.need_osimage_remake
			end
		end

		# 追加したデータをエントリ領域から削除する
		@glade["entry_main_cmd"].text = ""
		@glade["entry_main_param"].text = ""
		@glade["combobox_timing"].active = 0
	end

	#=== ポップアップメニューの[削除]クリック時のイベントハンドラ
	#
	#削除ボタンクリック時のイベントハンドラを呼び出し、[削除]ボタンクリック時と同じ動作を
	#実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_fixed_proc_menu_delete_activate(widget)
		on_button_main_delete_clicked(@glade["button_main_delete"])
	end

	#=== [操作ファイル一覧]リスト上でのマウスクリック時のイベントハンドラ
	#
	#[操作ファイル一覧]リスト上でマウスを右クリックしたときにポップアップメニューを表示する。
	#
	#widget:: [操作ファイル一覧]リストのWidget
	#event:: イベント
	#復帰値:: なし
	#
	def on_treeview_right_button_press_event(widget, event)
		if event.kind_of?(Gdk::EventButton) && event.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter|
				select = true
				break
			}
			@glade["fixed_proc_menu_delete"].sensitive = select
			@glade["menu_fixed_list"].popup(nil, nil, event.button, event.time)
		end
	end

end
