#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'optparse'

require 'remastering/remastertool_const'
require 'remastering/glade/remastertool_makepackageGlade'
require 'remastering/remastertool_module'
require 'remastering/rtTreeView'
require 'remastering/remastertool_utility'

bindtextdomain(PROG_NAME, nil, nil, "UTF-8")


MSG_ERR_NOGLADE = _("Cannot find glade files\nPlease check installation environment.\n")
MSG_ERR_NO_PLUGIN = _("Cannot find %s plugin.\nPlease check installation environment.\n")

class RemastertoolMakePackage < RemastertoolMakepackageGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

unless __FILE__ == $0
	PROG_PATH = "remastertool_makepackage.glade"
end

	LBL_TREE_FILE = _("Work OS file")
	LBL_TREE_PKG = _("Packages")

	HEADER_LIST_SELECTED = [_("Name"), _("Directory"), "pkgdir"]
	HEADER_LIST_EDIT = [_("Package"), _("Version"), _("Description")]

	TITLE_MKPKGTOOL = _("1CD Linux/Unix package making tool")

	#=== パッケージ作成画面の初期化処理
	#
	#パッケージ作成画面を初期化する。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルドメイン名
	#package_pane:: パッケージ追加/削除画面のインスタンス
	#復帰値:: なし
	#
	def initialize(gladeDir, domain, package_pane = nil)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
	
		if __FILE__ == $0
			RTUtility.setObjs(nil, @glade["window1"])

			# optionメニューを作成する
			@menu_option = RTUtility.create_menu_option(@glade["menuitem_option_menu"])
			# Helpメニューを作成する
			@menu_help = RTUtility.create_menu_help(@glade["menuitem_help_menu"])
		end

		@treeFile = nil
		@pluginPane = []
		@package_pane = package_pane
		@readble_list = Array.new
	
		# create pane parts
		create_parts

		# init_environment
		init_environ
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@readble_list.each{|widget| widget.child.model.clear}
		fix_procedure
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#本ペインでは保存する手順がないため本メソッド処理は行わない(常にnilを返却する)。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#        手順なし=nil
	#
	def get_procedure_list
		nil
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から自ペインに対する情報を抽出する。
	#本ペインでは保存する手順がないため本メソッドで処理は行わない。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#本ペインでは保存する手順がないため本メソッドで処理は行わない。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		nil
	end

	#===パッケージ作成ツールメインウインドウの表示
	#
	#パッケージ作成ツールとして起動した場合に呼び出され、メインウインドウの可視化を行う。
	#
	#復帰値:: なし
	#
	def show_main_window
		@glade["window1"].title = TITLE_MKPKGTOOL
		@glade["window1"].show_all
		@pluginPane.each {|pane| pane.hide }
		@pluginPane[0].show
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		@readble_list.each{|widget|
#			widget.child.model.clear
			widget.child.model = Gtk::ListStore.new(String, String, String)
		}
		on_notebook_left_switch_page(@glade["notebook_left"], @glade["notebook_left"].get_nth_page(@glade["notebook_left"].page), @glade["notebook_left"].page)
		@treeFile.refresh
	end

private

	#=== 画面作成
	#
	#パッケージ作成画面を構成する部品を初期化する。
	#
	#復帰値:: なし
	#
	def create_parts
		# 作業用OSツリーの作成
		@treeFile = RTFileTreeView.new
		# ツリークリック時のシグナルを登録する
		@treeFile.signal_connect("button_press_event") {|widget, event|
			if event.kind_of?(Gdk::EventButton) && event.button == 3
				@glade["item_workos_add"].sensitive = widget.selection.selected ? true : false
				@glade["menu_workos_tree"].popup(nil, nil, event.button, event.time)
			end
		}
		@glade["scrolledwindow_note1"].add(@treeFile)
	
		# 編集するパッケージリストの作成(パッケージタイプ毎）
		RTUtility.get_package_plugins.each { |key, value|
			treeview = Gtk::TreeView.new
			HEADER_LIST_EDIT.each_with_index { |name, i|
				column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
				column.resizable = true
				treeview.append_column(column)
			}
			model = Gtk::ListStore.new(String, String, String)
			treeview.set_model(model)
			treeview.signal_connect("button_press_event"){ |widget, event|
				on_treeview_note_basepkg_button_press_event(widget, event)
			}
			scroll = Gtk::ScrolledWindow.new
			scroll.shadow_type = Gtk::SHADOW_IN
			scroll.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
			scroll.add(treeview)
			scroll.hide
			@glade["vbox_note2"].pack_start(scroll)
			@readble_list.push scroll
		}
		@glade["vbox_note2"].reorder_child(@glade["hbuttonbox_note2"], -1)
	
		# タブの表示を先頭ページ(作業用OSツリー)に設定する
		@glade["notebook_left"].page = 0
#		@glade["notebook_left"].show_all

		# パッケージ内容リストの作成
		HEADER_LIST_SELECTED.each_with_index { |name, i|
		column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
				column.resizable = true
				@glade["treeview_select"].append_column(column)
		}
		model = Gtk::ListStore.new(String, String, String)
		@glade["treeview_select"].get_column(2).visible = false
		@glade["treeview_select"].set_model(model)
		@glade["treeview_select"].selection.mode = Gtk::SELECTION_MULTIPLE

		# パッケージ選択コンボボックスの作成
		RTUtility.get_package_plugins.each { |key, value|
			@glade["combobox_packge_type"].append_text(key)
			widget = value.get_makePackage_widget
			@pluginPane.push(widget)
			widget.reparent @glade["vbox_plugin"]

			widget.hide
		}
		@glade["combobox_packge_type"].active = 0
	end

	#=== [追加]ボタン(ツリー)クリック持のイベントハンドラ
	#
	#[追加]ボタン(ツリー)クリック時に呼び出される。
	#ツリーで選択しているファイル/ディレクトリをパッケージ内容リストに追加する。
	#
	#widget:: [追加]ボタン(ツリー)のWidget
	#復帰値:: なし
	#
	def on_button_tree_add_clicked(widget)
		# ファイル/ディレクトリが選択されているかチェックする。未選択の場合は何もしない。
		path = @treeFile.get_selected_file
		return unless path

		# 選択対象がディレクトリか否かチェックする
		if File.directory? path
			file = ""
			dir = path
		else
			file = File.basename(path)
			dir = File.dirname(path)
		end

		# ユーティリティクラスのリスト追加処理を呼び出し、選択しているファイルをリストに追加する。
		RTUtility.add_list(@glade["treeview_select"], [file, dir, ""])

		# 追加した行が参照できるようにリストの末尾にスクロールする
		@glade["scrolledwindow1"].vadjustment.value = @glade["scrolledwindow1"].vadjustment.upper
	end

	#=== [削除]ボタン(内容リスト)クリック持のイベントハンドラ
	#
	#[削除]ボタン(内容リスト)クリック時に呼び出される。
	#リストで選択しているファイルをリストから削除する。
	#
	#widget:: [削除]ボタン(内容リスト)のWidget
	#復帰値:: なし
	#
	def on_button_select_del_clicked(widget)
		RTUtility.del_list(@glade["treeview_select"])
	end

	#=== [パッケージ形式]コンボボックス変更時のイベントハンドラ
	#
	#[パッケージ形式]コンボボックス変更時時に呼び出される。
	#コンボボックスで選択しているパッケージ形式に対応するプラグインのパッケージ
	#作成画面を表示する。
	#
	#widget:: [パッケージ形式]コンボボックスのWidget
	#復帰値:: なし
	#
	def on_combobox_packge_type_changed(widget)
		@pluginPane.each {|pane| pane.hide }
		@pluginPane[widget.active].show_all
		on_notebook_left_switch_page(@glade["notebook_left"], @glade["notebook_left"].get_nth_page(@glade["notebook_left"].page), @glade["notebook_left"].page)
	end

	#=== [パッケージ化]ボタンクリック時のイベントハンドラ
	#
	#[パッケージ化]ボタンクリック時に呼び出される。
	#設定内容にしたがってパッケージを作成する。
	#
	#widget:: [パッケージ化]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_select_pkg_clicked(widget)
		file_ary = Array.new
		iter = @glade["treeview_select"].model.iter_first
		if iter
			begin
				if iter[0].empty?
					file_ary.push [iter[1], iter[2]]
				else
					file_ary.push [File.join(iter[1], iter[0]), iter[2]]
				end
			end while iter.next!
		end
		pkg_ary = RTUtility.get_package_plugins[@glade["combobox_packge_type"].active_text].make_package file_ary
		if pkg_ary && @package_pane
			# リマスタリングツールでパッケージを作成した場合はパッケージをインストール対象のパッケージリスト
			# に追加する。
			@package_pane.add_selected_package([pkg_ary[0], pkg_ary[1]], true, pkg_ary)
		end
	end

	#=== [作業用OSファイル]/[編集するパッケージ]notebookページ変更時のイベントハンドラ
	#
	#[作業用OSファイル]/[編集するパッケージ]notebookのページ変更時に呼び出される。
	#[編集するパッケージ]ページが選択された場合、パッケージタイプに対応したインストール可能
	#パッケージの一覧を表示する。
	#
	#widget::[作業用OSファイル]/[編集するパッケージ]notebookのWidget
	#arg0:: ページWidget
	#arg1:: ページ番号
	#復帰値:: なし
	#
	def on_notebook_left_switch_page(widget, arg0, arg1)
		# 先頭ページ（作業用OSツリー）選択時は何もせずにリターンする
		return if arg1 == 0

		@readble_list.each{|widget| widget.hide}
		idx = @glade["combobox_packge_type"].active
		@readble_list[idx].show_all
		unless @readble_list[idx].child.model.iter_first
			RTUtility.get_package_plugins[@glade["combobox_packge_type"].active_text].get_readable_packages.each{ |ary|
				RTUtility.add_list(@readble_list[idx].child, ary, true)
			}
			# =リストの先頭カラムでソート
			@readble_list[idx].child.model.set_sort_column_id(0)
		end
	end

	#=== [パッケージの読み込み]ボタンクリック時のイベントハンドラ
	#
	#[パッケージの読み込み]ボタンクリック時に呼び出される。
	#パッケージプラグインのパッケージ展開処理を呼びだし、パッケージの展開を行う。
	#
	#widget:: [パッケージの読み込み]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_pkg_edit_clicked(widget)
		iter = @readble_list[@glade["combobox_packge_type"].active].child.selection.selected
		return unless iter	# 選択なしの場合は何もしない

		# パッケージプラグインのパッケージ読み込み処理を呼び出す。
		file_ary = RTUtility.get_package_plugins[@glade["combobox_packge_type"].active_text].read_package(
			iter[0], iter[1])

		# 取得したファイル一覧をファイル一覧リストに設定する
		@glade["treeview_select"].model.clear
		file_ary.each{|ary| RTUtility.add_list(@glade["treeview_select"], ary, true) } if file_ary
	end

	#=== ポップアップメニューの[追加]クリック時のイベントハンドラ(作業用OSツリー)
	#
	#追加ボタンクリック時のイベントハンドラを呼び出し、[追加]ボタンクリック時と
	#同じ動作を実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_workos_add_activate(widget)
		on_button_tree_add_clicked(@glade["button_tree_add"])
	end

	#=== [編集するパッケージ一覧]リスト上でのマウスクリック時のイベントハンドラ
	#
	#[編集するパッケージ一覧]リスト上でマウスを右クリックしたときにポップアップメニューを表示する。
	#
	#widget:: [編集するパッケージ一覧]リストのWidget
	#event:: イベント
	#復帰値:: なし
	#
	def on_treeview_note_basepkg_button_press_event(widget, event)
		if event.kind_of?(Gdk::EventButton) && event.button == 3
			@glade["item_editpkg_edit"].sensitive = widget.selection.selected ? true : false
			@glade["menu_edit_package"].popup(nil, nil, event.button, event.time)
		end
	end

	#=== ポップアップメニューの[パッケージの読み込み]クリック時のイベントハンドラ(操作ファイル一覧リスト)
	#
	#パッケージの読み込みボタンクリック時のイベントハンドラを呼び出し、[パッケージの読み込み]ボタン
	#クリック時と同じ動作を実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_editpkg_edit_activate(widget)
		on_button_pkg_edit_clicked(@glade["button_pkg_edit"])
	end

	#=== [パッケージ内容一覧]リスト上でのマウスクリック時のイベントハンドラ
	#
	#[パッケージ内容一覧]リスト上でマウスを右クリックしたときにポップアップメニューを表示する。
	#
	#widget:: [パッケージ内容一覧]リストのWidget
	#event:: イベント
	#復帰値:: なし
	#
	def on_treeview_select_button_press_event(widget, event)
		if event.kind_of?(Gdk::EventButton) && event.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter| select = true; break	}
			@glade["item_filelist_delete"].sensitive = select
			@glade["menu_filelist"].popup(nil, nil, event.button, event.time)
		end
	end

	#=== ポップアップメニューの[削除]クリック時のイベントハンドラ(パッケージ内容一覧リスト)
	#
	#削除ボタンクリック時のイベントハンドラを呼び出し、[削除]ボタンクリック時と同じ
	#動作を実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_filelist_delete_activate(widget)
		on_button_select_del_clicked(@glade["button_select_del"])
	end

	#=== [終了]ボタンクリック持のイベントハンドラ
	#
	#パッケージ作成ツールを終了する。
	#
	#widget:: [終了]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_exit_clicked(widget)
		Gtk.main_quit
	end

	#=== [X]ボタンクリック持のイベントハンドラ
	#
	#パッケージ作成ツールを終了する。
	#
	#widget:: [終了]ボタンのWidget
	#復帰値:: なし
	#
	def on_window1_delete_event(widget, arg0)
		Gtk.main_quit
		false
	end

	#=== [ファイル]-[終了]メニュー選択持のイベントハンドラ
	#
	#パッケージ作成ツールを終了する。
	#
	#widget:: [ファイル]-[終了]メニューのWidget
	#復帰値:: なし
	#
	def on_quit_activate(widget)
		on_button_exit_clicked(@glade["button_exit"])
	end

	#=== [ヘルプ]-[パッケージ作成ツールについて]メニュー選択持のイベントハンドラ
	#
	#パッケージ作成ツールのアバウトダイアログを表示する。
	#
	#widget:: [ヘルプ]-[パッケージ作成ツールについて]メニューのWidget
	#復帰値:: なし
	#
	def on_about_activate(widget)
		RTUtility.show_about(TITLE_MKPKGTOOL, PROG_VERSION, SSL_COPYRIGHT, SSL_LICENSE)
	end

end

# Main program
if __FILE__ == $0

	#===パッケージ作成ツールのオプション解析
	#
	#パッケージ作成ツールのオプション解析を行う。
	#
	#復帰値:: なし
	#
	def parse_option
		emu = ""
		os_image = ""
	
		# オプション解析準備
		opt = OptionParser.new
		opt.version = PROG_VERSION
		opt.program_name = PROG_HELP_NAME
		opt.summary_width = 18
		opt.on("-v", ": print version") {|v| puts opt.ver; exit 0 }
		opt.on("-h", ": print this help") {|v| puts opt.help.sub(PROG_HELP_NAME, $0); exit 0 }

		# オプション解析
		begin
			opt.permute!(ARGV)
		rescue
			puts $!.to_s
			exit 1
		end
	end

	#===メイン処理
	#
	#パッケージ作成ツールのメイン処理
	#
	#復帰値:: 0=正常終了、1=異常終了
	#

	# ロガーの設定
	RTUtility.set_logger

	# オプション解析
	parse_option

	# gladeファイルディレクトリの取得
	PROG_PATH = "remastertool_makepackage.glade"
	glade_dir = RTUtility.get_glade_dir(PROG_PATH)
	if glade_dir == nil
		puts MSG_ERR_NOGLADE
		exit 1
	end

	Gtk.init

	# パッケージプラグインをロードする
	RTUtility.load_plugin PLUGIN_TYPE_PACKAGE
	if RTUtility.get_package_plugins.empty?
		puts sprintf(MSG_ERR_NO_PLUGIN, PLUGIN_TYPE_PACKAGE)
		exit 1
	end

	pkgtool = RemastertoolMakePackage.new(glade_dir, PROG_NAME)
	pkgtool.show_main_window
	Gtk.main

	RTUtility.unload_plugin
end
