#!/usr/bin/env ruby

module Remastertool_FuncModule
	#
	# return Box which is pane' top container
	#
	def getBox(new_parent)
		@glade["mainBox"].reparent(new_parent)
	end

	#
	# refresh screen
	#
	def refresh
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@modified = false
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		@modified
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成前に設定内容に誤りがないか確認を行う。
	#パッケージ追加/削除画面ではチェック項目がないので常にtrueで復帰する。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		true
	end

	#=== リマスタリング環境のインポート
	#
	#引数のdirで示すディレクトリ内の資産を現在のリマスタリング環境に適用する。
	#
	#dir:: インポート資源ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def import(dir)
		true
	end

	#=== リマスタリング環境のエクスポート
	#
	#引数のdirで示すディレクトリにの現在のリマスタリング環境資産を格納する。
	#
	#dir:: エクスポート先ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def export(dir)
		true
	end

end
