#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_packageGlade'
require 'remastering/remastertool_module'
require 'remastering/remastertool_utility'

class RemastertoolPackage < RemastertoolPackageGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	PROG_PATH = "remastertool_package.glade"
	PKG_INSTALL = _("Install")
	PKG_UNINSTALL  = _("Uninstall")

	FUNC_NAME = _("Package install/uninstall")

	HEADER_OPELIST = [_("Package"), _("Version"), _("Operation"), "executed", "command"]
	HEADER_PKGLIST = [_("Package"), _("Version"), _("Description")]
	HEADER_INSTPKGLIST = [_("Package"), _("Version"), _("Size"), _("Description")]

	# パッケージインストール/アンインストールペインの XML要素
	XML_ROOT = ["PackageInfo", _("Package add and delete Information")]
	XML_PACKAGE = ["Package", _("Package ")]
	XML_PACKAGE_XPATH = XML_ROOT[0] + "/" + XML_PACKAGE[0]
	XML_ATTR_NAME = ["name", _("name")]
	XML_ATTR_VERSION = ["version", _("version")]
	XML_ATTR_OPERATION = ["operation", _("operation")]
	XML_ATTR_EXECUTED = ["exec", _("execution")]
	XML_DO_EXECUTED = [_("done"), _("not done")]
	XML_ATTR_CMD = [ "command", _("command")]

	OPE_HASH_TO_XML = { PKG_INSTALL => "Install", PKG_UNINSTALL => "Uninstall"}
	OPE_HASH_FROM_XML = OPE_HASH_TO_XML.invert

	MSG_INF_INSTALL_PKG = _("Installing %s package.")
	MSG_INF_UNINSTALL_PKG = _("Uninstalling %s package.")
	MSG_ERR_INSTALL_PKG = _("Failed to installing/uninstalling %s package(%d).")

	#=== コンストラクタ
	#
	#画面オブジェクトの作成&初期状態への設定を行う。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルのドメイン名
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
	
		@init_Pane = false

		# display selected package list
		initialize_selected_package_list

		init_environ
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素(メディアディレクトリと作業用
	#ディレクトリ)を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		model = Gtk::ListStore.new(String, String, String, String, String)
		@glade["treeview_selected"].set_model(model)

		# XMLドキュメントからインストール/アンインストールするパッケージの一覧を抽出し、
		# インストール/アンインストールパッケージ一覧リストに追加する。
		root.get_elements(XML_PACKAGE_XPATH).each {|elm|
			name = elm.attributes[XML_ATTR_NAME[0]]
			version = elm.attributes[XML_ATTR_VERSION[0]]
			operation = elm.attributes[XML_ATTR_OPERATION[0]]
			executed = elm.attributes[XML_ATTR_EXECUTED[0]]
			cmd = elm.attributes[XML_ATTR_CMD[0]]
			next if name == nil || version == nil || operation == nil || executed == nil || cmd == nil
	
			operation = OPE_HASH_FROM_XML[operation]
			RTUtility.add_list(@glade["treeview_selected"],
				[ name, version, operation, executed, cmd], true )
		}
	
		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(REXML::Text.new(XML_ROOT[localize]).to_s)

		iter = @glade["treeview_selected"].model.iter_first
		if iter
			begin
				elm_child = REXML::Element.new(XML_PACKAGE[localize], elmRoot)
				elm_child.add_attribute(XML_ATTR_NAME[localize], iter[0])
				elm_child.add_attribute(XML_ATTR_VERSION[localize], iter[1])
				if localize == 0
					elm_child.add_attribute(XML_ATTR_OPERATION[localize], OPE_HASH_TO_XML[iter[2]])
					elm_child.add_attribute(XML_ATTR_EXECUTED[localize], (iter[3].casecmp(true.to_s) == 0).to_s)
				else
					elm_child.add_attribute(XML_ATTR_OPERATION[localize], iter[2])
					elm_child.add_attribute(XML_ATTR_EXECUTED[localize], iter[3].casecmp(true.to_s) == 0 ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
				end
				elm_child.add_attribute(XML_ATTR_CMD[localize], iter[4])
				
			end while iter.next!
		end
		elmRoot
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#         手順なし=nil
	def get_procedure_list
		ary = Array.new
		iter = @glade["treeview_selected"].model.iter_first
		if iter
			begin
				ary.push( [
					 iter[3].casecmp(true.to_s) == 0, FUNC_NAME, iter[2], iter[0] + " " + iter[1] ] )
			end while iter.next!
		end
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#返却した手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		index = 0
		iter = @glade["treeview_selected"].model.iter_first
		if iter
			begin
				iter[3] = list[index][0].to_s
				index = index + 1
			end while iter.next!
		end
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@glade["treeview_selected"].model.clear
		fix_procedure
	end

	#===パッケージのインストール
	#
	#操作パッケージ一覧リスト中のパッケージのインストール/アンインストールを実施する。
	#
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def install_package
		pkg_ary = Array.new
		iter = @glade["treeview_selected"].model.iter_first
		return true unless iter
		begin
			next if iter[3].casecmp(true.to_s) == 0
			unless iter[4].empty?
				msg = sprintf(iter[2] == PKG_INSTALL ? MSG_INF_INSTALL_PKG : MSG_INF_UNINSTALL_PKG, iter[0])
#				status = RTUtility.exec_remasterOS_command(iter[4],nil, nil, nil, RTUtility.mainWindow, msg, true, true, true)
				status = RTUtility.exec_remasterOS_command_terminal(iter[4], RTUtility.mainWindow, msg)

				unless status == 0
					dlgMsg = sprintf(MSG_ERR_INSTALL_PKG, iter[0], status)
					dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
							Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, dlgMsg)
					dlg.run
					dlg.destroy
					RTUtility.get_logger.error("package:install_package " + dlgMsg)
					return false
				end
			end						
			iter[3] = true.to_s
			@modified = true
		end while iter.next!

		# キャッシュディレクトリ中のパッケージファイルをクリアする
		RTUtility.get_native_pkg_plugin.clear
		true
	end

	#=== インストール/アンインストールパッケージ一覧リストへのパッケージ追加
	#
	#インストール/アンインストールパッケージへ指定されたパッケージを追加する。
	#このときパッケージプラグインの依存パッケージ取得処理を呼び出し、依存パッケ
	#ージも含めたパッケージの一覧をリストに追加する。
	#
	#pkgs:: インストール／アンインストールパッケージ情報配列
	#       [ [インストールパッケージ１, バージョン1], [インストールパッケージ2, バージョン2], ... ]
	#operation:: 操作(true=インストール/false=アンインストール)
	#pkgAry:: パッケージ情報配列
	#          ary1[ary2, ary2, ary2...]
	#          ary2= [パッケージ名、バージョン、操作(true=インストール、false=アンインストール),
	#					 インストール/アンインストール操作コマンド]
	#復帰値:: なし
	#
	def add_selected_package(pkgs, operation, pkgAry = nil)
		# 依存関係でインストール/アンインストールされるパッケージをパッケージプラグインより取得する
		unless pkgAry
			pkgAry = RTUtility.get_native_pkg_plugin.get_depend_packages(pkgs, operation, true)
		end
		pkgAry.each{ |ary|
			RTUtility.add_list(@glade["treeview_selected"],
				[ary[0], ary[1], ary[2] ? PKG_INSTALL : PKG_UNINSTALL, false.to_s, ary[3]], true)
			@modified = true
		}
		RTUtility.need_osimage_remake if @modified	# OSイメージの再作成が必要であることを通知

		# 追加した行が参照できるようにリストのまつびにスクロールする
		@glade["scrolledwindow3"].vadjustment.value = @glade["scrolledwindow3"].vadjustment.upper
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新ん状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		display_installed_package
		display_installable_package
	end

private

	#=== インストール済みパッケージ一覧リストの初期設定
	#
	#インストール済みパッケージ一覧リストのヘッダカラムを作成し、リストを初期化する。
	#
	#復帰値:: なし(nil)
	#
	def initialize_installed_package_list
		# create installed package list(header)
		cols = @glade["treeview_installed"].columns
		cols.each{|col| @glade["treeview_installed"].remove_column(col) }
		HEADER_INSTPKGLIST.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			column.cell_renderers[0].xalign = 1.0 if i == 2
			column.set_sort_column_id(i)
			@glade["treeview_installed"].append_column(column)
		}
	end

	#=== インストール可能パッケージ一覧リストの初期設定
	#
	#インストール可能パッケージ一覧リストのヘッダカラムを作成し、リストを初期化する。
	#
	#復帰値:: なし(nil)
	#
	def initialize_installable_package_list
		# create installed package list(header)
		cols = @glade["treeview_installable"].columns
		cols.each{|col| @glade["treeview_installable"].remove_column(col) }
		HEADER_PKGLIST.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			column.set_sort_column_id(i)
			@glade["treeview_installable"].append_column(column)
		}
	end

	#=== インストール/アンインストールパッケージ一覧リストの初期設定
	#
	#インストール/アンインストールパッケージ一覧リストのヘッダカラムを作成し、リストを初期化する。
	#
	#復帰値:: なし(nil)
	#
	def initialize_selected_package_list
		# create list header
		HEADER_OPELIST.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_selected"].append_column(column)
		}
		# unvisible column
		@glade["treeview_selected"].get_column(3).visible = false
		@glade["treeview_selected"].get_column(4).visible = false

		model = Gtk::ListStore.new(String, String, String, String, String)
		@glade["treeview_selected"].set_model(model)
		@glade["treeview_selected"].selection.mode = Gtk::SELECTION_MULTIPLE
	
	end

	#=== インストール済みパッケージ一覧の表示
	#
	#パッケージプラグインの「get_installed_packages」メソッドを呼び出し。リマスタリング
	#対象OSにインストールされているパッケージの一覧を取得する。
	#取得した一覧はインストール済みパッケージ一覧リストに表示する。
	#
	#復帰値:: なし(nil)
	#
	def display_installed_package
		# リストのカラムを作成する
		initialize_installed_package_list

		# 現在のインストール可能パッケージ一覧をクリアする。
		# 今まで使用していたListStoreを再利用すると遅くなるので別のListStoreを作成する
		model = Gtk::ListStore.new(String, String, Integer, String)
		@glade["treeview_installed"].set_model(model)
		@glade["treeview_installed"].selection.mode = Gtk::SELECTION_MULTIPLE

		# call package plugin "get_installed_packages" method
		pkgList = RTUtility.get_native_pkg_plugin.get_installed_packages
		pkgList.each{ |ary|
			iter = @glade["treeview_installed"].model.append
			iter[0] = ary[0]
			iter[1] = ary[1]
			iter[2] = ary[2].to_i
			iter[3] = ary[3]
#			RTUtility.add_list(@glade["treeview_installed"], ary, true)
		}
		@glade["treeview_installed"].model.set_sort_column_id(0)	# =リストの先頭カラムでソート
	end

	#=== インストール可能パッケージ一覧の表示
	#
	#パッケージプラグインの「get_installable_packages」メソッドを呼び出し。リマスタリング
	#対象OSにインストール可能なパッケージの一覧を取得する。
	#取得した一覧はインストール可能パッケージ一覧リストに表示する。
	#
	#復帰値:: なし(nil)
	#
	def display_installable_package
		# リストのカラムを作成する
		initialize_installable_package_list

		# 現在のインストール可能パッケージ一覧をクリアする。
		# 今まで使用していたListStoreを再利用すると遅くなるので別のListStoreを作成する
		model = Gtk::ListStore.new(String, String, String)
		@glade["treeview_installable"].set_model(model)
 		@glade["treeview_installable"].selection.mode = Gtk::SELECTION_MULTIPLE

		# パッケージプラグインからパッケージの一覧を取得し、その内容をインストール
		# 可能パッケージ一覧に設定する。
		RTUtility.get_native_pkg_plugin.get_installable_packages.each{ |ary|
			RTUtility.add_list(@glade["treeview_installable"], ary, true)
		}
		@glade["treeview_installable"].model.set_sort_column_id(0)	# =リストの先頭カラムでソート
	end

	#=== アンインストールボタンのイベントハンドラ
	#
	#[アンインストール]ボタンクリック時にインストール済みパッケージリストで選択中され
	#ているパッケージ一をインストール/アンインストールパッケージリストに追加する。
	#
	#widget:: パッケージインストール/アンインストール画面のWidget
	#復帰値:: なし
	#
	def on_button_installed_clicked(widget)
		pkgs = Array.new
		@glade["treeview_installed"].selection.selected_each{|model, path, iter|
			pkgs.push([iter[0], iter[1]])
		}
		add_selected_package(pkgs, false) unless pkgs.empty?
	end

	#=== ポップアップメニューのイベントハンドラ(インストール済みパッケージ一覧リスト)
	#
	#インストール済みパッケージ一覧リストのポップアップメニューで[アンインストール]を選択した
	#ときに呼び出される。
	#アンインストールボタンクリック時のイベントハンドラを呼び出し、アンインストールボタン
	#クリック時と同じ動作を実施する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_uninstall_activate(widget)
		on_button_installed_clicked(widget)
	end

	#=== インストールボタンのイベントハンドラ
	#
	#[インストール]ボタンクリック時にインストール可能パッケージリストで選択中されている
	#パッケージ一をインストール/アンインストールパッケージリストに追加する。
	#
	#widget:: パッケージインストール/アンインストール画面のWidget
	#復帰値:: なし
	#
	def on_button_installable_clicked(widget)
		pkgs = Array.new
		@glade["treeview_installable"].selection.selected_each{|model, path, iter|
			pkgs.push([iter[0], iter[1]])
		}
		add_selected_package(pkgs, true) unless pkgs.empty?
	end

	#=== ポップアップメニューのイベントハンドラ(インストール可能パッケージ一覧リスト)
	#
	#インストール可能パッケージ一覧リストのポップアップメニューで[インストール]を選択した
	#ときに呼び出される。
	#インストールボタンクリック時のイベントハンドラを呼び出し、インストールボタンクリック時
	#と同じ動作を実施する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_install_activate(widget)
 		on_button_installable_clicked(widget)
	end

	#=== 削除ボタンのイベントハンドラ
	#
	#[削除]ボタンクリック時にインストール/アンインストールパッケージリストで選択中されている
	#パッケージ一を覧から削除する。
	#
	#widget:: パッケージインストール/アンインストール画面のWidget
	#復帰値:: なし
	#
	def on_button_selected_clicked(widget)
		# 内部データの手順一覧リストから選択中のパッケージ情報を削除する
		@glade["treeview_selected"].selection.selected_each{|model, path, iter| @modified = true }

		# ツリーで選択しているパッケージを削除する
		if RTUtility.del_list(@glade["treeview_selected"])
			@modified = true
			RTUtility.need_osimage_remake	# OSイメージの再作成が必要であることを通知
		end
	end

	#=== ポップアップメニューのイベントハンドラ(インストール/アンインストールパッケージ一覧リスト)
	#
	#インストール/アンインストールパッケージ一覧リストのポップアップメニューで[削除]を選択した
	#ときに呼び出される。
	#インストール/アンインストールパッケージリスト中の選択しているパッケージをリストから削除する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_delete_activate(widget)
		on_button_selected_clicked(widget)
	end

	#=== インストール可能パッケージ一覧リストの更新
	#
	#インストール可能パッケージ一覧リストを最新の状態に更新する。
	#
	#復帰値:: なし(nil)
	#
	def on_button_update_clicked(widget)
		RTUtility.get_native_pkg_plugin.update_package_index
		display_installable_package
	end

	#=== mapイベントのイベントハンドラ
	#
	#パッケージインストール/アンインストール画面が表に表示されたときに呼び出される。
	#初期表示が完了していない場合はインストール済みパッケージリスト、インストール可能
	#パッケージリストを表示する。
	#
	#widget:: パッケージインストール/アンインストール画面のWidget
	#復帰値:: なし
	#
	def on_box_map(widget)
		# 初期化が未(状態を保持するインスタンス変数がfalse)の場合だけパッケージリスト
		# 作成メソッドを呼び出す。
		unless @init_Pane
			display_installed_package
			display_installable_package
			@init_Pane = true
		end
	end

	#=== インストール済みパッケージリストのボタンクリックイベントハンドラ
	#
	#インストール済みパッケージリスト上でクリックしたマウスボタンを判定し、右クリック
	#の場合はポップアップメニューを表示する。
	#
	#widget:: treeviewのWidget
	#復帰値:: なし
	#
	def on_treeview_installed_button_press_event(widget, arg0)
		if arg0.kind_of?(Gdk::EventButton) && arg0.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter|
				select = true
				break
			}
			@glade["uninstall"].sensitive = select
			@glade["menu_installed"].popup(nil, nil, arg0.button, arg0.time)
		end
	end

	#=== インストール可能パッケージリストのボタンクリックイベントハンドラ
	#
	#インストール可能パッケージリスト上でクリックしたマウスボタンを判定し、右クリック
	#の場合はポップアップメニューを表示する。
	#
	#widget:: treeviewのWidget
	#復帰値:: なし
	#
	def on_treeview_installable_button_press_event(widget, arg0)
		if arg0.kind_of?(Gdk::EventButton) && arg0.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter|
				select = true
				break
			}
			@glade["install"].sensitive = select
			@glade["menu_installable"].popup(nil, nil, arg0.button, arg0.time)
		end
	end

	#=== インストール/アンインストールパッケージリストのボタンクリックイベントハンドラ
	#
	#インストール/アンインストールパッケージリスト上でクリックしたマウスボタンを判定し、
	#右クリックの場合はポップアップメニューを表示する。
	#
	#widget:: treeviewのWidget
	#復帰値:: なし
	#
	def on_treeview_selected_button_press_event(widget, arg0)
		if arg0.kind_of?(Gdk::EventButton) && arg0.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter|
				select = true
				break
			}
			@glade["delete"].sensitive = select
			@glade["menu_operate"].popup(nil, nil, arg0.button, arg0.time)
		end
	end

	#=== インストール済パッケージ一覧下入力域のキー入力ハンドラ
	#
	#インストール済みパッケージ一覧配下の入力域でキー入力発生時に呼び出しが行われる。
	#入力キーが[Enter]の場合、インストール済パッケージ一覧中の入力した文字列を含む
	#パッケージの行が選択状態となる。
	#
	#widget:: パッケージ名部分文字列入力域のWidget
	#key_event:: 押下したキーイベント
	#復帰値:: なし
	#
	def on_entry_package_key_press_event(widget, key_event)
		case key_event.keyval
		when Gdk::Keyval::GDK_KP_Enter, Gdk::Keyval::GDK_Return
			# [Enter]キーを押下したエントリに対応するツリービューのwidgetを取得する
			if widget == @glade["entry_uninstall_package"]
				treeview = @glade["treeview_installed"]
			else
				treeview = @glade["treeview_installable"]
			end
	
			# 入力キーが Enter キーの場合は入力文字列を含むパッケージ名を持つ
			# インストール済パッケージを選択状態にする。
			selection = treeview.selection
			selection.unselect_all
			regexp = /#{widget.text.strip}/
			iter = treeview.model.iter_first
			first_path = nil
			if iter
				begin
					if iter[0] =~ regexp
						selection.select_iter(iter)
						first_path = iter.path unless first_path
					end
				end while iter.next!
			end
			# マッチした先頭行を再上位行になるようにスクロールする
			treeview.scroll_to_cell(first_path, nil, true, 0.0, 0.0) if first_path
		end
	end

end
